/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.contentcompletion.xml.CIElement;
import ro.sync.contentcompletion.xml.WhatElementsCanGoHereContext;
import ro.sync.ecss.css.Styles;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorSchemaManager;
import ro.sync.ecss.extensions.api.ClassPathResourcesAccess;
import ro.sync.ecss.extensions.api.ContentInterval;
import ro.sync.ecss.extensions.api.UniqueAttributesProcessor;
import ro.sync.ecss.extensions.api.content.OffsetInformation;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.NamespaceContext;
import ro.sync.ecss.extensions.api.schemaaware.SchemaAwareHandlerResult;
import ro.sync.ecss.extensions.commons.operations.MoveCaretUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public final class CommonsOperationsUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)CommonsOperationsUtil.class.getName());

    private CommonsOperationsUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    static Map<String, String> getAttributes(AuthorNode node, boolean includeID) {
        LinkedHashMap<String, String> attributes = null;
        if (node instanceof AuthorElement) {
            AuthorElement element = (AuthorElement)node;
            int attributesCount = element.getAttributesCount();
            for (int i = 0; i < attributesCount; ++i) {
                String attrName = element.getAttributeAtIndex(i);
                AttrValue attrValue = element.getAttribute(attrName);
                if (!attrValue.isSpecified()) continue;
                if (attributes == null) {
                    attributes = new LinkedHashMap<String, String>();
                }
                if (!includeID && ("id".equals(attrName) || "xml:id".equals(attrName))) continue;
                attributes.put(attrName, attrValue.getValue());
            }
        }
        return attributes;
    }

    public static String serializeAttributes(Map<String, String> attributes, Collection<String> attributesToSkip) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> attr : attributes.entrySet()) {
            String attrName = attr.getKey();
            if (attributesToSkip.contains(attrName)) continue;
            String attributeValue = attr.getValue();
            stringBuilder.append(" ").append(attrName).append("=\"").append(attributeValue).append("\"");
        }
        return stringBuilder.toString();
    }

    private static AuthorDocumentFragment createAuthorDocumentFragment(AuthorDocumentController controller, int start, int end, ConversionElementHelper helper) throws BadLocationException, AuthorOperationException {
        AuthorDocumentFragment fragment = helper.createAuthorDocumentFragment(controller, start, end);
        if (fragment == null) {
            fragment = start <= end ? controller.createDocumentFragment(start, end) : controller.createNewDocumentFragmentInContext("", start);
        }
        return fragment;
    }

    public static void unwrapTags(AuthorAccess authorAccess, AuthorNode nodeToUnwrap) throws BadLocationException {
        if (nodeToUnwrap != null && nodeToUnwrap != authorAccess.getDocumentController().getAuthorDocumentNode().getRootElement()) {
            boolean deleteNode;
            int caretOffset = authorAccess.getEditorAccess().getCaretOffset();
            int nodeStartOffset = nodeToUnwrap.getStartOffset();
            int nodeEndOffset = nodeToUnwrap.getEndOffset();
            int nextOffset = caretOffset <= nodeStartOffset ? caretOffset : (caretOffset <= nodeEndOffset ? caretOffset - 1 : caretOffset - 2);
            int contentStart = nodeToUnwrap.getStartOffset() + 1;
            int contentEnd = nodeToUnwrap.getEndOffset() - 1;
            AuthorDocumentFragment unwrapped = null;
            if (contentStart <= contentEnd) {
                unwrapped = authorAccess.getDocumentController().createDocumentFragment(contentStart, contentEnd);
            }
            if ((deleteNode = authorAccess.getDocumentController().deleteNode(nodeToUnwrap)) && unwrapped != null) {
                authorAccess.getDocumentController().insertFragment(nodeStartOffset, unwrapped);
                authorAccess.getEditorAccess().setCaretPosition(nextOffset);
            }
        }
    }

    public static void surroundWithFragment(AuthorAccess authorAccess, boolean schemaAware, String xmlFragment) throws AuthorOperationException {
        int piOffset;
        boolean moveCaretToSpecifiedPosition = MoveCaretUtil.hasImposedEditorVariableCaretOffset(xmlFragment);
        int n = piOffset = authorAccess.getEditorAccess().hasSelection() ? Math.min(authorAccess.getEditorAccess().getSelectionStart(), authorAccess.getEditorAccess().getSelectionEnd()) : authorAccess.getEditorAccess().getCaretOffset();
        if (authorAccess.getEditorAccess().hasSelection()) {
            CommonsOperationsUtil.surroundWithFragment(authorAccess, xmlFragment, authorAccess.getEditorAccess().getSelectionStart(), authorAccess.getEditorAccess().getSelectionEnd() - 1);
        } else {
            int insertionOffset = authorAccess.getEditorAccess().getCaretOffset();
            if (!schemaAware) {
                authorAccess.getDocumentController().insertXMLFragment(xmlFragment, insertionOffset);
            } else {
                Integer off;
                SchemaAwareHandlerResult result = authorAccess.getDocumentController().insertXMLFragmentSchemaAware(xmlFragment, insertionOffset);
                if (result != null && (off = (Integer)result.getResult("result.id.handle.insert.fragment.offset")) != null) {
                    piOffset = off;
                }
            }
        }
        if (moveCaretToSpecifiedPosition) {
            MoveCaretUtil.moveCaretToImposedEditorVariableOffset(authorAccess, piOffset);
        }
    }

    public static int surroundWithFragment(AuthorAccess authorAccess, String xmlFragment, int start, int end) throws AuthorOperationException {
        int[] balancedSelection = authorAccess.getEditorAccess().getBalancedSelection(start, end + 1);
        authorAccess.getDocumentController().surroundInFragment(xmlFragment, balancedSelection[0], balancedSelection[1] - 1);
        return authorAccess.getEditorAccess().getSelectionStart();
    }

    public static String setAttributeValue(AuthorDocumentController ctrl, AuthorElement targetElement, QName attributeQName, String value, boolean removeIfEmpty) {
        return CommonsOperationsUtil.setAttributeValue(ctrl, targetElement, attributeQName, value, value, removeIfEmpty);
    }

    public static String setAttributeValue(AuthorDocumentController ctrl, AuthorElement targetElement, QName attributeQName, String value, String normalizedValue, boolean removeIfEmpty) {
        boolean addNamespaceDeclaration = false;
        Object attributeName = attributeQName.getLocalPart();
        String prefix = null;
        String namespace = attributeQName.getNamespaceURI();
        if (namespace != null && !"".equals(namespace)) {
            String attributeQNameOnElement = CommonsOperationsUtil.getAttributeQName(targetElement, attributeQName.getLocalPart(), attributeQName.getNamespaceURI());
            if (attributeQNameOnElement != null) {
                attributeName = attributeQNameOnElement;
            } else {
                NamespaceContext namespaceContext = targetElement.getNamespaceContext();
                prefix = namespaceContext.getPrefixForNamespace(namespace);
                if (prefix != null && !"".equals(prefix)) {
                    attributeName = prefix + ":" + (String)attributeName;
                } else if (attributeQName.getPrefix() != null && !attributeQName.getPrefix().isEmpty() && namespaceContext.getNamespaceForPrefix(attributeQName.getPrefix()) == null) {
                    prefix = attributeQName.getPrefix();
                    addNamespaceDeclaration = true;
                    attributeName = prefix + ":" + (String)attributeName;
                } else {
                    prefix = CommonsOperationsUtil.buildFreshPrefix(namespaceContext);
                    addNamespaceDeclaration = true;
                    attributeName = prefix + ":" + (String)attributeName;
                }
            }
        }
        if (value == null || "".equals(value) && removeIfEmpty) {
            if (!addNamespaceDeclaration) {
                ctrl.removeAttribute((String)attributeName, targetElement);
            }
        } else {
            if (addNamespaceDeclaration) {
                AttrValue nsAttrValue = new AttrValue(namespace);
                ctrl.setAttribute("xmlns:" + prefix, nsAttrValue, targetElement);
            }
            AttrValue attrValue = new AttrValue(normalizedValue, value, true);
            ctrl.setAttribute((String)attributeName, attrValue, targetElement);
        }
        return attributeName;
    }

    private static String getAttributeQName(AuthorElement element, String attrLocalName, String attrNSURI) {
        String match = null;
        int attrsCount = element.getAttributesCount();
        for (int i = 0; i < attrsCount; ++i) {
            String attributeName = element.getAttributeAtIndex(i);
            if (!attrLocalName.equals(CommonsOperationsUtil.getLocalName(attributeName))) continue;
            String attrNS = element.getAttributeNamespace(CommonsOperationsUtil.getPrefix(attributeName));
            if ((attrNSURI != null || attrNS != null) && (attrNSURI == null || !attrNSURI.equals(attrNS))) continue;
            match = attributeName;
            break;
        }
        return match;
    }

    public static String buildFreshPrefix(NamespaceContext namespaceContext) {
        String prefix = null;
        int candidate = 1;
        while (namespaceContext.getNamespaceForPrefix("ns" + candidate) != null) {
            ++candidate;
        }
        prefix = "ns" + candidate;
        return prefix;
    }

    public static URL locateResourceInClasspath(AuthorAccess authorAccess, String resourceFileName) {
        return CommonsOperationsUtil.locateResourceInClasspathFolder(authorAccess, "resources", resourceFileName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static URL locateResourceInClasspathFolder(AuthorAccess authorAccess, String folderName, String resourceFileName) {
        int i;
        URL[] resources;
        URL resourceURL = null;
        ClassPathResourcesAccess classPathResourcesAccess = authorAccess.getClassPathResourcesAccess();
        if (classPathResourcesAccess == null || (resources = classPathResourcesAccess.getClassPathResources()) == null) return resourceURL;
        ArrayList<URL> proposedResourceURLs = new ArrayList<URL>();
        for (i = 0; i < resources.length; ++i) {
            URL resource = resources[i];
            String resourceStr = resource.toExternalForm();
            if (!resourceStr.endsWith("/" + folderName + "/") && !resourceStr.endsWith("/" + folderName)) continue;
            try {
                proposedResourceURLs.add(new URL(resource, resourceFileName));
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (proposedResourceURLs.isEmpty()) return resourceURL;
        resourceURL = (URL)proposedResourceURLs.get(0);
        if (proposedResourceURLs.size() <= 1) return resourceURL;
        for (i = 0; i < proposedResourceURLs.size(); ++i) {
            URL url = (URL)proposedResourceURLs.get(i);
            try (InputStream is = url.openStream();){
                is.read();
                resourceURL = url;
                return resourceURL;
            }
            catch (IOException iOException) {
                continue;
            }
        }
        return resourceURL;
    }

    public static URL expandAndResolvePath(AuthorAccess authorAccess, String path) {
        URL resolved;
        URL url;
        block12: {
            url = null;
            String expanded = authorAccess.getUtilAccess().expandEditorVariables(path, null);
            try {
                url = new URL(expanded);
            }
            catch (MalformedURLException e1) {
                try {
                    File file = new File(expanded);
                    if (file.exists()) {
                        url = authorAccess.getUtilAccess().convertFileToURL(file);
                    }
                }
                catch (MalformedURLException file) {
                }
                catch (AccessControlException e) {
                    logger.debug("Cannot access the path: " + path, (Throwable)e);
                }
                if (url != null) break block12;
                try {
                    String frameworkDir = authorAccess.getUtilAccess().expandEditorVariables("${frameworkDir}", null);
                    File file = new File(frameworkDir, expanded);
                    if (file.exists()) {
                        url = authorAccess.getUtilAccess().convertFileToURL(file);
                    }
                }
                catch (MalformedURLException frameworkDir) {
                }
                catch (AccessControlException e) {
                    logger.debug("Cannot access the path: " + path, (Throwable)e);
                }
            }
        }
        if (url != null && (resolved = authorAccess.getXMLUtilAccess().resolvePathThroughCatalogs(null, url.toString(), true, true)) != null) {
            url = resolved;
        }
        return url;
    }

    public static String getPrefix(String qName) {
        String prefix = null;
        if (qName != null) {
            int idx = qName.indexOf(58);
            prefix = "";
            if (idx != -1) {
                prefix = qName.substring(0, idx);
            }
        }
        return prefix;
    }

    public static String getLocalName(String qName) {
        int idx;
        String local = qName;
        if (qName != null && (idx = qName.lastIndexOf(58)) != -1) {
            local = qName.substring(idx + 1);
        }
        return local;
    }

    public static void removeUnwantedAttributes(String[] skippedAttributes, AuthorDocumentFragment fragment, AuthorDocumentController controller) {
        AuthorNode node;
        List fragNodes = fragment.getContentNodes();
        if (fragNodes != null && !fragNodes.isEmpty() && (node = (AuthorNode)fragNodes.get(0)).getType() == 0) {
            UniqueAttributesProcessor attrsProcessor;
            AuthorElement clonedElement = (AuthorElement)node;
            HashSet<String> skippedAttrsSet = new HashSet<String>();
            if (skippedAttributes != null) {
                skippedAttrsSet.addAll(Arrays.asList(skippedAttributes));
            }
            if ((attrsProcessor = controller.getUniqueAttributesProcessor()) != null) {
                int attrsCount = clonedElement.getAttributesCount();
                for (int i = 0; i < attrsCount; ++i) {
                    String attrQName = clonedElement.getAttributeAtIndex(i);
                    if (attrsProcessor.copyAttributeOnSplit(attrQName, clonedElement)) continue;
                    skippedAttrsSet.add(attrQName);
                }
            }
            if (!skippedAttrsSet.isEmpty()) {
                Iterator iter = skippedAttrsSet.iterator();
                while (iter.hasNext()) {
                    clonedElement.removeAttribute((String)iter.next());
                }
            }
        }
    }

    public static List<Position> removeCurrentSelection(AuthorAccess authorAccess) {
        List<Position> positions = new ArrayList<Position>();
        if (authorAccess.getEditorAccess().hasSelection()) {
            List selectionIntervals = authorAccess.getEditorAccess().getAuthorSelectionModel().getSelectionIntervals();
            positions = CommonsOperationsUtil.removeIntervals(authorAccess, selectionIntervals);
        }
        return positions;
    }

    public static List<Position> removeIntervals(AuthorAccess authorAccess, List<ContentInterval> selectionIntervals) {
        ArrayList<Position> positions = new ArrayList<Position>();
        if (selectionIntervals != null) {
            if (selectionIntervals.size() > 1) {
                Collections.sort(selectionIntervals, new Comparator<ContentInterval>(){

                    @Override
                    public int compare(ContentInterval interval1, ContentInterval interval2) {
                        int result = 0;
                        if (interval1 != null && interval2 != null) {
                            result = interval1.getStartOffset() > interval2.getStartOffset() ? -1 : 1;
                        }
                        return result;
                    }
                });
            }
            try {
                for (ContentInterval selection : selectionIntervals) {
                    int[] balancedSelection = authorAccess.getEditorAccess().getBalancedSelection(selection.getStartOffset(), selection.getEndOffset());
                    authorAccess.getDocumentController().delete(balancedSelection[0], balancedSelection[1] - 1);
                    AuthorNode node = authorAccess.getDocumentController().getNodeAtOffset(balancedSelection[0]);
                    if (node == null || node == authorAccess.getDocumentController().getAuthorDocumentNode().getRootElement() || node.getStartOffset() + 1 != node.getEndOffset()) continue;
                    positions.add(authorAccess.getDocumentController().createPositionInContent(node.getStartOffset()));
                }
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        return positions;
    }

    public static List<SelectedFragmentInfo> getSelectedFragmentsForConversions(AuthorAccess authorAccess, ConversionElementHelper helper) throws AuthorOperationException {
        List<SelectedFragmentInfo> result = null;
        if (authorAccess.getEditorAccess().hasSelection()) {
            List selectionIntervals = authorAccess.getEditorAccess().getAuthorSelectionModel().getSelectionIntervals();
            try {
                result = CommonsOperationsUtil.getFragmentsForConversions(authorAccess, helper, selectionIntervals);
            }
            catch (BadLocationException e) {
                logger.debug((Object)e, (Throwable)e);
            }
        }
        return result;
    }

    public static List<SelectedFragmentInfo> getFragmentsForConversions(AuthorAccess authorAccess, ConversionElementHelper helper, List<ContentInterval> intervals) throws BadLocationException, AuthorOperationException {
        ArrayList<SelectedFragmentInfo> result = new ArrayList<SelectedFragmentInfo>();
        for (ContentInterval contentInterval : intervals) {
            result.addAll(CommonsOperationsUtil.getFragmentsForConversions(authorAccess, helper, contentInterval));
        }
        return result;
    }

    private static List<SelectedFragmentInfo> getFragmentsForConversions(AuthorAccess authorAccess, ConversionElementHelper helper, ContentInterval contentInterval) throws BadLocationException, AuthorOperationException {
        ArrayList<SelectedFragmentInfo> result = new ArrayList<SelectedFragmentInfo>();
        AuthorDocumentController controller = authorAccess.getDocumentController();
        int start = contentInterval.getStartOffset();
        int maxEndOffset = contentInterval.getEndOffset();
        Segment content = new Segment();
        int len = maxEndOffset - contentInterval.getStartOffset();
        controller.getChars(start, len, content);
        AuthorNode lastNode = null;
        char ch = content.first();
        int startInterval = contentInterval.getStartOffset();
        int currentOffset = start;
        while (ch != '\uffff') {
            boolean intervalEmpty;
            boolean bl = intervalEmpty = startInterval == currentOffset;
            if (ch == '\u0000') {
                OffsetInformation info = controller.getContentInformationAtOffset(currentOffset);
                AuthorNode node = info.getNodeForMarkerOffset();
                Styles styles = authorAccess.getEditorAccess().getStyles(node);
                String display = styles.getDisplay();
                if (("block".equals(display) || "list-item".equals(display)) && helper.blockContentMustBeConverted(node, authorAccess)) {
                    result.addAll(CommonsOperationsUtil.finishCurrentFragment(startInterval, currentOffset, helper, controller));
                    if ("list-item".equals(display) && node.getStartOffset() == currentOffset && node.getEndOffset() <= contentInterval.getEndOffset()) {
                        result.add(CommonsOperationsUtil.getFragmentForNode(node, helper, controller));
                        content.setIndex(content.getIndex() + node.getEndOffset() - node.getStartOffset());
                        currentOffset = node.getEndOffset();
                    } else if (intervalEmpty && lastNode != node && node.getStartOffset() + 1 == node.getEndOffset()) {
                        lastNode = node;
                        result.add(CommonsOperationsUtil.getFragmentForNode(node, helper, controller));
                    }
                    startInterval = currentOffset + 1;
                }
            }
            ch = content.next();
            ++currentOffset;
        }
        if (startInterval < maxEndOffset) {
            AuthorDocumentFragment selectedFragment = CommonsOperationsUtil.createAuthorDocumentFragment(controller, startInterval, maxEndOffset - 1, helper);
            result.add(new SelectedFragmentInfo(selectedFragment, null));
        }
        return result;
    }

    private static SelectedFragmentInfo getFragmentForNode(AuthorNode node, ConversionElementHelper helper, AuthorDocumentController controller) throws BadLocationException, AuthorOperationException {
        AuthorDocumentFragment selectedFragment = CommonsOperationsUtil.createAuthorDocumentFragment(controller, node.getStartOffset() + 1, node.getEndOffset() - 1, helper);
        Map<String, String> attributes = CommonsOperationsUtil.getAttributes(node, true);
        return new SelectedFragmentInfo(selectedFragment, attributes);
    }

    private static List<SelectedFragmentInfo> finishCurrentFragment(int startInterval, int currentOffset, ConversionElementHelper helper, AuthorDocumentController controller) throws BadLocationException, AuthorOperationException {
        if (startInterval == currentOffset) {
            return Collections.emptyList();
        }
        AuthorNode node = controller.getNodeAtOffset(currentOffset);
        boolean currentNodeFullyIncluded = startInterval <= node.getStartOffset() + 1 && currentOffset >= node.getEndOffset();
        AuthorDocumentFragment selectedFragment = CommonsOperationsUtil.createAuthorDocumentFragment(controller, startInterval, currentOffset - 1, helper);
        Map<String, String> attributes = CommonsOperationsUtil.getAttributes(node, currentNodeFullyIncluded);
        return Collections.singletonList(new SelectedFragmentInfo(selectedFragment, attributes));
    }

    public static void removeEmptyElements(AuthorAccess authorAccess, Collection<Position> emptyElementsPositions) {
        if (!emptyElementsPositions.isEmpty()) {
            for (Position position : emptyElementsPositions) {
                try {
                    AuthorNode nodeAtOffset = authorAccess.getDocumentController().getNodeAtOffset(position.getOffset() + 1);
                    while (nodeAtOffset != null && nodeAtOffset != authorAccess.getDocumentController().getAuthorDocumentNode().getRootElement()) {
                        if (nodeAtOffset.getStartOffset() + 1 == nodeAtOffset.getEndOffset()) {
                            AuthorNode parentNode = nodeAtOffset.getParent();
                            authorAccess.getDocumentController().deleteNode(nodeAtOffset);
                            nodeAtOffset = parentNode;
                            continue;
                        }
                        nodeAtOffset = null;
                    }
                }
                catch (BadLocationException e) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static boolean isAllowedElement(String elementLocalName, int offset, AuthorSchemaManager authorSchemaManager) throws BadLocationException {
        boolean isElementAccepted = false;
        if (authorSchemaManager != null) {
            List whatElementsCanGoHere;
            WhatElementsCanGoHereContext context = authorSchemaManager.createWhatElementsCanGoHereContext(offset);
            if (context != null && (whatElementsCanGoHere = authorSchemaManager.whatElementsCanGoHere(context)) != null) {
                for (CIElement ciElement : whatElementsCanGoHere) {
                    if (!elementLocalName.equals(ciElement.getName())) continue;
                    isElementAccepted = true;
                    break;
                }
            }
        } else {
            isElementAccepted = true;
        }
        return isElementAccepted;
    }

    public static abstract class ConversionElementHelper {
        public abstract boolean blockContentMustBeConverted(AuthorNode var1, AuthorAccess var2) throws AuthorOperationException;

        public AuthorDocumentFragment createAuthorDocumentFragment(AuthorDocumentController controller, int start, int end) throws AuthorOperationException, BadLocationException {
            return null;
        }
    }

    public static class SelectedFragmentInfo {
        private AuthorDocumentFragment selectedFragment;
        private Map<String, String> attributes;

        public SelectedFragmentInfo(AuthorDocumentFragment selectedFragment, Map<String, String> attributes) {
            this.selectedFragment = selectedFragment;
            this.attributes = attributes;
        }

        public AuthorDocumentFragment getSelectedFragment() {
            return this.selectedFragment;
        }

        public void setSelectedFragment(AuthorDocumentFragment selectedFragment) {
            this.selectedFragment = selectedFragment;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<String, String> attributes) {
            this.attributes = attributes;
        }
    }
}

