/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.imagemap;

import java.util.HashMap;
import javax.xml.transform.TransformerFactory;
import net.sf.saxon.TransformerFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorImageDecorator;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.NamespaceContext;
import ro.sync.ecss.extensions.commons.imagemap.EditImageMapCore;
import ro.sync.ecss.imagemap.IImageMapWrapper;
import ro.sync.ecss.imagemap.ImageMapAccess;
import ro.sync.ecss.imagemap.ImageMapFactory;
import ro.sync.ecss.imagemap.ImageMapUtil;
import ro.sync.ecss.imagemap.SupportedFrameworks;
import ro.sync.exml.view.graphics.Graphics;
import ro.sync.exml.view.graphics.Rectangle;

@API(type=APIType.EXTENDABLE, src=SourceType.PUBLIC)
public abstract class AuthorImageMapDecorator
extends AuthorImageDecorator {
    private static final Logger logger = LoggerFactory.getLogger((String)AuthorImageMapDecorator.class.getName());
    private EditImageMapCore imageMapCore;

    public AuthorImageMapDecorator(EditImageMapCore imageMapCore) {
        this.imageMapCore = imageMapCore;
    }

    protected abstract boolean isNodeOfInterest(AuthorNode var1, SupportedFrameworks var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g, int x, int y, int imageWidth, int imageHeight, Rectangle originalSize, AuthorNode element, AuthorAccess authorAccess, boolean wasAnnotated) {
        String oldProp = System.getProperty(TransformerFactory.class.getName());
        System.setProperty(TransformerFactory.class.getName(), TransformerFactoryImpl.class.getName());
        AuthorDocumentController documentController = authorAccess.getDocumentController();
        try {
            AuthorNode[] nodes = this.imageMapCore.getNodesOfInterest(authorAccess, element, false);
            if (nodes != null) {
                Rectangle theSize;
                SupportedFrameworks framework = this.imageMapCore.getSupportedFramework(nodes[0].getNamespace());
                if (!this.isNodeOfInterest(element, framework)) {
                    return;
                }
                AuthorDocumentFragment[] fragments = new AuthorDocumentFragment[nodes.length];
                String[] asXML = new String[nodes.length];
                for (int i = 0; i < asXML.length; ++i) {
                    fragments[i] = documentController.createDocumentFragment(nodes[i], true);
                    asXML[i] = documentController.serializeFragmentToXML(fragments[i]);
                }
                NamespaceContext nsContext = nodes[0].getNamespaceContext();
                HashMap<String, String> uri2ProxyMappings = new HashMap<String, String>();
                String[] nss = nsContext.getNamespaces();
                for (int i = 0; i < nss.length; ++i) {
                    uri2ProxyMappings.put(nss[i], nsContext.getPrefixForNamespace(nss[i]));
                }
                int fontOfNodeSize = ImageMapUtil.getFontOfNodeSize((AuthorAccess)authorAccess, (AuthorNode)nodes[0]);
                IImageMapWrapper imageMap = ImageMapFactory.getInstance().getImageMap(framework, authorAccess, fontOfNodeSize, authorAccess.getEditorAccess().getEditorLocation(), uri2ProxyMappings, asXML);
                Rectangle imageSize = new Rectangle(0, 0, imageWidth, imageHeight);
                Rectangle imposedImageSize = imageMap.getImposedImageSize(imageSize);
                double scaleFactor = 1.0;
                Rectangle rectangle = theSize = imposedImageSize == null ? imageSize : imposedImageSize;
                if (!imageSize.equals((Object)imposedImageSize) && originalSize != null && !originalSize.equals((Object)theSize)) {
                    scaleFactor = (double)theSize.width / (double)originalSize.width;
                }
                ImageMapAccess.getInstance().paintImageMapAreas(g, x, y, theSize.width, theSize.height, scaleFactor, authorAccess, imageMap, framework, fontOfNodeSize, wasAnnotated);
            }
        }
        catch (Throwable t) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)t, t);
            }
        }
        finally {
            if (oldProp == null) {
                System.clearProperty(TransformerFactory.class.getName());
            } else {
                System.setProperty(TransformerFactory.class.getName(), oldProp);
            }
        }
    }
}

