/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.resolver;

import com.thaiopensource.resolver.Identifier;
import com.thaiopensource.resolver.Input;
import com.thaiopensource.resolver.Resolver;
import com.thaiopensource.resolver.ResolverException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class BasicResolver
implements Resolver {
    private static final BasicResolver theInstance = new BasicResolver();

    protected BasicResolver() {
    }

    public static BasicResolver getInstance() {
        return theInstance;
    }

    @Override
    public void resolve(Identifier id, Input input) throws IOException, ResolverException {
        if (!input.isResolved()) {
            input.setUri(BasicResolver.resolveUri(id));
        }
    }

    @Override
    public void open(Input input) throws IOException, ResolverException {
        URI uri;
        if (!input.isUriDefinitive()) {
            return;
        }
        try {
            uri = new URI(input.getUri());
        }
        catch (URISyntaxException e) {
            throw new ResolverException(e);
        }
        if (!uri.isAbsolute()) {
            throw new ResolverException("cannot open relative URI: " + uri);
        }
        URL url = new URL(uri.toASCIIString());
        input.setByteStream(url.openStream());
    }

    public static String resolveUri(Identifier id) throws ResolverException {
        try {
            String base;
            String uriRef = id.getUriReference();
            URI uri = new URI(uriRef);
            if (!uri.isAbsolute() && (base = id.getBase()) != null) {
                uriRef = new URL(new URL(base), uriRef).toExternalForm();
            }
            return uriRef;
        }
        catch (URISyntaxException e) {
            throw new ResolverException(e);
        }
        catch (MalformedURLException e) {
            throw new ResolverException(e);
        }
    }
}

