/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.dtd;

import java.util.HashMap;
import java.util.Map;

public class Datatypes {
    private static final Map<String, Info> xsdMap = new HashMap<String, Info>();
    private static final int COMPATIBLE = 0;
    private static final int CDATA = 1;
    private static final int NMTOKEN = 2;
    private static final int CDATA_EQUALITY = 4;
    private static final int TOKEN_EQUALITY = 8;
    private static final int EXACT = 16;
    private static final Object[] others = new Object[]{"", new Info("string", 21), "", new Info("token", 25), "http://relaxng.org/ns/compatibility/datatypes/1.0", new Info("ID", 24), "http://relaxng.org/ns/compatibility/datatypes/1.0", new Info("IDREF", 24), "http://relaxng.org/ns/compatibility/datatypes/1.0", new Info("IDREFS", 24)};

    public static Info getInfo(String datatypeLibrary, String localName) {
        if (datatypeLibrary.equals("http://www.w3.org/2001/XMLSchema-datatypes")) {
            return xsdMap.get(localName);
        }
        for (int i = 0; i < others.length; i += 2) {
            if (!datatypeLibrary.equals(others[i]) || !localName.equals(((Info)Datatypes.others[i + 1]).name)) continue;
            return (Info)others[i + 1];
        }
        return null;
    }

    private static void xsd(String name, int flags) {
        xsdMap.put(name, new Info(name, flags));
    }

    static {
        Datatypes.xsd("ENTITIES", 24);
        Datatypes.xsd("ENTITY", 24);
        Datatypes.xsd("ID", 24);
        Datatypes.xsd("IDREF", 24);
        Datatypes.xsd("IDREFS", 24);
        Datatypes.xsd("NMTOKEN", 24);
        Datatypes.xsd("NMTOKENS", 24);
        Datatypes.xsd("NOTATION", 2);
        Datatypes.xsd("NCName", 2);
        Datatypes.xsd("QName", 2);
        Datatypes.xsd("Name", 2);
        Datatypes.xsd("anyURI", 5);
        Datatypes.xsd("base64Binary", 1);
        Datatypes.xsd("boolean", 2);
        Datatypes.xsd("byte", 1);
        Datatypes.xsd("date", 2);
        Datatypes.xsd("dateTime", 2);
        Datatypes.xsd("decimal", 1);
        Datatypes.xsd("duration", 2);
        Datatypes.xsd("gDay", 2);
        Datatypes.xsd("gMonth", 2);
        Datatypes.xsd("gMonthDay", 2);
        Datatypes.xsd("gYear", 2);
        Datatypes.xsd("gYearMonth", 2);
        Datatypes.xsd("hexBinary", 2);
        Datatypes.xsd("int", 1);
        Datatypes.xsd("integer", 1);
        Datatypes.xsd("language", 1);
        Datatypes.xsd("long", 1);
        Datatypes.xsd("negativeInteger", 1);
        Datatypes.xsd("nonNegativeInteger", 1);
        Datatypes.xsd("nonPositiveInteger", 1);
        Datatypes.xsd("normalizedString", 21);
        Datatypes.xsd("positiveInteger", 1);
        Datatypes.xsd("short", 1);
        Datatypes.xsd("string", 21);
        Datatypes.xsd("time", 2);
        Datatypes.xsd("token", 25);
        Datatypes.xsd("unsignedInt", 1);
        Datatypes.xsd("unsignedLong", 1);
        Datatypes.xsd("unsignedShort", 1);
    }

    public static final class Info {
        private final String name;
        private final int flags;

        private Info(String name, int flags) {
            this.name = name;
            this.flags = flags;
        }

        public String closestType() {
            switch (this.flags & 3) {
                case 0: {
                    return this.name;
                }
                case 2: {
                    return "NMTOKEN";
                }
            }
            return "CDATA";
        }

        public boolean isExact() {
            return (this.flags & 0x10) != 0;
        }

        public boolean usesTokenEquality() {
            return (this.flags & 8) != 0;
        }

        public boolean usesCdataEquality() {
            return (this.flags & 4) != 0;
        }
    }
}

