/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.xml.sax;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.ext.Attributes2;

public class AttributesImpl
implements Attributes2 {
    private List<Attribute> attrs = new ArrayList<Attribute>();

    public void addAttribute(String attrName, String value, boolean specified) {
        this.attrs.add(new Attribute(null, attrName, attrName, null, value, specified, false));
    }

    public void addAttribute(String uri, String qName, String localName, String type, String value, boolean isSpecified, boolean isDeclared) {
        this.attrs.add(new Attribute(uri, qName, localName, type, value, isSpecified, isDeclared));
    }

    @Override
    public int getIndex(String name) {
        int idx = -1;
        int i = -1;
        Iterator<Attribute> iterator = this.attrs.iterator();
        while (iterator.hasNext()) {
            ++i;
            Attribute attr = iterator.next();
            if (!AttributesImpl.areStringEqual(name, attr.qName)) continue;
            idx = i;
            break;
        }
        return idx;
    }

    @Override
    public int getIndex(String uri, String localName) {
        int idx = -1;
        int i = -1;
        Iterator<Attribute> iterator = this.attrs.iterator();
        while (iterator.hasNext()) {
            ++i;
            Attribute attr = iterator.next();
            if (!AttributesImpl.areStringEqual(uri, attr.uri) || !AttributesImpl.areStringEqual(localName, attr.localName)) continue;
            idx = i;
            break;
        }
        return idx;
    }

    @Override
    public int getLength() {
        return this.attrs.size();
    }

    @Override
    public String getLocalName(int index) {
        return this.attrs.get((int)index).localName;
    }

    @Override
    public String getQName(int index) {
        return this.attrs.get((int)index).qName;
    }

    @Override
    public String getType(int index) {
        return this.attrs.get((int)index).type;
    }

    @Override
    public String getType(String name) {
        String type = null;
        for (Attribute attr : this.attrs) {
            if (!AttributesImpl.areStringEqual(name, attr.qName)) continue;
            type = attr.type;
            break;
        }
        return type;
    }

    @Override
    public String getType(String uri, String localName) {
        String type = null;
        for (Attribute attr : this.attrs) {
            if (!AttributesImpl.areStringEqual(uri, attr.uri) || !AttributesImpl.areStringEqual(localName, attr.localName)) continue;
            type = attr.type;
            break;
        }
        return type;
    }

    @Override
    public String getURI(int index) {
        return this.attrs.get((int)index).uri;
    }

    @Override
    public String getValue(int index) {
        return this.attrs.get((int)index).value;
    }

    @Override
    public String getValue(String name) {
        String value = null;
        for (Attribute attr : this.attrs) {
            if (!AttributesImpl.areStringEqual(name, attr.qName)) continue;
            value = attr.value;
            break;
        }
        return value;
    }

    @Override
    public String getValue(String uri, String localName) {
        String value = null;
        for (Attribute attr : this.attrs) {
            if (!AttributesImpl.areStringEqual(uri, attr.uri) || !AttributesImpl.areStringEqual(localName, attr.localName)) continue;
            value = attr.value;
            break;
        }
        return value;
    }

    @Override
    public boolean isDeclared(int index) {
        return this.attrs.get((int)index).isDeclared;
    }

    @Override
    public boolean isDeclared(String name) {
        boolean value = false;
        for (Attribute attr : this.attrs) {
            if (!AttributesImpl.areStringEqual(name, attr.qName)) continue;
            value = attr.isDeclared;
            break;
        }
        return value;
    }

    @Override
    public boolean isDeclared(String uri, String localName) {
        boolean value = false;
        for (Attribute attr : this.attrs) {
            if (!AttributesImpl.areStringEqual(uri, attr.uri) || !AttributesImpl.areStringEqual(localName, attr.localName)) continue;
            value = attr.isDeclared;
            break;
        }
        return value;
    }

    @Override
    public boolean isSpecified(int index) {
        return this.attrs.get((int)index).isSpecified;
    }

    @Override
    public boolean isSpecified(String name) {
        boolean value = true;
        for (Attribute attr : this.attrs) {
            if (!AttributesImpl.areStringEqual(name, attr.qName)) continue;
            value = attr.isSpecified;
            break;
        }
        return value;
    }

    @Override
    public boolean isSpecified(String uri, String localName) {
        boolean value = true;
        for (Attribute attr : this.attrs) {
            if (!AttributesImpl.areStringEqual(uri, attr.uri) || !AttributesImpl.areStringEqual(localName, attr.localName)) continue;
            value = attr.isSpecified;
            break;
        }
        return value;
    }

    private static boolean areStringEqual(String str1, String str2) {
        return str1 == null && str2 == null || str1 != null && str2 != null && str1.equals(str2);
    }

    private static class Attribute {
        private String uri;
        private String qName;
        private String localName;
        private String type;
        private String value;
        private final boolean isSpecified;
        private final boolean isDeclared;

        public Attribute(String uri, String qName, String localName, String type, String value, boolean isSpecified, boolean isDeclared) {
            this.uri = uri;
            this.qName = qName;
            this.localName = localName;
            this.type = type;
            this.value = value;
            this.isSpecified = isSpecified;
            this.isDeclared = isDeclared;
        }
    }
}

