/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;

@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
public class ProxyNamespaceMapping
implements Cloneable {
    private static Logger logger = LoggerFactory.getLogger((String)ProxyNamespaceMapping.class.getName());
    protected List<String> prefixes = new ArrayList<String>(2);
    protected List<String> namespaces = new ArrayList<String>(2);

    public ProxyNamespaceMapping(Node node) {
        this.update(node);
    }

    public ProxyNamespaceMapping() {
        this.addMapping("", "");
    }

    protected ProxyNamespaceMapping(List<String> prefixies, List<String> namespaces) {
        this.prefixes.addAll(prefixies);
        this.namespaces.addAll(namespaces);
    }

    public void update(Node node) {
        this.prefixes.clear();
        this.namespaces.clear();
        for (Node pn = node; pn != null; pn = pn.getParentNode()) {
            NamedNodeMap attrs;
            if (pn.getNodeType() != 1 || !pn.hasAttributes() || (attrs = pn.getAttributes()) == null) continue;
            int len = attrs.getLength();
            for (int i = 0; i < len; ++i) {
                Attr attr = (Attr)attrs.item(i);
                String name = attr.getNodeName();
                if (!name.startsWith("xmlns")) continue;
                String prefix = name.length() == 5 ? "" : name.substring(6);
                this.prefixes.add(0, prefix);
                this.namespaces.add(0, attr.getValue());
            }
        }
        this.prefixes.add(0, "");
        this.namespaces.add(0, "");
    }

    public void addMapping(String prefix, String namespace) {
        if (logger.isDebugEnabled()) {
            logger.debug("Add proxy namespace mapping: '" + prefix + "' - '" + namespace + "'");
        }
        if (prefix == null) {
            throw new IllegalArgumentException("Proxy cannot be null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("Namespace cannot be null");
        }
        this.prefixes.add(prefix);
        this.namespaces.add(namespace);
    }

    public String getNamespaceForAttributePrefix(String prefix) {
        if (prefix == null || "".equals(prefix)) {
            return "";
        }
        return this.getNamespaceForPrefix(prefix);
    }

    public String getNamespaceForPrefix(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(prefix)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        int len = this.prefixes.size();
        String namespace = null;
        for (int i = len - 1; i >= 0; --i) {
            if (!this.prefixes.get(i).equals(prefix)) continue;
            namespace = this.namespaces.get(i);
            break;
        }
        return namespace;
    }

    public String[] getPrefixesForNamespace(String namespace) {
        return this.getPrefixesForNamespace(namespace, true);
    }

    public String getPrefixForNamespace(String namespace) {
        return this.getPrefixForNamespace(namespace, true);
    }

    public String getPrefixForAttributeNamespace(String namespace) {
        return this.getPrefixForNamespace(namespace, false);
    }

    protected final String getPrefixForNamespace(String namespace, boolean allowDefault) {
        if (namespace == null) {
            namespace = "";
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(namespace)) {
            return "xml";
        }
        if ("http://www.w3.org/2000/xmlns/".equals(namespace)) {
            return "xmlns";
        }
        int len = this.prefixes.size();
        String proxy = null;
        for (int i = len - 1; i >= 0; --i) {
            if (!this.namespaces.get(i).equals(namespace)) continue;
            proxy = this.prefixes.get(i);
            if (this.prefixes.lastIndexOf(proxy) == i && (allowDefault || proxy != null && !"".equals(proxy))) break;
            proxy = null;
        }
        return proxy;
    }

    protected final String[] getPrefixesForNamespace(String namespace, boolean allowDefault) {
        if (namespace == null) {
            namespace = "";
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(namespace)) {
            return new String[]{"xml"};
        }
        ArrayList<String> prefixes4Namespace = new ArrayList<String>();
        int len = this.prefixes.size();
        String proxy = null;
        for (int i = len - 1; i >= 0; --i) {
            if (!this.namespaces.get(i).equals(namespace)) continue;
            proxy = this.prefixes.get(i);
            if (allowDefault || proxy != null && !"".equals(proxy)) {
                prefixes4Namespace.add(proxy);
            }
            proxy = null;
        }
        return prefixes4Namespace.toArray(new String[0]);
    }

    public void removeByPrefix(String prefix) {
        int len = this.prefixes.size();
        for (int i = len - 1; i >= 0; --i) {
            if (!this.prefixes.get(i).equals(prefix)) continue;
            this.prefixes.remove(i);
            this.namespaces.remove(i);
            break;
        }
    }

    public void removeByNamespace(String namespace) {
        int len = this.prefixes.size();
        for (int i = len - 1; i >= 0; --i) {
            if (!this.namespaces.get(i).equals(namespace)) continue;
            this.prefixes.remove(i);
            this.namespaces.remove(i);
            break;
        }
    }

    public void clear() {
        this.namespaces.clear();
        this.prefixes.clear();
        this.addMapping("", "");
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.hashCode());
        Iterator<String> iter = this.prefixes.iterator();
        Iterator<String> iter2 = this.namespaces.iterator();
        while (iter.hasNext() && iter2.hasNext()) {
            String item = iter.next();
            String item2 = iter2.next();
            buf.append("'" + item + "'-'" + item2 + "',  ");
        }
        return buf.toString();
    }

    public void removeLastMapping() {
        this.namespaces.remove(this.namespaces.size() - 1);
        this.prefixes.remove(this.prefixes.size() - 1);
    }

    public Set<String> getNamespaces() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.addAll(this.namespaces);
        set.remove("");
        return set;
    }

    public Object clone() {
        ProxyNamespaceMapping cloned = new ProxyNamespaceMapping(this.prefixes, this.namespaces);
        return cloned;
    }

    public List<String> getProxies() {
        return this.prefixes;
    }

    public <T extends ProxyNamespaceMapping> T getMappingsFromAncestor(ProxyNamespaceMapping prefixNamespaceMapping) {
        ProxyNamespaceMapping diff = this.createProxyNamespaceMapping();
        diff.namespaces.clear();
        diff.prefixes.clear();
        TreeSet<String> proxiesSet = new TreeSet<String>();
        proxiesSet.addAll(this.prefixes);
        for (String proxy : proxiesSet) {
            String ns1 = this.getNamespaceForPrefix(proxy);
            String ns2 = prefixNamespaceMapping.getNamespaceForPrefix(proxy);
            boolean namespacesAreEqual = ns1 == null && ns2 == null || ns1 != null && ns2 != null && ns1.equals(ns2);
            if (namespacesAreEqual) continue;
            diff.addMapping(proxy, ns1);
        }
        return (T)diff;
    }

    protected ProxyNamespaceMapping createProxyNamespaceMapping() {
        return new ProxyNamespaceMapping();
    }

    public void updateNamespaceProxyMapping(String namespace, String prefix) {
        if (this.namespaces.contains(namespace)) {
            this.removeByNamespace(namespace);
            this.addMapping(prefix, namespace);
        }
    }
}

