/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.util;

import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.xerces.util.XMLChar;
import ro.sync.basic.util.Crypto;
import ro.sync.basic.util.EncryptionKey;
import ro.sync.basic.util.StrongEncryptor;

class StrongEncryptorImpl
implements StrongEncryptor {
    private static final String ENCRYPTION_VERSION_PREFIX = "26.0.";
    private static final int GCM_IV_LENGTH = 12;
    private static final int GCM_TAG_LENGTH = 16;
    private static StrongEncryptorImpl instance;

    StrongEncryptorImpl() {
    }

    public static StrongEncryptorImpl getInstance() {
        if (instance == null) {
            instance = new StrongEncryptorImpl();
        }
        return instance;
    }

    private byte[] normalizeStringToAESKeyLength(String key) throws UnsupportedEncodingException {
        key = key.replace("-", "");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < key.length(); i += 2) {
            sb.append((char)(key.charAt(i) * 16 + key.charAt(i + 1)));
        }
        return sb.toString().getBytes("UTF-8");
    }

    private static byte[] concatenateArrays(byte[] first, byte[] second) {
        byte[] result = new byte[first.length + second.length];
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    private String applyEncryptionAlgorithm(String toEncrypt) {
        try {
            byte[] keyBytes = this.normalizeStringToAESKeyLength(EncryptionKey.getInstance().getKey());
            SecureRandom secureRandom = new SecureRandom();
            byte[] iv = new byte[12];
            secureRandom.nextBytes(iv);
            SecretKeySpec secretKey = new SecretKeySpec(keyBytes, "AES");
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, iv);
            cipher.init(1, (Key)secretKey, gcmParameterSpec);
            byte[] encryptedBytes = cipher.doFinal(toEncrypt.getBytes("UTF-8"));
            byte[] ivAndCipherText = StrongEncryptorImpl.concatenateArrays(iv, encryptedBytes);
            return Base64.getEncoder().encodeToString(ivAndCipherText);
        }
        catch (UnsupportedEncodingException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            return null;
        }
    }

    @Override
    public String encrypt(String toEncrypt) {
        String toReturn = null;
        if (toEncrypt != null) {
            toReturn = ENCRYPTION_VERSION_PREFIX + this.applyEncryptionAlgorithm(toEncrypt);
        }
        return toReturn;
    }

    private String applyDecryptionAlgorithm(String toDecrypt) {
        try {
            byte[] keyBytes = this.normalizeStringToAESKeyLength(EncryptionKey.getInstance().getKey());
            byte[] ivAndCipherText = Base64.getDecoder().decode(toDecrypt);
            SecretKeySpec secretKey = new SecretKeySpec(keyBytes, "AES");
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, ivAndCipherText, 0, 12);
            cipher.init(2, (Key)secretKey, gcmParameterSpec);
            byte[] decryptedBytes = cipher.doFinal(ivAndCipherText, 12, ivAndCipherText.length - 12);
            return new String(decryptedBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            return null;
        }
    }

    @Override
    public String decrypt(String toDecrypt) {
        String toReturn = null;
        if (toDecrypt != null) {
            Object key = null;
            if (toDecrypt.isEmpty()) {
                toReturn = "";
            } else if (toDecrypt.startsWith(ENCRYPTION_VERSION_PREFIX)) {
                toDecrypt = toDecrypt.substring(ENCRYPTION_VERSION_PREFIX.length());
                toReturn = this.applyDecryptionAlgorithm(toDecrypt);
            } else if (toDecrypt.startsWith("9.1.")) {
                toReturn = Crypto.decrypt(toDecrypt);
            }
            if (toReturn != null) {
                for (int i = 0; i < toReturn.length(); ++i) {
                    if (!XMLChar.isInvalid((int)toReturn.charAt(i))) continue;
                    return null;
                }
            }
        }
        return toReturn;
    }
}

