/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import ro.sync.basic.xml.encoding.EncodingDetectorInterface;

public class ReaderInputStream
extends InputStream {
    private Reader reader;
    private PipedOutputStream pos;
    private PipedInputStream pis;
    private OutputStreamWriter osw;
    private boolean bytesWritten = false;

    public ReaderInputStream(Reader reader, String javaEncoding, boolean writeUTF8BOM, EncodingDetectorInterface encodingDetector) throws IOException {
        this.reader = reader;
        this.pos = new PipedOutputStream(){

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                ReaderInputStream.this.bytesWritten = true;
                super.write(b, off, len);
            }

            @Override
            public void write(byte[] b) throws IOException {
                ReaderInputStream.this.bytesWritten = true;
                super.write(b);
            }

            @Override
            public void write(int b) throws IOException {
                ReaderInputStream.this.bytesWritten = true;
                super.write(b);
            }
        };
        this.pis = new PipedInputStream(this.pos);
        this.osw = encodingDetector.createWriter(this.pos, javaEncoding, null, writeUTF8BOM);
    }

    @Override
    public int read() throws IOException {
        if (this.pis.available() > 0) {
            return this.pis.read();
        }
        int c = this.reader.read();
        if (c == -1) {
            return c;
        }
        this.bytesWritten = false;
        this.osw.write(c);
        this.osw.flush();
        this.pos.flush();
        if (this.bytesWritten) {
            return this.pis.read();
        }
        return this.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int i;
        if (len == 0) {
            return 0;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        b[off] = (byte)c;
        for (i = 1; i < len && this.reader.ready(); ++i) {
            c = this.read();
            if (c == -1) {
                return i;
            }
            b[off + i] = (byte)c;
        }
        return i;
    }

    @Override
    public int available() throws IOException {
        int i = this.pis.available();
        if (i > 0) {
            return i;
        }
        if (this.reader.ready()) {
            return 1;
        }
        return 0;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
        this.osw.close();
        this.pis.close();
    }
}

