/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.io;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import ro.sync.basic.io.NonCloseableReader;

public class DocumentReader
extends NonCloseableReader {
    private static final int FOUR_KB = 4096;
    protected int positionInDocument = 0;
    protected int mark = -1;
    protected Document document;
    private Segment segment;
    private int displacementInSegment;

    public DocumentReader(Document document) {
        this.document = document;
        this.segment = new Segment();
        this.segment.setPartialReturn(true);
    }

    @Override
    public void mark(int readAheadLimit) {
        this.mark = this.positionInDocument - (this.segment.count - this.displacementInSegment);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() {
        int len = this.readInSegment(4096);
        if (len != -1) {
            ++this.displacementInSegment;
            return this.segment.array[this.segment.offset + this.displacementInSegment - 1];
        }
        return -1;
    }

    private int readInSegment(int length) {
        if (this.displacementInSegment >= this.segment.count) {
            if (this.positionInDocument < this.getLength()) {
                if (this.positionInDocument + length > this.getLength()) {
                    length = this.getLength() - this.positionInDocument;
                }
                try {
                    this.displacementInSegment = 0;
                    this.document.getText(this.positionInDocument, length, this.segment);
                    this.positionInDocument += this.segment.count;
                    return this.segment.count;
                }
                catch (BadLocationException x) {
                    return -1;
                }
            }
            return -1;
        }
        return this.segment.count - this.displacementInSegment;
    }

    @Override
    public int read(char[] cbuf) {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public int read(char[] cbuf, int off, int len) {
        int toReturn;
        if (off + len > cbuf.length) {
            len = cbuf.length - off;
        }
        if ((toReturn = this.readInSegment(len)) != -1) {
            toReturn = Math.min(len, toReturn);
            System.arraycopy(this.segment.array, this.segment.offset + this.displacementInSegment, cbuf, off, toReturn);
            this.displacementInSegment += toReturn;
        }
        return toReturn;
    }

    @Override
    public boolean ready() {
        return true;
    }

    @Override
    public void reset() {
        this.positionInDocument = this.mark == -1 ? 0 : this.mark;
        this.mark = -1;
        this.displacementInSegment = this.segment.count;
    }

    @Override
    public long skip(long n) {
        if ((long)this.displacementInSegment + n < (long)this.segment.count) {
            this.displacementInSegment = (int)((long)this.displacementInSegment + n);
            return n;
        }
        int remainedSegmentLen = this.segment.count - this.displacementInSegment;
        int len = (int)(n - (long)remainedSegmentLen);
        this.displacementInSegment = this.segment.count;
        int readLen = this.readInSegment(len == 0 ? 4096 : len);
        if (readLen != -1) {
            this.displacementInSegment += readLen;
            return remainedSegmentLen + readLen;
        }
        return remainedSegmentLen;
    }

    public void seek(int n) {
        if (this.positionInDocument > 0 && this.positionInDocument - n <= this.segment.count) {
            this.displacementInSegment = this.segment.count - (this.positionInDocument - n);
        } else {
            this.displacementInSegment = this.segment.count;
            this.positionInDocument = n <= this.getLength() ? n : this.getLength();
        }
    }

    public int getLength() {
        return this.document.getLength();
    }

    @Override
    public void rewind() {
        this.positionInDocument = 0;
        this.mark = -1;
        this.displacementInSegment = this.segment.count;
    }
}

