/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.outline;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.util.Equaler;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.basic.xml.BasicXmlUtil;
import ro.sync.options.InvalidPersistentObjException;
import ro.sync.options.PersistentObject;
import ro.sync.outline.y;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class PathItem
implements PersistentObject {
    private static final Logger logger = LoggerFactory.getLogger((String)PathItem.class.getName());
    public static final String SEPARATOR = "|";
    private int index;
    private String qName;
    private String attributeName;
    private String attributeValue;
    public static final String COMMENT_NAME = "comment()";
    public static final String PI_NAME = "processing-instruction()";
    private String namespace = null;

    public PathItem() {
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String string) {
        this.namespace = string;
    }

    public PathItem(String string, int n2) {
        this.index = n2;
        this.qName = string;
    }

    public PathItem(String string) throws y {
        StringTokenizer stringTokenizer = new StringTokenizer(string, SEPARATOR);
        try {
            this.qName = stringTokenizer.nextToken();
            this.index = NumberParserUtil.parseInt((String)stringTokenizer.nextToken());
            if (stringTokenizer.hasMoreElements()) {
                throw new y("Invalid format for token item : " + string);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new y(noSuchElementException.getMessage());
        }
        catch (NumberFormatException numberFormatException) {
            throw new y("Cannot set the token index because : " + numberFormatException.getMessage());
        }
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.qName;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String string) {
        this.attributeName = string;
    }

    public String getAttributeValue() {
        return this.attributeValue;
    }

    public void setAttributeValue(String string) {
        this.attributeValue = string;
    }

    public String serialize() {
        return this.qName + SEPARATOR + this.index;
    }

    public boolean equals(Object object) {
        if (object instanceof PathItem) {
            return Equaler.verifyEquals((Object)this.qName, (Object)((PathItem)object).qName) && this.index == ((PathItem)object).index && Equaler.verifyEquals((Object)this.attributeName, (Object)((PathItem)object).attributeName) && Equaler.verifyEquals((Object)this.attributeValue, (Object)((PathItem)object).attributeValue);
        }
        return false;
    }

    public int hashCode() {
        int n2 = this.index + this.qName.hashCode();
        return n2;
    }

    public String toString() {
        return this.toXPathString(false);
    }

    public String toXPathString(boolean bl) {
        boolean bl2;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = bl2 = this.namespace != null;
        if (this.qName != null) {
            if (bl2 && bl) {
                stringBuilder.append("*:").append(BasicXmlUtil.getLocalName((String)this.qName));
            } else {
                stringBuilder.append(this.qName);
            }
        }
        if (bl2 && bl) {
            stringBuilder.append("[namespace-uri() = '").append(this.namespace).append("']");
        }
        if (this.attributeName != null) {
            stringBuilder.append("[@").append(this.attributeName);
            if (this.attributeValue != null) {
                stringBuilder.append("='").append(this.attributeValue).append("'");
            }
            stringBuilder.append("]");
        }
        stringBuilder.append("[").append(this.index).append("]");
        return stringBuilder.toString();
    }

    @Override
    public void checkValid() throws InvalidPersistentObjException {
        if (this.qName == null) {
            throw new InvalidPersistentObjException("The name is null.");
        }
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error((Object)cloneNotSupportedException, (Throwable)cloneNotSupportedException);
            return null;
        }
    }
}

