/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.zip;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.options.InvalidPersistentObjException;
import ro.sync.options.PersistentObject;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class ArchiveDescriptor
implements PersistentObject {
    private static final Logger logger = LoggerFactory.getLogger((String)ArchiveDescriptor.class.getName());
    public static final int ARCHIVE_TYPE_ZIP = 0;
    public static final int ARCHIVE_TYPE_JAR = 1;
    public static final int ARCHIVE_TYPE_ODF = 2;
    public static final int ARCHIVE_TYPE_EPUB = 3;
    public static final String ARCHIVE_DESCRIPTION_ZIP = "zip";
    public static final String ARCHIVE_DESCRIPTION_JAR = "jar";
    public static final String ARCHIVE_DESCRIPTION_ODF = "odf";
    public static final String ARCHIVE_DESCRIPTION_EPUB = "epub";
    private String description;
    private String[] extensions;
    private int type;
    private boolean isBuiltin;

    public ArchiveDescriptor() {
    }

    public ArchiveDescriptor(String string, String[] stringArray, int n2) {
        this(string, stringArray, n2, false);
    }

    public ArchiveDescriptor(String string, String[] stringArray, int n2, boolean bl) {
        this.isBuiltin = bl;
        this.description = string == null ? "" : string;
        this.extensions = stringArray;
        this.type = n2;
    }

    @Override
    public void checkValid() throws InvalidPersistentObjException {
        if (this.extensions == null || this.extensions.length == 0) {
            throw new InvalidPersistentObjException("No extensions found in the archive descriptor");
        }
        if (this.type != 1 && this.type != 2 && this.type != 0 && this.type != 3) {
            throw new InvalidPersistentObjException("Invalid value for the archive type: " + this.type);
        }
        if (this.description == null) {
            this.description = "";
        }
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    public static String getTypeDescription(int n2) {
        String string = null;
        switch (n2) {
            case 0: {
                string = ARCHIVE_DESCRIPTION_ZIP;
                break;
            }
            case 1: {
                string = ARCHIVE_DESCRIPTION_JAR;
                break;
            }
            case 2: {
                string = ARCHIVE_DESCRIPTION_ODF;
                break;
            }
            case 3: {
                string = ARCHIVE_DESCRIPTION_EPUB;
                break;
            }
            default: {
                logger.warn("No driver found for current archive type.");
            }
        }
        return string;
    }

    public static int getDescriptionType(String string) {
        int n2 = -1;
        switch (string) {
            case "zip": {
                n2 = 0;
                break;
            }
            case "jar": {
                n2 = 1;
                break;
            }
            case "odf": {
                n2 = 2;
                break;
            }
            case "epub": {
                n2 = 3;
                break;
            }
            default: {
                logger.warn("Unknown archive type for: " + string);
            }
        }
        return n2;
    }

    public void setExtensions(String[] stringArray) {
        this.extensions = stringArray;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    public int getType() {
        return this.type;
    }

    public static String extensionsToString(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(stringArray[i2]);
        }
        return stringBuilder.toString();
    }

    public static String[] extensionsToArray(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            arrayList.add(string2.trim());
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    public Object clone() {
        ArchiveDescriptor archiveDescriptor = null;
        try {
            archiveDescriptor = (ArchiveDescriptor)super.clone();
            if (this.extensions != null) {
                archiveDescriptor.extensions = (String[])this.extensions.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error((Object)cloneNotSupportedException, (Throwable)cloneNotSupportedException);
        }
        return archiveDescriptor;
    }

    public boolean isBuiltin() {
        return this.isBuiltin;
    }

    public String toString() {
        return this.extensions != null ? Arrays.asList(this.extensions).toString() : "NO EXTENSIONS";
    }
}

