/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.workspace.api.standalone.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.LFDetector;
import ro.sync.basic.util.PlatformDetector;
import ro.sync.exml.dd;
import ro.sync.i18n.d;
import ro.sync.i18n.r;
import ro.sync.ui.Icons;
import ro.sync.ui.application.ApplicationDialog;
import ro.sync.ui.application.HelpPageProvider;
import ro.sync.ui.application.action.e;
import ro.sync.ui.application.hb;
import ro.sync.ui.application.jc;
import ro.sync.ui.application.mb;
import ro.sync.ui.application.wc;
import ro.sync.ui.application.y;
import ro.sync.ui.bf;

@API(type=APIType.EXTENDABLE, src=SourceType.PUBLIC)
public class OKCancelDialog
extends JDialog
implements HelpPageProvider {
    private static final Logger logger = LoggerFactory.getLogger((String)OKCancelDialog.class.getName());
    public static final int RESULT_CANCEL = 0;
    public static final int RESULT_OK = 1;
    private int result = 0;
    private JButton okButton = new JButton();
    private JButton cancelButton = new JButton();
    private JPanel contentPanel = new JPanel(new BorderLayout());
    private Dimension buttonsSize;
    private JButton helpButton = new JButton();
    protected static final d messages = r.m();

    public OKCancelDialog(JFrame jFrame, String string, boolean bl) {
        this((Frame)jFrame, string, bl);
    }

    public OKCancelDialog(Frame frame, String string, boolean bl) {
        super(OKCancelDialog.detectParentFrame(frame), string, bl ? Dialog.DEFAULT_MODALITY_TYPE : Dialog.ModalityType.MODELESS);
        this.buttonsSize = PlatformDetector.isWin() ? new Dimension(75, 23) : (PlatformDetector.isMacOS() ? new Dimension(80, 26) : new Dimension(85, 23));
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OKCancelDialog.this.enterKeyPressed();
            }
        }, KeyStroke.getKeyStroke(10, 0), 2);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n') {
                    OKCancelDialog.this.enterKeyPressed();
                }
            }
        });
        this.okButton.setName("Ok button");
        this.setOkButtonText(messages.getString("Ok"));
        this.getRootPane().setDefaultButton(this.okButton);
        e e2 = new e(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (OKCancelDialog.this.cancelButton.isEnabled()) {
                    OKCancelDialog.this.doCancel();
                }
            }
        };
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), e2);
        this.getRootPane().getActionMap().put(e2, e2);
        int n2 = PlatformDetector.isMacOS() ? 24 : 11;
        mb mb2 = new mb(new GridBagLayout());
        mb2.setBorder(BorderFactory.createEmptyBorder(n2, n2, n2, n2));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 2;
        mb2.add((Component)this.contentPanel, gridBagConstraints);
        JPanel jPanel = new JPanel();
        if (LFDetector.isMacLFAndOverMacOSX10_5_0()) {
            this.helpButton.putClientProperty("JButton.buttonType", "help");
        } else {
            this.helpButton = jc.c(Icons.getIcon("/images/ShowHelp16.png"));
        }
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = OKCancelDialog.this.getHelpPageID();
                if (string != null) {
                    y.n(string);
                }
            }
        });
        this.helpButton.setToolTipText(messages.getString("Help"));
        this.helpButton.setFocusable(false);
        jPanel.add(this.helpButton);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OKCancelDialog.this.doOK();
            }
        });
        this.setCancelButtonText(messages.getString("Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OKCancelDialog.this.doCancel();
            }
        });
        jPanel.add(Box.createHorizontalGlue());
        if (PlatformDetector.isMacOS()) {
            jPanel.add(this.cancelButton);
            jPanel.add(Box.createHorizontalStrut(12));
            jPanel.add(this.okButton);
        } else {
            jPanel.add(this.okButton);
            jPanel.add(Box.createHorizontalStrut(7));
            jPanel.add(this.cancelButton);
        }
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        mb2.add((Component)jPanel, gridBagConstraints);
        this.setContentPane(mb2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                super.windowOpened(windowEvent);
                bf.zd(OKCancelDialog.this, true);
            }
        });
        this.setResizable(false);
    }

    public static Window detectParentFrame(Window window) {
        Window window2;
        if (dd.q()) {
            logger.warn("The OKCancelDialog API is not available in oXygen XML Web Author. Use JS API to show dialogs in browser.");
        }
        if (!(window != null && window.isShowing() || (window2 = ApplicationDialog.getTopWindow()) == null || window2 instanceof hb || window2 instanceof wc)) {
            window = window2;
        }
        return window;
    }

    protected void doOK() {
        this.result = 1;
        this.setVisible(false);
    }

    protected void enterKeyPressed() {
        if (this.okButton.isEnabled() && this.okButton.isVisible() && this.okButton.getParent() != null) {
            this.doOK();
        }
    }

    protected void doCancel() {
        this.result = 0;
        this.setVisible(false);
    }

    public int getResult() {
        return this.result;
    }

    public void setOkButtonText(String string) {
        this.setButtonText(this.okButton, string);
    }

    public void setCancelButtonText(String string) {
        this.setButtonText(this.cancelButton, string);
    }

    @Override
    public Container getContentPane() {
        return this.contentPanel;
    }

    private void setButtonText(JButton jButton, String string) {
        if (string != null && string.length() > 0) {
            int n2 = jButton.getFontMetrics(jButton.getFont()).stringWidth(string);
            int n3 = jButton.getFontMetrics(jButton.getFont()).getHeight();
            int n4 = this.buttonsSize.width - jButton.getMargin().left - jButton.getMargin().right;
            int n5 = this.buttonsSize.height - jButton.getMargin().top - jButton.getMargin().bottom;
            if (PlatformDetector.isMacOS()) {
                n4 -= 15;
                n5 -= 4;
            }
            if (n2 <= n4 - 4 && n3 <= n5) {
                jButton.setPreferredSize(this.buttonsSize);
            } else {
                jButton.setPreferredSize(null);
            }
            jButton.setText(string);
        }
    }

    public JButton getOkButton() {
        return this.okButton;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.setDialogLocation();
            boolean bl2 = this.getHelpPageID() != null && this.getHelpPageID().length() > 0 && !"no_help_page_id".equals(this.getHelpPageID());
            this.helpButton.setVisible(bl2 && !dd.d());
        }
        super.setVisible(bl);
    }

    protected void setDialogLocation() {
        this.setLocationRelativeTo(this.getOwner());
    }

    @Deprecated
    protected Dimension getHiDPIAwareDimension(Dimension dimension) {
        return dimension;
    }

    @Override
    public String getHelpPageID() {
        return "no_help_page_id";
    }
}

