/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.workspace.api.images.handlers;

import java.util.Optional;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.exml.view.graphics.Dimension;
import ro.sync.exml.view.graphics.Font;
import ro.sync.exml.view.graphics.Rectangle;

@API(type=APIType.NOT_EXTENDABLE, src=SourceType.PUBLIC)
public class ImageRenderingContext {
    private Font font;
    private int dotsPerInch;
    private Rectangle imageInfo;

    public ImageRenderingContext(Font font) {
        this(font, -1);
    }

    public ImageRenderingContext(Font font, int n2) {
        this(font, n2, null);
    }

    public ImageRenderingContext(Font font, int n2, Rectangle rectangle) {
        this.font = font;
        this.dotsPerInch = n2;
        this.imageInfo = rectangle;
    }

    public Font getFont() {
        return this.font;
    }

    public int getDotsPerInch() {
        return this.dotsPerInch != -1 ? this.dotsPerInch : 96;
    }

    public Dimension getImageDimensions() {
        return Optional.ofNullable(this.imageInfo).map(rectangle -> new Dimension(rectangle.getWidth(), rectangle.getHeight())).orElse(null);
    }
}

