/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.view.graphics;

import java.util.Optional;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;

@API(type=APIType.EXTENDABLE, src=SourceType.PRIVATE)
@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class Color {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)Color.class.getName());
    public static final Color COLOR_WHITE_ALPHA = new Color(255, 255, 255, 200);
    public static final Color COLOR_LIGHT_GRAY = new Color(192, 192, 192);
    public static final Color COLOR_LIGHT_GRAY_ALPHA = new Color(192, 192, 192, 50);
    public static final Color COLOR_WHITE = new Color(255, 255, 255);
    public static final Color COLOR_BLACK = new Color(0, 0, 0);
    public static final Color COLOR_BLACK_ALPHA = new Color(0, 0, 0, 40);
    public static final Color COLOR_RED = new Color(255, 0, 0);
    public static final Color COLOR_RED_DARKER = new Color(178, 0, 0);
    public static final Color COLOR_DARK_GRAY = new Color(64, 64, 64);
    public static final Color COLOR_BLUE = new Color(0, 0, 255);
    public static final Color COLOR_GRAY = new Color(128, 128, 128);
    public static final Color COLOR_LIGHT_GREEN = new Color(230, 255, 230);
    public static final Color COLOR_ORANGE = new Color(255, 200, 0);
    public static final Color COLOR_LIGHTER_GRAY = new Color(240, 240, 240);
    public static final Color COLOR_LIGHTER_BLUE = new Color(247, 250, 252);
    public static final Color COLOR_DARK_GREEN = new Color(0, 128, 0);
    public static final Color COLOR_LIGHT_YELLOW = new Color(255, 255, 230);
    public static final Color COLOR_YELLOW = new Color(255, 255, 158);
    public static final Color COLOR_DARK_YELLOW = new Color(255, 255, 50);
    public static final Color COLOR_PASTE_HIGHLIGHT_YELLOW = new Color(253, 240, 135, 100);
    public static final Color COLOR_AUTOCORRECT_HIGHLIGHT_YELLOW_FOR_DARK_THEME = new Color(139, 133, 61);
    public static final Color COLOR_TRANSPARENT = new Color(0, 0, 0, 0);
    public static final int ALPHA_CHANNEL_DEFAULT_VALUE = 255;
    private final int rgba;

    public static int normalize(int n2) {
        if (n2 < 0) {
            LOGGER.warn("Normalizing color channel value {} to 0.", (Object)n2);
            n2 = 0;
        } else if (n2 > 255) {
            LOGGER.warn("Normalizing color channel value {} to 255.", (Object)n2);
            n2 = 255;
        }
        return n2;
    }

    public Color(int n2, int n3, int n4, int n5) {
        this(Color.getRGB(n2, n3, n4, n5));
    }

    public static int getRGB(int n2, int n3, int n4, int n5) {
        n2 = Color.normalize(n2);
        n3 = Color.normalize(n3);
        n4 = Color.normalize(n4);
        n5 = Color.normalize(n5);
        return (n5 & 0xFF) << 24 | (n2 & 0xFF) << 16 | (n3 & 0xFF) << 8 | (n4 & 0xFF) << 0;
    }

    public Color(int n2) {
        this.rgba = n2;
    }

    public Color(int[] nArray) {
        this(nArray[0], nArray[1], nArray[2], nArray.length > 3 ? nArray[3] : 255);
    }

    public Color(int n2, int n3, int n4) {
        this(n2, n3, n4, 255);
    }

    public int getRed() {
        return this.rgba >> 16 & 0xFF;
    }

    public int getGreen() {
        return this.rgba >> 8 & 0xFF;
    }

    public int getBlue() {
        return this.rgba & 0xFF;
    }

    public int getAlpha() {
        return this.rgba >> 24 & 0xFF;
    }

    public int getRGB() {
        return this.rgba;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getName()).append("[r=").append(this.getRed()).append(",g=").append(this.getGreen()).append(",b=").append(this.getBlue());
        int n2 = this.getAlpha();
        if (n2 != 255) {
            stringBuilder.append(",a=").append(n2);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Color) {
            Color color = (Color)object;
            bl = color.rgba == this.rgba;
        }
        return bl;
    }

    public int hashCode() {
        return this.rgba;
    }

    public static Color desaturate(Color color, double d2) {
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        int n5 = (int)((double)n2 * d2);
        int n6 = (int)((double)n3 * d2);
        int n7 = (int)((double)n4 * d2);
        Color color2 = new Color(n5, n6, n7);
        return color2;
    }

    public static Color alphaComposite(Color color, Color color2) {
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        double d2 = (double)color.getAlpha() / 255.0;
        int n5 = (int)((double)n2 * d2 + (double)color2.getRed() * (1.0 - d2));
        int n6 = (int)((double)n3 * d2 + (double)color2.getGreen() * (1.0 - d2));
        int n7 = (int)((double)n4 * d2 + (double)color2.getBlue() * (1.0 - d2));
        return new Color(n5, n6, n7);
    }

    public static Color decodeColor(String string) {
        Color color = COLOR_BLACK;
        try {
            color = Color.parseColor(string).orElse(COLOR_BLACK);
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.error(() -> "Cannot parse color string: " + string, (Throwable)new Exception());
        }
        return color;
    }

    public static Optional<Color> parseColor(String string) throws NumberFormatException {
        if (string != null) {
            string = string.trim();
        }
        if (string == null || string.isEmpty()) {
            return Optional.empty();
        }
        Color color = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.countTokens() == 3 || stringTokenizer.countTokens() == 4) {
            int n2 = NumberParserUtil.parseInt((String)stringTokenizer.nextToken().trim());
            int n3 = NumberParserUtil.parseInt((String)stringTokenizer.nextToken().trim());
            int n4 = NumberParserUtil.parseInt((String)stringTokenizer.nextToken().trim());
            int n5 = stringTokenizer.hasMoreTokens() ? NumberParserUtil.parseInt((String)stringTokenizer.nextToken().trim()) : 255;
            color = new Color(n2, n3, n4, n5);
        }
        return Optional.ofNullable(color);
    }

    public static float[] rgbTohsl(int n2, int n3, int n4) {
        n2 = Color.normalize(n2);
        n3 = Color.normalize(n3);
        n4 = Color.normalize(n4);
        float f2 = (float)n2 / 255.0f;
        float f3 = (float)n3 / 255.0f;
        float f4 = (float)n4 / 255.0f;
        float f5 = Math.min(Math.min(f2, f3), f4);
        float f6 = Math.max(Math.max(f2, f3), f4);
        float f7 = f6 - f5;
        float f8 = (f6 + f5) / 2.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        if (f7 == 0.0f) {
            f9 = 0.0f;
            f10 = 0.0f;
        } else {
            f10 = (double)f8 < 0.5 ? f7 / (f6 + f5) : f7 / (2.0f - f6 - f5);
            float f11 = ((f6 - f2) / 6.0f + f7 / 2.0f) / f7;
            float f12 = ((f6 - f3) / 6.0f + f7 / 2.0f) / f7;
            float f13 = ((f6 - f4) / 6.0f + f7 / 2.0f) / f7;
            if (f2 == f6) {
                f9 = f13 - f12;
            } else if (f3 == f6) {
                f9 = 0.33333334f + f11 - f13;
            } else if (f4 == f6) {
                f9 = 0.6666667f + f12 - f11;
            }
            if (f9 < 0.0f) {
                f9 += 1.0f;
            }
            if (f9 > 1.0f) {
                f9 -= 1.0f;
            }
        }
        return new float[]{f9, f10, f8};
    }

    public static Color hslToColor(float f2, float f3, float f4, int n2) {
        int n3 = Color.hslToRGB(f2, f3, f4, n2);
        return new Color(n3);
    }

    public static Color hslToRGB(float f2, float f3, float f4) {
        return Color.hslToColor(f2, f3, f4, 255);
    }

    private static int hslToRGB(float f2, float f3, float f4, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (f3 == 0.0f) {
            n3 = (int)(f4 * 255.0f);
            n4 = (int)(f4 * 255.0f);
            n5 = (int)(f4 * 255.0f);
        } else {
            float f5 = (double)f4 < 0.5 ? f4 * (1.0f + f3) : f4 + f3 - f3 * f4;
            float f6 = 2.0f * f4 - f5;
            n3 = (int)(255.0f * Color.Hue_2_RGB(f6, f5, f2 + 0.33333334f));
            n4 = (int)(255.0f * Color.Hue_2_RGB(f6, f5, f2));
            n5 = (int)(255.0f * Color.Hue_2_RGB(f6, f5, f2 - 0.33333334f));
        }
        int n6 = Color.getRGB(n3, n4, n5, n2);
        return n6;
    }

    private static float Hue_2_RGB(float f2, float f3, float f4) {
        if (f4 < 0.0f) {
            f4 += 1.0f;
        }
        if (f4 > 1.0f) {
            f4 -= 1.0f;
        }
        if (6.0f * f4 < 1.0f) {
            return f2 + (f3 - f2) * 6.0f * f4;
        }
        if (2.0f * f4 < 1.0f) {
            return f3;
        }
        if (3.0f * f4 < 2.0f) {
            return f2 + (f3 - f2) * (0.6666667f - f4) * 6.0f;
        }
        return f2;
    }

    public static Color darker(Color color) {
        return Color.darker(color, 0.5f);
    }

    public static Color darker(Color color, float f2) {
        int n2 = color.getAlpha();
        float[] fArray = Color.rgbTohsl(color.getRed(), color.getGreen(), color.getBlue());
        fArray[2] = fArray[2] * f2;
        return Color.hslToColor(fArray[0], fArray[1], fArray[2], n2);
    }

    public static Color brighter(Color color) {
        int n2 = color.getAlpha();
        float[] fArray = Color.rgbTohsl(color.getRed(), color.getGreen(), color.getBlue());
        fArray[2] = (1.0f + fArray[2]) / 2.0f;
        return Color.hslToColor(fArray[0], fArray[1], fArray[2], n2);
    }

    public float getBrightness() {
        float[] fArray = Color.rgbTohsl(this.getRed(), this.getGreen(), this.getBlue());
        return fArray[2];
    }

    public static String getHexColor(Color color) {
        if (color != null) {
            return "#" + Integer.toHexString(color.rgba).substring(2);
        }
        return null;
    }

    public static int changeBrightnessAndSaturation(int n2, float f2, float f3) {
        int n3 = n2 >> 16 & 0xFF;
        int n4 = n2 >> 8 & 0xFF;
        int n5 = n2 >> 0 & 0xFF;
        int n6 = n2 >> 24 & 0xFF;
        float[] fArray = Color.RGBtoHSB(n3, n4, n5, null);
        fArray[1] = fArray[1] * f3;
        fArray[2] = fArray[2] * f2;
        return Color.HSBtoRGB(fArray[0], fArray[1], fArray[2], n6);
    }

    public static float[] RGBtoHSB(int n2, int n3, int n4, float[] fArray) {
        float f2;
        int n5;
        int n6;
        n2 = Color.normalize(n2);
        n3 = Color.normalize(n3);
        n4 = Color.normalize(n4);
        if (fArray == null) {
            fArray = new float[3];
        }
        int n7 = n6 = n2 > n3 ? n2 : n3;
        if (n4 > n6) {
            n6 = n4;
        }
        int n8 = n5 = n2 < n3 ? n2 : n3;
        if (n4 < n5) {
            n5 = n4;
        }
        float f3 = (float)n6 / 255.0f;
        float f4 = n6 != 0 ? (float)(n6 - n5) / (float)n6 : 0.0f;
        if (f4 == 0.0f) {
            f2 = 0.0f;
        } else {
            float f5 = (float)(n6 - n2) / (float)(n6 - n5);
            float f6 = (float)(n6 - n3) / (float)(n6 - n5);
            float f7 = (float)(n6 - n4) / (float)(n6 - n5);
            f2 = n2 == n6 ? f7 - f6 : (n3 == n6 ? 2.0f + f5 - f7 : 4.0f + f6 - f5);
            if ((f2 /= 6.0f) < 0.0f) {
                f2 += 1.0f;
            }
        }
        fArray[0] = f2;
        fArray[1] = f4;
        fArray[2] = f3;
        return fArray;
    }

    public static int HSBtoRGB(float f2, float f3, float f4, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (f3 == 0.0f) {
            n4 = n5 = (int)(f4 * 255.0f + 0.5f);
            n3 = n5;
        } else {
            float f5 = (f2 - (float)Math.floor(f2)) * 6.0f;
            float f6 = f5 - (float)Math.floor(f5);
            float f7 = f4 * (1.0f - f3);
            float f8 = f4 * (1.0f - f3 * f6);
            float f9 = f4 * (1.0f - f3 * (1.0f - f6));
            switch ((int)f5) {
                case 0: {
                    n3 = (int)(f4 * 255.0f + 0.5f);
                    n4 = (int)(f9 * 255.0f + 0.5f);
                    n5 = (int)(f7 * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    n3 = (int)(f8 * 255.0f + 0.5f);
                    n4 = (int)(f4 * 255.0f + 0.5f);
                    n5 = (int)(f7 * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    n3 = (int)(f7 * 255.0f + 0.5f);
                    n4 = (int)(f4 * 255.0f + 0.5f);
                    n5 = (int)(f9 * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    n3 = (int)(f7 * 255.0f + 0.5f);
                    n4 = (int)(f8 * 255.0f + 0.5f);
                    n5 = (int)(f4 * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    n3 = (int)(f9 * 255.0f + 0.5f);
                    n4 = (int)(f7 * 255.0f + 0.5f);
                    n5 = (int)(f4 * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    n3 = (int)(f4 * 255.0f + 0.5f);
                    n4 = (int)(f7 * 255.0f + 0.5f);
                    n5 = (int)(f8 * 255.0f + 0.5f);
                }
            }
        }
        n3 = Color.normalize(n3);
        n4 = Color.normalize(n4);
        n5 = Color.normalize(n5);
        n2 = Color.normalize(n2);
        return n2 << 24 | n3 << 16 | n4 << 8 | n5 << 0;
    }
}

