/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.plugin;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.io.ExceptCVSAndSVNFileFilter;
import ro.sync.basic.util.Equaler;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.ecss.css.Styles;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorExtensionStateListener;
import ro.sync.ecss.extensions.api.StylesFilter;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.exml.plugin.Plugin;
import ro.sync.exml.plugin.PluginDescriptor;
import ro.sync.exml.plugin.PluginExtension;
import ro.sync.exml.plugin.PluginManager;
import ro.sync.exml.plugin.author.css.filter.GeneralStylesFilterExtension;
import ro.sync.util.editorvars.EditorVariablesBase;
import ro.sync.util.jb;

public final class PluginUtil {
    private static final Logger b = LoggerFactory.getLogger((String)PluginUtil.class.getName());

    private PluginUtil() {
    }

    public static boolean isPluginInstalled(String string) {
        boolean bl = false;
        PluginManager pluginManager = PluginManager.getInstance();
        List<PluginDescriptor> list = pluginManager.getPluginDescriptors();
        if (list != null) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                PluginDescriptor pluginDescriptor = list.get(i2);
                if (!Equaler.verifyEquals((Object)string, (Object)pluginDescriptor.getID())) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static List<File> getPluginDirs() {
        Optional<String> optional;
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = PluginUtil.getUserPrefsPluginsDirs();
        if (fileArray != null) {
            arrayList.addAll(Arrays.asList(fileArray));
        }
        if ((optional = PluginUtil.getDefaultPluginsDir()).isPresent()) {
            arrayList.add(new File(optional.get()));
        }
        return arrayList;
    }

    public static Optional<String> getDefaultPluginsDir() {
        String string = System.getProperty("com.oxygenxml.editor.plugins.dir");
        if (string != null) {
            string = EditorVariablesBase.expandEnvAndSystem(string);
        }
        return Optional.ofNullable(string);
    }

    public static File getUserPrefsPluginsDir() {
        File file = jb.e().c();
        return new File(file, "plugins");
    }

    public static File[] getUserPrefsPluginsDirs() {
        File[] fileArray;
        String string = System.getProperty("com.oxygenxml.editor.plugins.user.installed.dir");
        if (string != null) {
            fileArray = new File[]{new File(string)};
        } else {
            File file = PluginUtil.getUserPrefsPluginsDir();
            fileArray = file.listFiles((FileFilter)new ExceptCVSAndSVNFileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() && super.accept(file);
                }
            });
        }
        return fileArray;
    }

    public static StylesFilter addPluginStylesFilters(StylesFilter object, AuthorAccess authorAccess) {
        final ArrayList<StylesFilter> arrayList = new ArrayList<StylesFilter>();
        List<Plugin> list = PluginManager.getInstance().getPlugins();
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            try {
                Plugin plugin = object2.next();
                PluginDescriptor pluginDescriptor = plugin.getDescriptor();
                List<PluginDescriptor.PluginExtensionDescription> list2 = pluginDescriptor.getExtensions("StylesFilter");
                for (int i2 = 0; i2 < list2.size(); ++i2) {
                    PluginExtension pluginExtension = list2.get((int)i2).k;
                    if (!(pluginExtension instanceof GeneralStylesFilterExtension)) continue;
                    GeneralStylesFilterExtension generalStylesFilterExtension = (GeneralStylesFilterExtension)pluginExtension;
                    if (authorAccess != null && generalStylesFilterExtension instanceof AuthorExtensionStateListener) {
                        ((AuthorExtensionStateListener)((Object)generalStylesFilterExtension)).activated(authorAccess);
                    }
                    arrayList.add(generalStylesFilterExtension);
                }
            }
            catch (Exception exception) {
                b.fatal((Object)exception, (Throwable)exception);
            }
        }
        if (!arrayList.isEmpty()) {
            if (object != null) {
                arrayList.add(0, (StylesFilter)object);
            }
            object = object2 = new StylesFilter(){

                @Override
                public String getDescription() {
                    return "Proxy styles filter";
                }

                @Override
                public Styles filter(Styles styles, AuthorNode authorNode) {
                    for (StylesFilter stylesFilter : arrayList) {
                        Styles styles2 = stylesFilter.filter(styles, authorNode);
                        if (styles2 == null) continue;
                        styles = styles2;
                    }
                    return styles;
                }
            };
        }
        return object;
    }

    public static int compareVersions(String string, String string2) {
        int n2 = 0;
        String[] stringArray = string.split("\\.");
        String[] stringArray2 = string2.split("\\.");
        int n3 = Math.min(stringArray.length, stringArray2.length);
        for (int i2 = 0; i2 < n3 && n2 == 0; ++i2) {
            int n4 = 0;
            int n5 = 0;
            try {
                n4 = NumberParserUtil.parseInt((String)stringArray[i2]);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = -1;
            }
            try {
                n5 = NumberParserUtil.parseInt((String)stringArray2[i2]);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 1;
            }
            if (n2 != 0) continue;
            if (n4 < n5) {
                n2 = -1;
                continue;
            }
            if (n4 <= n5) continue;
            n2 = 1;
        }
        if (n2 == 0) {
            if (stringArray2.length < stringArray.length) {
                n2 = 1;
            } else if (stringArray2.length > stringArray.length) {
                n2 = -1;
            }
        }
        return n2;
    }
}

