/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.editor.validate;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.dt.PersistentObjectField;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.util.Equaler;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.editor.validate.ValidationEngine;
import ro.sync.exml.editor.validate.ValidationUnitAdvancedSettingsPO;
import ro.sync.exml.editor.validate.ValidationUnitSchema;
import ro.sync.exml.editor.validate.ValidationUnitType;
import ro.sync.options.InvalidPersistentObjException;
import ro.sync.options.PersistentObject;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class ValidationUnit
implements PersistentObject {
    private static final Logger logger = LoggerFactory.getLogger((String)ValidationUnit.class.getName());
    public static final String DEFAULT_ENGINE = "<Default engine>";
    public static final String XERCES_ENGINE = "Xerces";
    public static final String DITA_ENGINE = "DITA Validation";
    public static final String DITA_MAP_ENGINE = "DITA Map Validation and Completeness Check";
    public static final String DITA_PROJECT_ENGINE = "DITA-OT Project Validation and Completeness Check";
    public static final String TABLE_LAYOUT_VALIDATION_ENGINE = "Table Layout Validation";
    public static final String ANT_ENGINE = "ANT Validator";
    public static final String JSON_SCHEMA_ENGINE = "JSON Schema Validator";
    public static final String JSON_SCHEMATRON_ENGINE = "JSON Schematron Validator";
    public static final String HTML_ENGINE = "W3C HTML Validator";
    public static final String XHTML_ENGINE = "W3C XHTML Validator";
    public static final String HTML_SCHEMATRON_ENGINE = "HTML Schematron Validator";
    private ValidationUnitType validationType;
    @PersistentObjectField(hasEditorVariables=true)
    private String url;
    private ValidationEngine validationEngine;
    private boolean allowAutomaticValidation;
    @PersistentObjectField(hasEditorVariables=true)
    private String[] extensions;
    private ValidationUnitSchema validationSchema;
    private ValidationUnitAdvancedSettingsPO validationAdvancedSettings;

    public ValidationUnit(String string, ValidationEngine validationEngine, boolean bl, String[] stringArray, ValidationUnitType validationUnitType, ValidationUnitSchema validationUnitSchema) {
        this.url = string;
        this.validationEngine = validationEngine;
        this.allowAutomaticValidation = bl;
        this.extensions = stringArray;
        this.validationType = validationUnitType;
        this.validationSchema = validationUnitSchema;
    }

    public ValidationUnitType getValidationType() {
        return this.validationType;
    }

    public ValidationUnitSchema getValidationSchema() {
        return this.validationSchema;
    }

    public ValidationUnit() {
    }

    public boolean allowAutomaticValidation() {
        return this.allowAutomaticValidation;
    }

    public void setAllowAutomaticValidation(boolean bl) {
        this.allowAutomaticValidation = bl;
    }

    public ValidationEngine getValidationEngine() {
        return this.validationEngine;
    }

    public void setValidationEngine(ValidationEngine validationEngine) {
        this.validationEngine = validationEngine;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    @Override
    public void checkValid() throws InvalidPersistentObjException {
        if (this.url == null) {
            throw new InvalidPersistentObjException("Invalid URL in validation unit.");
        }
        if (this.validationEngine == null) {
            throw new InvalidPersistentObjException("Invalid engine in validation unit.");
        }
        if (this.validationType == null) {
            throw new InvalidPersistentObjException("Invalid validation type.");
        }
    }

    public int hashCode() {
        int n2 = 7;
        n2 = 31 * n2 + (this.url == null ? 0 : this.url.hashCode());
        n2 = 31 * n2 + Boolean.hashCode(this.allowAutomaticValidation);
        n2 = 31 * n2 + (this.validationEngine == null ? 0 : this.validationEngine.hashCode());
        n2 = 31 * n2 + (this.extensions == null ? 0 : Arrays.hashCode(this.extensions));
        n2 = 31 * n2 + (this.validationType == null ? 0 : this.validationType.hashCode());
        n2 = 31 * n2 + (this.validationSchema == null ? 0 : this.validationSchema.hashCode());
        n2 = 31 * n2 + (this.validationAdvancedSettings == null ? 0 : this.validationAdvancedSettings.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        boolean bl = object instanceof ValidationUnit;
        if (bl) {
            ValidationUnit validationUnit = (ValidationUnit)object;
            bl = this.url.equals(validationUnit.url) && this.validationEngine.equals(validationUnit.validationEngine) && this.allowAutomaticValidation == validationUnit.allowAutomaticValidation && Equaler.verifyArrayEquals((Object[])this.extensions, (Object[])validationUnit.extensions) && Equaler.verifyEquals((Object)this.validationType, (Object)validationUnit.validationType) && Equaler.verifyEquals((Object)this.validationSchema, (Object)validationUnit.validationSchema) && Equaler.verifyEquals((Object)this.validationAdvancedSettings, (Object)validationUnit.validationAdvancedSettings);
        }
        return bl;
    }

    @Override
    public Object clone() {
        ValidationUnit validationUnit = null;
        try {
            validationUnit = (ValidationUnit)super.clone();
            if (this.extensions != null) {
                validationUnit.extensions = (String[])this.extensions.clone();
            }
            if (this.validationEngine != null) {
                validationUnit.validationEngine = (ValidationEngine)this.validationEngine.clone();
            }
            if (this.validationType != null) {
                validationUnit.validationType = (ValidationUnitType)this.validationType.clone();
            }
            if (this.validationSchema != null) {
                validationUnit.validationSchema = (ValidationUnitSchema)this.validationSchema.clone();
            }
            if (this.validationAdvancedSettings != null) {
                validationUnit.validationAdvancedSettings = (ValidationUnitAdvancedSettingsPO)this.validationAdvancedSettings.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error((Object)cloneNotSupportedException, (Throwable)cloneNotSupportedException);
        }
        return validationUnit;
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    public void setExtensions(String[] stringArray) {
        this.extensions = stringArray;
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    public void setValidationType(ValidationUnitType validationUnitType) {
        this.validationType = validationUnitType;
    }

    public void setValidationSchema(ValidationUnitSchema validationUnitSchema) {
        this.validationSchema = validationUnitSchema;
    }

    public boolean isDefaultValidationUnit() {
        if (this.validationSchema == null) {
            return DEFAULT_ENGINE.equals(this.validationEngine.getEngineType());
        }
        return false;
    }

    public void setValidationAdvancedSettings(ValidationUnitAdvancedSettingsPO validationUnitAdvancedSettingsPO) {
        this.validationAdvancedSettings = validationUnitAdvancedSettingsPO;
    }

    public PersistentObject getValidationAdvancedSettings() {
        return this.validationAdvancedSettings;
    }

    public String toString() {
        return "Validation unit. url: " + URLUtil.filterPasswords((String)this.getUrl());
    }
}

