/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.editor.persistance;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.dt.PersistentObjectField;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.options.InvalidPersistentObjException;
import ro.sync.options.PersistentObject;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class DocTypeSchemaPO
implements PersistentObject {
    private static final Logger logger = LoggerFactory.getLogger((String)DocTypeSchemaPO.class.getName());
    public static final String XML_SCHEMA = "XML Schema";
    public static final String XML_SCHEMA_SCH = "XML Schema + Schematron";
    public static final String DTD_SCHEMA = "DTD";
    public static final String RNG_SCHEMA = "RNG Schema";
    public static final String RNG_SCHEMA_SCH = "RNG Schema + Schematron";
    public static final String RNC_SCHEMA = "RNC Schema";
    public static final String NVDL_SCHEMA = "NVDL";
    public static final String SCHEMATRON_SCHEMA = "Schematron";
    public static final String JSON_SCHEMA = "JSON Schema";
    public static final String JSON_META_SCHEMA = "JSON Meta Schema";
    private static final ImmutableMap<Integer, String> schemaTypeMap = ImmutableMap.builder().put((Object)NumberParserUtil.valueOfInteger((int)1), (Object)"DTD").put((Object)NumberParserUtil.valueOfInteger((int)2), (Object)"XML Schema").put((Object)NumberParserUtil.valueOfInteger((int)5), (Object)"XML Schema + Schematron").put((Object)NumberParserUtil.valueOfInteger((int)3), (Object)"RNC Schema").put((Object)NumberParserUtil.valueOfInteger((int)4), (Object)"RNG Schema").put((Object)NumberParserUtil.valueOfInteger((int)6), (Object)"RNG Schema + Schematron").put((Object)NumberParserUtil.valueOfInteger((int)9), (Object)"NVDL").put((Object)NumberParserUtil.valueOfInteger((int)7), (Object)"Schematron").put((Object)NumberParserUtil.valueOfInteger((int)10), (Object)"JSON Schema").put((Object)NumberParserUtil.valueOfInteger((int)11), (Object)"JSON Meta Schema").build();
    private int type = 0;
    @PersistentObjectField(hasEditorVariables=true, isIDTypeVariables=true)
    private String uri;

    public DocTypeSchemaPO() {
    }

    public DocTypeSchemaPO(String string, int n2) {
        this.type = n2;
        this.uri = string;
    }

    public String toString() {
        return "Schema URI:" + this.uri + ", type: " + DocTypeSchemaPO.typeToDescription(this.type);
    }

    public static String typeToDescription(int n2) {
        return String.valueOf(schemaTypeMap.get((Object)NumberParserUtil.valueOfInteger((int)n2)));
    }

    @Override
    public void checkValid() throws InvalidPersistentObjException {
        if (this.type == 0) {
            throw new InvalidPersistentObjException("Schema type is not defined");
        }
        if (this.uri == null || this.uri.trim().length() == 0) {
            throw new InvalidPersistentObjException("Schema URI must be specified");
        }
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error((Object)cloneNotSupportedException, (Throwable)cloneNotSupportedException);
            return null;
        }
    }

    public int getType() {
        return this.type;
    }

    public String getURI() {
        return this.uri;
    }

    public static int descriptionToType(String string) {
        int n2 = 0;
        ImmutableSet immutableSet = schemaTypeMap.keySet();
        for (Integer n3 : immutableSet) {
            if (!string.equals(schemaTypeMap.get((Object)n3))) continue;
            n2 = n3;
            break;
        }
        return n2;
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder("Schema URI: ");
        stringBuilder.append(this.uri);
        String string = DocTypeSchemaPO.typeToDescription(this.type);
        if (string != null && !string.isEmpty()) {
            stringBuilder.append(", type: ");
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }
}

