/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.editor.notifications.content;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.editor.notifications.b.b;
import ro.sync.exml.editor.notifications.content.Product;
import ro.sync.exml.editor.notifications.content.c;
import ro.sync.exml.editor.notifications.content.f;

@XmlAccessorType(value=XmlAccessType.FIELD)
@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class UpcomingEvent
implements f {
    private static final File EVENTS_IMG_FOLDER = new File(b.g, "events");
    public static final Comparator<UpcomingEvent> UPCOMING_EVENTS_SORTER_BY_DATE = new Comparator<UpcomingEvent>(){

        public int b(UpcomingEvent upcomingEvent, UpcomingEvent upcomingEvent2) {
            int n2 = upcomingEvent.getEventStartDate().compareTo(upcomingEvent2.getEventStartDate());
            if (n2 == 0) {
                n2 = upcomingEvent.getEventEndDate().compareTo(upcomingEvent2.getEventEndDate());
            }
            return n2;
        }
    };
    @XmlAttribute(name="products")
    private String[] availableProducts;
    @XmlAttribute(name="title")
    private String eventName;
    @XmlAttribute(name="startDate")
    @XmlJavaTypeAdapter(value=c.class)
    private Date eventStartDate;
    @XmlAttribute(name="endDate")
    @XmlJavaTypeAdapter(value=c.class)
    private Date eventEndDate;
    @XmlAttribute(name="url")
    private String eventURL;
    @XmlAttribute(name="location")
    private String eventLocation;
    @XmlAttribute(name="img")
    private String eventImageURL;
    private URL eventLocalImageURL;

    UpcomingEvent() {
    }

    public UpcomingEvent(String string) {
        this.eventName = string;
    }

    public String getEventName() {
        return this.eventName.replaceAll("\\s+", " ").trim();
    }

    public Date getEventStartDate() {
        return this.eventStartDate;
    }

    public Date getEventEndDate() {
        return this.eventEndDate != null ? this.eventEndDate : this.eventStartDate;
    }

    public String getEventURL() {
        return this.eventURL;
    }

    public String getEventLocation() {
        if (this.eventLocation != null) {
            return this.eventLocation.replaceAll("\\s+", " ").trim();
        }
        return this.eventLocation;
    }

    @Override
    public String getImageURLAsString() {
        return this.eventImageURL;
    }

    public URL getEventLocalImageURL() {
        if (this.eventLocalImageURL == null && this.eventImageURL != null) {
            String string = URLUtil.extractFileName((String)this.eventImageURL);
            try {
                File file = new File(EVENTS_IMG_FOLDER, string);
                if (file.exists()) {
                    this.eventLocalImageURL = URLUtil.correct((File)file);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return this.eventLocalImageURL;
    }

    public List<Product> getAvailableProducts() {
        ArrayList<Product> arrayList = new ArrayList<Product>();
        if (this.availableProducts != null) {
            for (String string : this.availableProducts) {
                arrayList.add(Product.getProduct(string));
            }
        }
        return arrayList;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getEventName());
        stringBuilder.append(" Location: ").append(this.eventLocation);
        stringBuilder.append("\n StartDate: ").append(this.eventStartDate);
        stringBuilder.append(" EndDate: ").append(this.eventEndDate);
        stringBuilder.append("\n URL: ").append(this.eventURL);
        stringBuilder.append("\n img URL: ").append(this.eventImageURL);
        if (this.availableProducts != null) {
            stringBuilder.append("\n products: ").append(Arrays.asList(this.availableProducts));
        }
        return stringBuilder.toString();
    }
}

