/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.persistance;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.dt.PersistentObjectField;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.ecss.persistance.MenuEntryPO;
import ro.sync.ecss.persistance.MenuItemPO;
import ro.sync.options.InvalidPersistentObjException;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class MenuPO
implements MenuEntryPO {
    private static final Logger logger = LoggerFactory.getLogger((String)MenuPO.class.getName());
    @PersistentObjectField(hasEditorVariables=false, isIDTypeVariables=true)
    private String label = null;
    @PersistentObjectField(hasEditorVariables=false)
    private String accessKey = null;
    @PersistentObjectField(hasEditorVariables=true)
    private String iconPath = null;
    private MenuEntryPO[] menuEntriesDescriptorList;
    @PersistentObjectField(hasEditorVariables=false)
    private String context = null;
    public static final String TABLE_CONTEXT = "table";

    public MenuPO(String string, String string2, String string3, MenuEntryPO[] menuEntryPOArray) {
        this(string, string2, string3, menuEntryPOArray, null);
    }

    public MenuPO(String string, String string2, String string3, MenuEntryPO[] menuEntryPOArray, String string4) {
        this.label = string;
        this.accessKey = string2;
        this.iconPath = string3;
        this.menuEntriesDescriptorList = menuEntryPOArray;
        this.context = string4;
    }

    public MenuPO() {
    }

    public MenuEntryPO[] getMenuEntriesDescriptorList() {
        return this.menuEntriesDescriptorList;
    }

    public String getLabel() {
        return this.label;
    }

    public String getContext() {
        return this.context;
    }

    @Override
    public int getType() {
        return 2;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public char getAccessKey() {
        if (this.accessKey != null && this.accessKey.length() > 0) {
            return this.accessKey.charAt(0);
        }
        return '\u0000';
    }

    @Override
    public void checkValid() throws InvalidPersistentObjException {
        if (this.label == null) {
            throw new InvalidPersistentObjException("Null menu label.");
        }
        if (this.menuEntriesDescriptorList == null) {
            throw new InvalidPersistentObjException("Invalid entries list for menu.");
        }
    }

    @Override
    public Object clone() {
        MenuPO menuPO = null;
        try {
            menuPO = (MenuPO)super.clone();
            if (this.menuEntriesDescriptorList != null) {
                menuPO.menuEntriesDescriptorList = (MenuEntryPO[])this.menuEntriesDescriptorList.clone();
                for (int i2 = 0; i2 < menuPO.menuEntriesDescriptorList.length; ++i2) {
                    if (this.menuEntriesDescriptorList[i2] == null) continue;
                    menuPO.menuEntriesDescriptorList[i2] = (MenuEntryPO)this.menuEntriesDescriptorList[i2].clone();
                }
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error((Object)cloneNotSupportedException, (Throwable)cloneNotSupportedException);
        }
        return menuPO;
    }

    public void addMenuEntry(MenuEntryPO menuEntryPO, int n2) {
        MenuEntryPO[] menuEntryPOArray = new MenuEntryPO[this.menuEntriesDescriptorList.length + 1];
        System.arraycopy(this.menuEntriesDescriptorList, 0, menuEntryPOArray, 0, n2);
        menuEntryPOArray[n2] = menuEntryPO;
        System.arraycopy(this.menuEntriesDescriptorList, n2, menuEntryPOArray, n2 + 1, this.menuEntriesDescriptorList.length - n2);
        this.menuEntriesDescriptorList = menuEntryPOArray;
    }

    public int removeMenuEntry(MenuEntryPO menuEntryPO) {
        MenuEntryPO[] menuEntryPOArray = new MenuEntryPO[this.menuEntriesDescriptorList.length - 1];
        int n2 = 0;
        while (!this.menuEntriesDescriptorList[n2].equals(menuEntryPO)) {
            menuEntryPOArray[n2] = this.menuEntriesDescriptorList[n2];
            ++n2;
        }
        System.arraycopy(this.menuEntriesDescriptorList, n2 + 1, menuEntryPOArray, n2, this.menuEntriesDescriptorList.length - n2 - 1);
        this.menuEntriesDescriptorList = menuEntryPOArray;
        return n2;
    }

    public void updateMenu(String string, String string2, String string3, String string4) {
        this.label = string;
        this.accessKey = string2;
        this.iconPath = string3;
        this.context = string4;
    }

    public void removeMenuEntries(String string) {
        block4: for (int i2 = this.menuEntriesDescriptorList.length - 1; i2 >= 0; --i2) {
            MenuEntryPO menuEntryPO = this.menuEntriesDescriptorList[i2];
            switch (menuEntryPO.getType()) {
                case 0: {
                    MenuItemPO menuItemPO = (MenuItemPO)menuEntryPO;
                    if (!string.equals(menuItemPO.getActionID())) continue block4;
                    this.removeMenuEntry(menuItemPO);
                    continue block4;
                }
                case 2: {
                    ((MenuPO)menuEntryPO).removeMenuEntries(string);
                    continue block4;
                }
            }
        }
    }

    public void changeActionID(String string, String string2) {
        block4: for (int i2 = 0; i2 < this.menuEntriesDescriptorList.length; ++i2) {
            MenuEntryPO menuEntryPO = this.menuEntriesDescriptorList[i2];
            switch (menuEntryPO.getType()) {
                case 0: {
                    MenuItemPO menuItemPO = (MenuItemPO)menuEntryPO;
                    if (!string.equals(menuItemPO.getActionID())) continue block4;
                    menuItemPO.setActionID(string2);
                    continue block4;
                }
                case 2: {
                    ((MenuPO)menuEntryPO).changeActionID(string, string2);
                    continue block4;
                }
            }
        }
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }
}

