/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.persistance;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.dt.PersistentObjectField;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.ecss.persistance.ActionPO;
import ro.sync.ecss.persistance.CSSDescriptorPO;
import ro.sync.ecss.persistance.ContextProviderPO;
import ro.sync.ecss.persistance.MenuPO;
import ro.sync.ecss.persistance.ToolbarEntryPO;
import ro.sync.ecss.persistance.ToolbarPO;
import ro.sync.ecss.persistance.external.ExternalActionPO;
import ro.sync.options.InvalidPersistentObjException;
import ro.sync.options.PersistentObject;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class AuthorExtensionPO
implements PersistentObject {
    private static final Logger logger = LoggerFactory.getLogger((String)AuthorExtensionPO.class.getName());
    private CSSDescriptorPO[] cssDescriptors;
    private boolean mergeCSSsFromDocument;
    private boolean multipleAlternateSelectionEnabled;
    private ActionPO[] actionDescriptors;
    private ActionPO[] externalActionDescriptors;
    private ActionPO[] externalActionsPendingDelete;
    private MenuPO menubarDescriptor;
    private MenuPO popupMenuDescriptor;
    private ToolbarPO toolbarDescriptor;
    private ToolbarPO[] additionalToolbarsDescriptors;
    private ContextProviderPO contextualItems;
    @PersistentObjectField(hasEditorVariables=false)
    protected String tableSupportClassName;
    @PersistentObjectField(hasEditorVariables=false)
    protected String tableCellSeparatorSupportClassName;
    @PersistentObjectField(hasEditorVariables=false)
    protected String tableColWidthSupportClassName;
    @PersistentObjectField(hasEditorVariables=false)
    protected String customReferencesResolver;
    @PersistentObjectField(hasEditorVariables=false)
    protected String editPropertiesHandler;
    @PersistentObjectField(hasEditorVariables=false)
    private String authorExtensionStateListener;
    @PersistentObjectField(hasEditorVariables=false)
    private String attributesRecognizer;
    @PersistentObjectField(hasEditorVariables=false)
    private String authorActionEventHandler;
    @PersistentObjectField(hasEditorVariables=false)
    private String authorImageDecorator;

    public AuthorExtensionPO(CSSDescriptorPO[] cSSDescriptorPOArray, boolean bl, ActionPO[] actionPOArray, MenuPO menuPO, ToolbarPO toolbarPO, ToolbarPO[] toolbarPOArray, MenuPO menuPO2, ContextProviderPO contextProviderPO, String string, String string2, String string3, String string4, String string5, String string6) {
        this.cssDescriptors = cSSDescriptorPOArray;
        this.mergeCSSsFromDocument = bl;
        this.actionDescriptors = actionPOArray;
        this.menubarDescriptor = menuPO;
        this.toolbarDescriptor = toolbarPO;
        this.additionalToolbarsDescriptors = toolbarPOArray;
        this.popupMenuDescriptor = menuPO2;
        this.tableSupportClassName = string;
        this.tableCellSeparatorSupportClassName = string2;
        this.tableColWidthSupportClassName = string3;
        this.customReferencesResolver = string4;
        this.authorExtensionStateListener = string5;
        this.attributesRecognizer = string6;
    }

    public AuthorExtensionPO() {
    }

    public String getTableSpanSupportClassName() {
        return this.tableSupportClassName;
    }

    public String getTableColWidthSupportClassName() {
        return this.tableColWidthSupportClassName;
    }

    public String getReferencesResolverClassName() {
        return this.customReferencesResolver;
    }

    public void setTableSpanSupportClassName(String string) {
        this.tableSupportClassName = string;
    }

    public void setTableColWidthSupportClassName(String string) {
        this.tableColWidthSupportClassName = string;
    }

    public void setReferencesResolverClassName(String string) {
        this.customReferencesResolver = string;
    }

    public ActionPO[] getActionDescriptors() {
        if (this.externalActionDescriptors != null && this.externalActionDescriptors.length > 0) {
            ArrayList<ActionPO> arrayList = new ArrayList<ActionPO>();
            arrayList.addAll(Arrays.asList(this.externalActionDescriptors));
            if (this.actionDescriptors != null) {
                arrayList.addAll(Arrays.asList(this.actionDescriptors));
            }
            return arrayList.toArray(new ActionPO[0]);
        }
        return this.actionDescriptors;
    }

    public CSSDescriptorPO[] getCSSDescriptors() {
        return AuthorExtensionPO.removeNullDescriptors(this.cssDescriptors);
    }

    public void setCSSDescriptors(CSSDescriptorPO[] cSSDescriptorPOArray) {
        this.cssDescriptors = cSSDescriptorPOArray;
    }

    public ToolbarPO[] getToolbarDescriptors() {
        int n2 = 0;
        if (this.toolbarDescriptor != null) {
            ++n2;
        }
        if (this.additionalToolbarsDescriptors != null) {
            n2 += this.additionalToolbarsDescriptors.length;
        }
        ToolbarPO[] toolbarPOArray = new ToolbarPO[n2];
        int n3 = 0;
        if (this.toolbarDescriptor != null) {
            toolbarPOArray[n3] = this.toolbarDescriptor;
            ++n3;
        }
        if (this.additionalToolbarsDescriptors != null) {
            for (int i2 = 0; i2 < this.additionalToolbarsDescriptors.length; ++i2) {
                toolbarPOArray[n3] = this.additionalToolbarsDescriptors[i2];
                ++n3;
            }
        }
        return toolbarPOArray;
    }

    public ToolbarPO[] getToolbarDescriptors(int n2) {
        ToolbarPO[] toolbarPOArray = this.getToolbarDescriptors();
        if (toolbarPOArray.length > n2) {
            ToolbarPO[] toolbarPOArray2 = new ToolbarPO[n2];
            System.arraycopy(toolbarPOArray, 0, toolbarPOArray2, 0, toolbarPOArray2.length);
            ArrayList<ToolbarEntryPO> arrayList = new ArrayList<ToolbarEntryPO>();
            ToolbarPO toolbarPO = toolbarPOArray[n2 - 1];
            ToolbarEntryPO[] toolbarEntryPOArray = toolbarPO.getToolbarEntriesDescriptorList();
            if (toolbarEntryPOArray != null && toolbarEntryPOArray.length > 0) {
                arrayList.addAll(Arrays.asList(toolbarEntryPOArray));
            }
            for (int i2 = n2; i2 < toolbarPOArray.length; ++i2) {
                ToolbarPO toolbarPO2 = toolbarPOArray[i2].clone();
                toolbarPO2.setType(3);
                arrayList.add(toolbarPO2);
            }
            toolbarPO = toolbarPO.clone();
            toolbarPO.setToolbarEntries(arrayList.toArray(new ToolbarEntryPO[0]));
            toolbarPOArray2[n2 - 1] = toolbarPO;
            toolbarPOArray = toolbarPOArray2;
        }
        return toolbarPOArray;
    }

    public MenuPO getMenubarDescriptor() {
        return this.menubarDescriptor;
    }

    public MenuPO getPopupMenuDescriptor() {
        return this.popupMenuDescriptor;
    }

    @Override
    public void checkValid() throws InvalidPersistentObjException {
        ArrayList<ActionPO> arrayList = new ArrayList<ActionPO>();
        if (this.actionDescriptors != null) {
            for (int i2 = 0; i2 < this.actionDescriptors.length; ++i2) {
                if (this.actionDescriptors[i2] != null) {
                    arrayList.add(this.actionDescriptors[i2]);
                    continue;
                }
                logger.error("Action PO is null");
            }
        }
        if (!arrayList.isEmpty()) {
            this.actionDescriptors = arrayList.toArray(new ActionPO[0]);
        }
    }

    @Override
    public Object clone() {
        AuthorExtensionPO authorExtensionPO = null;
        try {
            authorExtensionPO = (AuthorExtensionPO)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error((Object)cloneNotSupportedException, (Throwable)cloneNotSupportedException);
        }
        if (authorExtensionPO != null) {
            if (this.actionDescriptors != null) {
                authorExtensionPO.actionDescriptors = (ActionPO[])this.actionDescriptors.clone();
                for (int i2 = 0; i2 < authorExtensionPO.actionDescriptors.length; ++i2) {
                    if (this.actionDescriptors[i2] == null) continue;
                    authorExtensionPO.actionDescriptors[i2] = (ActionPO)this.actionDescriptors[i2].clone();
                }
            }
            if (this.externalActionDescriptors != null) {
                authorExtensionPO.externalActionDescriptors = (ActionPO[])this.externalActionDescriptors.clone();
                for (int i3 = 0; i3 < authorExtensionPO.externalActionDescriptors.length; ++i3) {
                    if (this.externalActionDescriptors[i3] == null) continue;
                    authorExtensionPO.externalActionDescriptors[i3] = (ActionPO)this.externalActionDescriptors[i3].clone();
                }
            }
            if (this.externalActionsPendingDelete != null) {
                authorExtensionPO.externalActionsPendingDelete = (ActionPO[])this.externalActionsPendingDelete.clone();
                for (int i4 = 0; i4 < authorExtensionPO.externalActionsPendingDelete.length; ++i4) {
                    if (this.externalActionsPendingDelete[i4] == null) continue;
                    authorExtensionPO.externalActionsPendingDelete[i4] = (ActionPO)this.externalActionsPendingDelete[i4].clone();
                }
            }
            if (this.cssDescriptors != null) {
                authorExtensionPO.cssDescriptors = (CSSDescriptorPO[])this.cssDescriptors.clone();
                for (int i5 = 0; i5 < authorExtensionPO.cssDescriptors.length; ++i5) {
                    if (this.cssDescriptors[i5] == null) continue;
                    authorExtensionPO.cssDescriptors[i5] = (CSSDescriptorPO)this.cssDescriptors[i5].clone();
                }
            }
            if (this.menubarDescriptor != null) {
                authorExtensionPO.menubarDescriptor = (MenuPO)this.menubarDescriptor.clone();
            }
            if (this.popupMenuDescriptor != null) {
                authorExtensionPO.popupMenuDescriptor = (MenuPO)this.popupMenuDescriptor.clone();
            }
            if (this.toolbarDescriptor != null) {
                authorExtensionPO.toolbarDescriptor = this.toolbarDescriptor.clone();
            }
            if (this.contextualItems != null) {
                authorExtensionPO.contextualItems = (ContextProviderPO)this.contextualItems.clone();
            }
            if (this.additionalToolbarsDescriptors != null) {
                authorExtensionPO.additionalToolbarsDescriptors = (ToolbarPO[])this.additionalToolbarsDescriptors.clone();
                for (int i6 = 0; i6 < authorExtensionPO.additionalToolbarsDescriptors.length; ++i6) {
                    if (this.additionalToolbarsDescriptors[i6] == null) continue;
                    authorExtensionPO.additionalToolbarsDescriptors[i6] = this.additionalToolbarsDescriptors[i6].clone();
                }
            }
        }
        return authorExtensionPO;
    }

    public void setActionDescriptors(ActionPO[] actionPOArray) {
        if (actionPOArray != null) {
            ArrayList<ActionPO> arrayList = new ArrayList<ActionPO>();
            ArrayList<ActionPO> arrayList2 = new ArrayList<ActionPO>();
            for (int i2 = 0; i2 < actionPOArray.length; ++i2) {
                if (actionPOArray[i2].isExternal()) {
                    arrayList2.add(actionPOArray[i2]);
                    continue;
                }
                arrayList.add(actionPOArray[i2]);
            }
            this.actionDescriptors = arrayList.toArray(new ActionPO[0]);
            this.externalActionDescriptors = arrayList2.toArray(new ActionPO[0]);
        } else {
            this.actionDescriptors = actionPOArray;
        }
    }

    public void setMenubarDescriptor(MenuPO menuPO) {
        this.menubarDescriptor = menuPO;
    }

    public void setPopupMenuDescriptor(MenuPO menuPO) {
        this.popupMenuDescriptor = menuPO;
    }

    public void setToolbarDescriptors(ToolbarPO[] toolbarPOArray) {
        this.toolbarDescriptor = null;
        this.additionalToolbarsDescriptors = null;
        if (toolbarPOArray != null) {
            for (int i2 = 0; i2 < toolbarPOArray.length; ++i2) {
                if (i2 == 0) {
                    this.toolbarDescriptor = toolbarPOArray[i2];
                    continue;
                }
                if (this.additionalToolbarsDescriptors == null) {
                    this.additionalToolbarsDescriptors = new ToolbarPO[toolbarPOArray.length - 1];
                }
                this.additionalToolbarsDescriptors[i2 - 1] = toolbarPOArray[i2];
            }
        }
    }

    public void setContextItemsProvider(ContextProviderPO contextProviderPO) {
        this.contextualItems = contextProviderPO;
    }

    public ContextProviderPO getContextItemsProvider() {
        return this.contextualItems;
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return new String[]{"externalActionDescriptors", "externalActionsPendingDelete"};
    }

    public boolean isMergeCSSsFromDocument() {
        return this.mergeCSSsFromDocument;
    }

    public void setMergeCSSsFromDocument(boolean bl) {
        this.mergeCSSsFromDocument = bl;
    }

    public String getAuthorExtensionStateListenerClassName() {
        return this.authorExtensionStateListener;
    }

    public void setAuthorExtensionStateListener(String string) {
        this.authorExtensionStateListener = string;
    }

    public String getUniqueAttributesRecognizerClassName() {
        return this.attributesRecognizer;
    }

    public void setUniqueAttributesRecognizer(String string) {
        this.attributesRecognizer = string;
    }

    public boolean isMultipleAlternateSelectionEnabled() {
        return this.multipleAlternateSelectionEnabled;
    }

    public void setMultipleAlternateSelectionEnabled(boolean bl) {
        this.multipleAlternateSelectionEnabled = bl;
    }

    public String getEditPropertiesHandler() {
        return this.editPropertiesHandler;
    }

    public void setEditPropertiesHandler(String string) {
        this.editPropertiesHandler = string;
    }

    public String getAuthorActionEventHandler() {
        return this.authorActionEventHandler;
    }

    public void setAuthorActionEventHandler(String string) {
        this.authorActionEventHandler = string;
    }

    public String getAuthorImageDecorator() {
        return this.authorImageDecorator;
    }

    public void setAuthorImageDecorator(String string) {
        this.authorImageDecorator = string;
    }

    public String getTableCellSeparatorSupportClassName() {
        return this.tableCellSeparatorSupportClassName;
    }

    public void setTableCellSeparatorSupportClassName(String string) {
        this.tableCellSeparatorSupportClassName = string;
    }

    public void setExternalActionDescriptors(ActionPO[] actionPOArray) {
        this.externalActionDescriptors = actionPOArray;
    }

    public void saveExternalActions() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.externalActionDescriptors != null) {
            for (int i2 = 0; i2 < this.externalActionDescriptors.length; ++i2) {
                if (logger.isDebugEnabled()) {
                    logger.debug("External action saved: " + this.externalActionDescriptors[i2].getId());
                }
                try {
                    String string = this.fixExternalSaveLocation(hashSet, this.externalActionDescriptors[i2]);
                    hashSet.add(string);
                    this.externalActionDescriptors[i2].save();
                    continue;
                }
                catch (Exception exception) {
                    logger.error("Failed to save: " + this.externalActionDescriptors[i2].getId() + " , error: " + exception.getMessage(), (Throwable)exception);
                }
            }
        }
        this.processDeletedActions(hashSet);
    }

    private String fixExternalSaveLocation(Set<String> set, ActionPO actionPO) {
        File file = actionPO.getExternalLocation();
        String string = file.getAbsolutePath();
        if (set.contains(string)) {
            File file2 = file.getParentFile();
            String string2 = file.getName();
            int n2 = string2.indexOf(".xml");
            if (n2 != -1) {
                string2 = string2.substring(0, n2);
            }
            int n3 = 1;
            do {
                file = new File(file2, string2 + "-" + n3 + ".xml");
                string = file.getAbsolutePath();
                ++n3;
            } while (set.contains(string));
            ((ExternalActionPO)actionPO).setExternalLocation(file);
        }
        return string;
    }

    private void processDeletedActions(Set<String> set) {
        if (this.externalActionsPendingDelete != null && this.externalActionsPendingDelete.length > 0) {
            for (ActionPO actionPO : this.externalActionsPendingDelete) {
                File file = actionPO.getExternalLocation();
                if (logger.isDebugEnabled()) {
                    logger.debug("Delete external action " + file.getAbsolutePath());
                }
                if (set.contains(file.getAbsolutePath()) || !file.exists()) continue;
                try {
                    Files.delete(file.toPath());
                }
                catch (IOException iOException) {
                    logger.error((Object)iOException, (Throwable)iOException);
                }
            }
            this.externalActionsPendingDelete = null;
        }
    }

    public ActionPO[] getExternalActionDescriptors() {
        return this.externalActionDescriptors;
    }

    public void setExternalActionPendingDelete(ActionPO[] actionPOArray) {
        this.externalActionsPendingDelete = actionPOArray;
    }

    public ActionPO[] getExternalActionPendingDelete() {
        return this.externalActionsPendingDelete;
    }

    public static CSSDescriptorPO[] removeNullDescriptors(CSSDescriptorPO[] cSSDescriptorPOArray) {
        if (cSSDescriptorPOArray != null) {
            boolean bl = false;
            for (int i2 = 0; i2 < cSSDescriptorPOArray.length; ++i2) {
                if (cSSDescriptorPOArray[i2] != null) continue;
                bl = true;
                break;
            }
            if (bl) {
                ArrayList<CSSDescriptorPO> arrayList = new ArrayList<CSSDescriptorPO>(cSSDescriptorPOArray.length);
                for (int i3 = 0; i3 < cSSDescriptorPOArray.length; ++i3) {
                    if (cSSDescriptorPOArray[i3] == null) continue;
                    arrayList.add(cSSDescriptorPOArray[i3]);
                }
                cSSDescriptorPOArray = arrayList.toArray(new CSSDescriptorPO[0]);
            }
        }
        return cSSDescriptorPOArray;
    }
}

