/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.support;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSepProvider;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.AuthorTableColumnWidthProviderBase;
import ro.sync.ecss.extensions.api.WidthRepresentation;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.table.operations.cals.CALSConstants;
import ro.sync.ecss.extensions.commons.table.support.CALSColSpanSpec;
import ro.sync.ecss.extensions.commons.table.support.CALSColSpec;
import ro.sync.ecss.extensions.commons.table.support.errorscanner.CALSAndHTMLTableLayoutProblem;
import ro.sync.ecss.extensions.commons.table.support.errorscanner.TableLayoutErrorsListener;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class CALSTableCellInfoProvider
extends AuthorTableColumnWidthProviderBase
implements AuthorTableCellSpanProvider,
CALSConstants,
AuthorTableCellSepProvider {
    public static final WidthRepresentation DEFAULT_WIDTH_REPRESENTATION = new WidthRepresentation(0.0f, null, 1.0f, false){

        @Override
        public boolean isSpecified() {
            return false;
        }
    };
    private static final String CALS_DOCBOOK_CELL_NAME = "entry";
    private Map<CALSColSpec, AuthorElement> colspecInfosMap = new TreeMap<CALSColSpec, AuthorElement>(new ColspecComparator());
    protected List<CALSColSpanSpec> spanspecInfos = new ArrayList<CALSColSpanSpec>();
    private AuthorElement tableElement;
    private static final String COLSPEC_NAME_PREFIX = "c";
    private boolean colsepAndRowSepAreVisibleByDefault = false;

    public CALSTableCellInfoProvider(boolean bl) {
        this(bl, null);
    }

    public CALSTableCellInfoProvider() {
        this(false, null);
    }

    public CALSTableCellInfoProvider(boolean bl, TableLayoutErrorsListener tableLayoutErrorsListener) {
        super(tableLayoutErrorsListener);
        this.colsepAndRowSepAreVisibleByDefault = bl;
    }

    @Override
    public Integer getColSpan(AuthorElement authorElement) {
        Object object;
        Integer n2 = null;
        Object object2 = null;
        String string = null;
        String string2 = CALSTableCellInfoProvider.getAttributeValue(authorElement, "spanname");
        if (string2 != null) {
            object = this.getSpanSpec(string2);
            if (object != null) {
                object2 = ((CALSColSpanSpec)object).getStartColumnName();
                string = ((CALSColSpanSpec)object).getEndColumnName();
            }
        } else {
            object = CALSTableCellInfoProvider.getAttributeValue(authorElement, "namest");
            String string3 = CALSTableCellInfoProvider.getAttributeValue(authorElement, "nameend");
            if (object != null && string3 != null) {
                object2 = object;
                string = string3;
            }
        }
        if (object2 != null && string != null && (object = (Object)this.getColSpan((String)object2, string, authorElement)) != null) {
            n2 = Math.abs((int)(object[1] - object[0])) + 1;
        }
        return n2;
    }

    public int[] getColSpanInterval(AuthorElement authorElement) {
        int[] nArray = null;
        String string = null;
        String string2 = null;
        String string3 = CALSTableCellInfoProvider.getAttributeValue(authorElement, "spanname");
        if (string3 != null) {
            CALSColSpanSpec cALSColSpanSpec = this.getSpanSpec(string3);
            if (cALSColSpanSpec != null) {
                string = cALSColSpanSpec.getStartColumnName();
                string2 = cALSColSpanSpec.getEndColumnName();
            }
        } else {
            String string4 = CALSTableCellInfoProvider.getAttributeValue(authorElement, "namest");
            String string5 = CALSTableCellInfoProvider.getAttributeValue(authorElement, "nameend");
            if (string4 != null && string5 != null) {
                string = string4;
                string2 = string5;
            }
        }
        if (string != null && string2 != null) {
            nArray = this.getColSpan(string, string2, authorElement);
        }
        return nArray;
    }

    private int[] getColSpan(String string, String string2, AuthorElement authorElement) {
        int[] nArray = null;
        int n2 = -1;
        int n3 = -1;
        Set<CALSColSpec> set = this.colspecInfosMap.keySet();
        for (CALSColSpec cALSColSpec : set) {
            if (string.equals(cALSColSpec.getColumnName())) {
                n2 = cALSColSpec.getColumnNumber();
            }
            if (!string2.equals(cALSColSpec.getColumnName())) continue;
            n3 = cALSColSpec.getColumnNumber();
        }
        if (this.errorsListener != null) {
            if (n2 == -1 || n3 == -1) {
                if (n2 == -1) {
                    this.errorsListener.add(authorElement, this.tableElement, CALSAndHTMLTableLayoutProblem.COLUMN_NAME_INCORRECT, string, "namest");
                }
                if (n3 == -1) {
                    this.errorsListener.add(authorElement, this.tableElement, CALSAndHTMLTableLayoutProblem.COLUMN_NAME_INCORRECT, string2, "nameend");
                }
            } else if (n3 < n2) {
                this.errorsListener.add(authorElement, this.tableElement, CALSAndHTMLTableLayoutProblem.NAMEST_LESS_THAN_NAMEEND, n2, n3);
            }
        }
        if (n2 != -1 && n3 != -1) {
            nArray = new int[]{n2, n3};
        }
        return nArray;
    }

    @Override
    public Integer getRowSpan(AuthorElement authorElement) {
        Integer n2 = null;
        String string = CALSTableCellInfoProvider.getAttributeValue(authorElement, "morerows");
        if (string != null) {
            try {
                int n3 = NumberParserUtil.parseInt((String)string);
                if (n3 >= 1) {
                    n2 = n3 + 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    @Override
    public void init(AuthorElement authorElement) {
        this.tableElement = authorElement;
        this.colspecInfosMap.clear();
        this.spanspecInfos.clear();
        int n2 = 0;
        List<AuthorNode> list = authorElement.getContentNodes();
        int n3 = 0;
        for (AuthorNode authorNode : list) {
            String string;
            String string2;
            if (!(authorNode instanceof AuthorElement)) continue;
            AuthorElement authorElement2 = (AuthorElement)authorNode;
            if (this.isColspec(authorElement2)) {
                Object object;
                Object object2;
                Object object3;
                int n4;
                boolean bl;
                block19: {
                    bl = false;
                    string2 = CALSTableCellInfoProvider.getAttributeValue(authorElement2, "colnum");
                    n4 = -1;
                    if (string2 != null) {
                        try {
                            n4 = NumberParserUtil.parseInt((String)string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (this.errorsListener == null) break block19;
                            this.errorsListener.add(authorElement2, authorElement, CALSAndHTMLTableLayoutProblem.ATTRIBUTE_VALUE_NOT_INTEGER, "colnum", string2);
                        }
                    }
                }
                if (n4 != -1) {
                    n3 = n4;
                    bl = true;
                } else {
                    ++n3;
                }
                string2 = CALSTableCellInfoProvider.getAttributeValue(authorElement2, "colname");
                string = null;
                if (string2 != null) {
                    string = string2;
                }
                string2 = CALSTableCellInfoProvider.getAttributeValue(authorElement2, "colwidth");
                String string3 = null;
                if (string2 != null) {
                    string3 = string2;
                    if (this.errorsListener != null) {
                        object3 = new StringTokenizer(string3, "-+", false);
                        while (((StringTokenizer)object3).hasMoreTokens()) {
                            object2 = ((StringTokenizer)object3).nextToken().trim();
                            if (((String)object2).endsWith("*") && !"*".equals(object2)) {
                                object = ((String)object2).substring(0, ((String)object2).length() - 1);
                                this.reportInvalidFloat(authorElement, authorElement2, (String)object, string3);
                                continue;
                            }
                            if (!((String)object2).endsWith("pt") && !((String)object2).endsWith("px")) continue;
                            object = ((String)object2).substring(0, ((String)object2).length() - 2);
                            this.reportInvalidFloat(authorElement, authorElement2, (String)object, string3);
                        }
                    }
                }
                string2 = CALSTableCellInfoProvider.getAttributeValue(authorElement2, "align");
                object3 = null;
                if (string2 != null) {
                    object3 = string2;
                }
                string2 = CALSTableCellInfoProvider.getAttributeValue(authorElement2, "colsep");
                object2 = null;
                if (string2 != null) {
                    object2 = "1".equals(string2);
                }
                string2 = CALSTableCellInfoProvider.getAttributeValue(authorElement2, "rowsep");
                object = null;
                if (string2 != null) {
                    object = "1".equals(string2);
                }
                CALSColSpec cALSColSpec = new CALSColSpec(n2, n3, bl, string, string3, (Boolean)object2, (Boolean)object);
                cALSColSpec.setAlign((String)object3);
                if (this.colspecInfosMap.containsKey(cALSColSpec) && this.errorsListener != null) {
                    this.errorsListener.add(authorElement2, authorElement, CALSAndHTMLTableLayoutProblem.DUPLICATE_COLSPEC_NUMBER, cALSColSpec.getColumnNumber());
                }
                this.colspecInfosMap.put(cALSColSpec, authorElement2);
                ++n2;
                continue;
            }
            if (!"spanspec".equalsIgnoreCase(authorElement2.getLocalName())) continue;
            String string4 = null;
            string2 = null;
            String string5 = null;
            string = CALSTableCellInfoProvider.getAttributeValue(authorElement2, "spanname");
            if (string != null) {
                string4 = string;
            }
            if ((string = CALSTableCellInfoProvider.getAttributeValue(authorElement2, "namest")) != null) {
                string2 = string;
            }
            if ((string = CALSTableCellInfoProvider.getAttributeValue(authorElement2, "nameend")) != null) {
                string5 = string;
            }
            if (string4 == null || string2 == null || string5 == null) continue;
            this.spanspecInfos.add(new CALSColSpanSpec(string4, string2, string5));
        }
    }

    private void reportInvalidFloat(AuthorElement authorElement, AuthorElement authorElement2, String string, String string2) {
        boolean bl = false;
        try {
            NumberParserUtil.parseFloat((String)string);
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        if (!bl && this.errorsListener != null) {
            this.errorsListener.add(authorElement2, authorElement, CALSAndHTMLTableLayoutProblem.COLUMN_WIDTH_VALUE_INCORRECT, string2);
        }
    }

    protected boolean isColspec(AuthorElement authorElement) {
        return "colspec".equalsIgnoreCase(authorElement.getLocalName());
    }

    @Override
    public String getDescription() {
        return "Provides information about the cells for a DocBook or DITA table.";
    }

    private CALSColSpanSpec getSpanSpec(String string) {
        CALSColSpanSpec cALSColSpanSpec = null;
        for (CALSColSpanSpec cALSColSpanSpec2 : this.spanspecInfos) {
            if (!string.equals(cALSColSpanSpec2.getSpanName())) continue;
            cALSColSpanSpec = cALSColSpanSpec2;
            break;
        }
        return cALSColSpanSpec;
    }

    public CALSColSpanSpec getCellSpanSpec(AuthorAccess authorAccess, AuthorElement authorElement) {
        CALSColSpanSpec cALSColSpanSpec = null;
        String string = CALSTableCellInfoProvider.getAttributeValue(authorElement, "spanname");
        if (string != null) {
            cALSColSpanSpec = this.getSpanSpec(string);
        } else {
            String string2 = CALSTableCellInfoProvider.getAttributeValue(authorElement, "namest");
            String string3 = CALSTableCellInfoProvider.getAttributeValue(authorElement, "nameend");
            if (string2 != null && string3 != null) {
                cALSColSpanSpec = new CALSColSpanSpec(null, string2, string3);
            } else {
                CALSColSpec cALSColSpec = this.getColumnSpec(authorAccess, authorElement);
                if (cALSColSpec != null) {
                    cALSColSpanSpec = new CALSColSpanSpec(null, cALSColSpec.getColumnName(), cALSColSpec.getColumnName());
                }
            }
        }
        return cALSColSpanSpec;
    }

    CALSColSpec getColumnSpec(AuthorAccess authorAccess, AuthorElement authorElement) {
        CALSColSpec cALSColSpec = null;
        String string = CALSTableCellInfoProvider.getAttributeValue(authorElement, "colname");
        if (string != null) {
            cALSColSpec = this.getColSpec(string);
            if (this.errorsListener != null && cALSColSpec == null) {
                this.errorsListener.add(authorElement, this.tableElement, CALSAndHTMLTableLayoutProblem.COLUMN_NAME_INCORRECT, string, "colname");
            }
        } else {
            int[] nArray = authorAccess.getTableAccess().getTableCellIndex(authorElement);
            if (nArray != null) {
                cALSColSpec = this.getColSpec(nArray[1] + 1);
            }
        }
        return cALSColSpec;
    }

    private CALSColSpec getColumnSpec(AuthorElement authorElement, int n2) {
        CALSColSpec cALSColSpec = null;
        String string = CALSTableCellInfoProvider.getAttributeValue(authorElement, "colname");
        if (string != null) {
            cALSColSpec = this.getColSpec(string);
            if (this.errorsListener != null && cALSColSpec == null) {
                this.errorsListener.add(authorElement, this.tableElement, CALSAndHTMLTableLayoutProblem.COLUMN_NAME_INCORRECT, string, "colname");
            }
        } else {
            cALSColSpec = this.getColSpec(n2);
        }
        return cALSColSpec;
    }

    public CALSColSpec getColSpec(String string) {
        CALSColSpec cALSColSpec = null;
        Set<CALSColSpec> set = this.colspecInfosMap.keySet();
        for (CALSColSpec cALSColSpec2 : set) {
            if (string == null || !string.equals(cALSColSpec2.getColumnName())) continue;
            cALSColSpec = cALSColSpec2;
            break;
        }
        return cALSColSpec;
    }

    public CALSColSpec getColSpec(int n2) {
        CALSColSpec cALSColSpec = null;
        Set<CALSColSpec> set = this.colspecInfosMap.keySet();
        for (CALSColSpec cALSColSpec2 : set) {
            if (n2 != cALSColSpec2.getColumnNumber()) continue;
            cALSColSpec = cALSColSpec2;
            break;
        }
        return cALSColSpec;
    }

    public AuthorElement getColSpecElement(CALSColSpec cALSColSpec) {
        return this.colspecInfosMap.get(cALSColSpec);
    }

    public Set<CALSColSpec> getColSpecs() {
        return this.colspecInfosMap.keySet();
    }

    @Override
    public boolean hasColumnSpecifications(AuthorElement authorElement) {
        return !this.colspecInfosMap.isEmpty();
    }

    @Override
    public List<WidthRepresentation> getCellWidth(AuthorElement authorElement, int n2, int n3) {
        ArrayList<WidthRepresentation> arrayList;
        block13: {
            Set<CALSColSpec> set;
            block14: {
                Object object;
                arrayList = null;
                String string = CALSTableCellInfoProvider.getAttributeValue(authorElement, "spanname");
                Object object2 = null;
                String string2 = null;
                if (string != null) {
                    object = this.getSpanSpec(string);
                    if (object != null) {
                        object2 = ((CALSColSpanSpec)object).getStartColumnName();
                        string2 = ((CALSColSpanSpec)object).getEndColumnName();
                    }
                } else {
                    object = CALSTableCellInfoProvider.getAttributeValue(authorElement, "namest");
                    set = CALSTableCellInfoProvider.getAttributeValue(authorElement, "nameend");
                    if (object != null && set != null) {
                        object2 = object;
                        string2 = set;
                    }
                }
                if (object2 == null && string2 == null && (string = CALSTableCellInfoProvider.getAttributeValue(authorElement, "colname")) != null) {
                    string2 = string;
                    object2 = string2;
                }
                if (object2 == null || string2 == null) break block14;
                boolean bl = false;
                set = this.colspecInfosMap.keySet();
                for (CALSColSpec cALSColSpec : set) {
                    if (((String)object2).equals(cALSColSpec.getColumnName())) {
                        bl = true;
                    }
                    if (bl) {
                        WidthRepresentation widthRepresentation = cALSColSpec.getColWidth();
                        WidthRepresentation widthRepresentation2 = widthRepresentation = widthRepresentation == null ? DEFAULT_WIDTH_REPRESENTATION : widthRepresentation;
                        if (cALSColSpec.getAlign() != null && widthRepresentation == DEFAULT_WIDTH_REPRESENTATION) {
                            widthRepresentation = new WidthRepresentation(0.0f, null, 1.0f, false){

                                @Override
                                public boolean isSpecified() {
                                    return false;
                                }
                            };
                            widthRepresentation.setAlign(cALSColSpec.getAlign());
                        }
                        if (arrayList == null) {
                            arrayList = new ArrayList();
                        }
                        arrayList.add(widthRepresentation);
                    }
                    if (!string2.equals(cALSColSpec.getColumnName())) continue;
                    break block13;
                }
                break block13;
            }
            if (n2 < 0) break block13;
            int n4 = n2 + 1;
            set = this.colspecInfosMap.keySet();
            for (CALSColSpec cALSColSpec : set) {
                if (cALSColSpec.getColumnNumber() != n4) continue;
                WidthRepresentation widthRepresentation = cALSColSpec.getColWidth();
                WidthRepresentation widthRepresentation3 = widthRepresentation = widthRepresentation == null ? DEFAULT_WIDTH_REPRESENTATION : widthRepresentation;
                if (cALSColSpec.getAlign() != null && widthRepresentation == DEFAULT_WIDTH_REPRESENTATION) {
                    widthRepresentation = new WidthRepresentation(0.0f, null, 1.0f, false){

                        @Override
                        public boolean isSpecified() {
                            return false;
                        }
                    };
                    widthRepresentation.setAlign(cALSColSpec.getAlign());
                }
                if (arrayList == null) {
                    arrayList = new ArrayList<WidthRepresentation>();
                }
                arrayList.add(widthRepresentation);
            }
        }
        return arrayList;
    }

    @Override
    public void commitColumnWidthModifications(AuthorDocumentController authorDocumentController, WidthRepresentation[] widthRepresentationArray, String string) throws AuthorOperationException {
        if (this.isTableCell(string) && widthRepresentationArray != null && authorDocumentController != null && this.tableElement != null) {
            int n2 = this.tableElement.getStartOffset() + 1;
            try {
                for (int i2 = 0; i2 < widthRepresentationArray.length; ++i2) {
                    Object object;
                    String string2;
                    WidthRepresentation widthRepresentation = widthRepresentationArray[i2];
                    int n3 = i2 + 1;
                    CALSColSpec cALSColSpec = this.getColSpec(n3);
                    AuthorElement authorElement = null;
                    if (cALSColSpec == null) {
                        string2 = this.getUniqueColumnName(n3);
                        cALSColSpec = new CALSColSpec(i2, n3, true, string2, widthRepresentation);
                        object = cALSColSpec.createXMLFragment(this.tableElement.getNamespace());
                        authorDocumentController.insertXMLFragment((String)object, n2);
                        authorElement = (AuthorElement)authorDocumentController.getNodeAtOffset(n2 + 1);
                        this.colspecInfosMap.put(cALSColSpec, authorElement);
                    } else {
                        cALSColSpec.setColWidth(widthRepresentation);
                        string2 = widthRepresentation.getWidthRepresentation();
                        object = null;
                        if (string2 != null) {
                            object = new AttrValue(widthRepresentation.getWidthRepresentation());
                        }
                        authorElement = this.colspecInfosMap.get(cALSColSpec);
                        authorDocumentController.setAttribute("colwidth", (AttrValue)object, authorElement);
                    }
                    n2 = authorElement.getEndOffset() + 1;
                }
            }
            catch (AuthorOperationException authorOperationException) {
                throw authorOperationException;
            }
            catch (BadLocationException badLocationException) {
                throw new AuthorOperationException(badLocationException.getMessage(), badLocationException);
            }
        }
    }

    protected boolean isTableCell(String string) {
        return CALS_DOCBOOK_CELL_NAME.equalsIgnoreCase(string);
    }

    private String getUniqueColumnName(int n2) {
        Set<CALSColSpec> set = this.getColSpecs();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CALSColSpec cALSColSpec : set) {
            String string = cALSColSpec.getColumnName();
            if (string == null) continue;
            arrayList.add(string);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(COLSPEC_NAME_PREFIX).append(n2);
        boolean bl = false;
        while (!bl) {
            if (arrayList.contains(stringBuilder.toString())) {
                stringBuilder.append(n2);
                continue;
            }
            bl = true;
        }
        return stringBuilder.toString();
    }

    private AuthorElement getTableElement() {
        AuthorElement authorElement = this.tableElement;
        if (authorElement != null) {
            while (!"table".equalsIgnoreCase(authorElement.getLocalName())) {
                AuthorNode authorNode = authorElement.getParent();
                if (authorNode instanceof AuthorElement) {
                    authorElement = (AuthorElement)authorNode;
                    continue;
                }
                authorElement = null;
                break;
            }
        }
        return authorElement;
    }

    @Override
    public void commitTableWidthModification(AuthorDocumentController authorDocumentController, int n2, String string) throws AuthorOperationException {
        if (this.isTableCell(string)) {
            AuthorElement authorElement = this.getTableElement();
            if (n2 > 0 && authorDocumentController != null) {
                if (authorElement != null) {
                    String string2 = String.valueOf(n2);
                    authorDocumentController.setAttribute("width", new AttrValue(string2), authorElement);
                } else {
                    throw new AuthorOperationException("Cannot find the element representing the table.");
                }
            }
        }
    }

    @Override
    public WidthRepresentation getTableWidth(String string) {
        WidthRepresentation widthRepresentation = null;
        if (this.isTableCell(string)) {
            widthRepresentation = this.getTableWidth();
        }
        return widthRepresentation;
    }

    @Override
    public boolean isTableAcceptingWidth(String string) {
        return false;
    }

    private WidthRepresentation getTableWidth() {
        String string;
        WidthRepresentation widthRepresentation = null;
        AuthorElement authorElement = this.getTableElement();
        if (authorElement != null && (string = CALSTableCellInfoProvider.getAttributeValue(authorElement, "width")) != null) {
            widthRepresentation = new WidthRepresentation(string, true);
        }
        return widthRepresentation;
    }

    @Override
    public boolean isTableAndColumnsResizable(String string) {
        return this.isTableCell(string);
    }

    @Override
    public boolean isAcceptingFixedColumnWidths(String string) {
        return this.isTableCell(string);
    }

    @Override
    public boolean isAcceptingPercentageColumnWidths(String string) {
        return false;
    }

    @Override
    public boolean isAcceptingProportionalColumnWidths(String string) {
        return this.isTableCell(string);
    }

    @Override
    public List<WidthRepresentation> getAllColspecWidthRepresentations() {
        Object object;
        ArrayList<WidthRepresentation> arrayList = new ArrayList<WidthRepresentation>();
        for (CALSColSpec object22 : this.colspecInfosMap.keySet()) {
            object = object22.getColWidth();
            if (object != null) {
                arrayList.add((WidthRepresentation)object);
                continue;
            }
            arrayList.add(new WidthRepresentation(0.0f, null, 1.0f, false));
        }
        AuthorElement authorElement = this.getTableElement();
        if (authorElement != null && (object = CALSTableCellInfoProvider.getAttributeValue(authorElement, "colnum")) != null) {
            try {
                int numberFormatException = NumberParserUtil.parseInt((String)object);
                int n2 = numberFormatException - arrayList.size();
                if (n2 > 0) {
                    for (int i2 = 0; i2 < n2; ++i2) {
                        arrayList.add(new WidthRepresentation(0.0f, null, 1.0f, false));
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    @Override
    public boolean getColSep(AuthorElement authorElement, int n2) {
        CALSColSpec cALSColSpec;
        Boolean[] booleanArray = this.getColSepOrRowSepFromAttributes(authorElement, true);
        Boolean bl = booleanArray[0];
        Boolean bl2 = booleanArray[1];
        if ((bl == null || bl2.booleanValue()) && (cALSColSpec = this.getColumnSpec(authorElement, n2)) != null && cALSColSpec.getColSep() != null) {
            bl = cALSColSpec.getColSep();
        }
        if (bl == null) {
            bl = this.colsepAndRowSepAreVisibleByDefault;
        }
        return bl;
    }

    @Override
    public boolean getRowSep(AuthorElement authorElement, int n2) {
        CALSColSpec cALSColSpec;
        Boolean[] booleanArray = this.getColSepOrRowSepFromAttributes(authorElement, false);
        Boolean bl = booleanArray[0];
        Boolean bl2 = booleanArray[1];
        if ((bl == null || bl2.booleanValue()) && (cALSColSpec = this.getColumnSpec(authorElement, n2)) != null && cALSColSpec.getRowSep() != null) {
            bl = cALSColSpec.getRowSep();
        }
        if (bl == null) {
            bl = this.colsepAndRowSepAreVisibleByDefault;
        }
        return bl;
    }

    private Boolean[] getColSepOrRowSepFromAttributes(AuthorElement authorElement, boolean bl) {
        Boolean bl2 = null;
        boolean bl3 = false;
        AuthorNode authorNode = authorElement;
        while (authorNode instanceof AuthorElement) {
            AuthorElement authorElement2 = authorNode;
            boolean bl4 = this.isTableElement(authorElement2);
            boolean bl5 = this.isTgroupElement(authorElement2);
            String string = bl ? CALSTableCellInfoProvider.getAttributeValue(authorElement2, "colsep") : CALSTableCellInfoProvider.getAttributeValue(authorElement2, "rowsep");
            if (string != null) {
                bl2 = "1".equals(string);
                bl3 = bl4 || bl5;
                break;
            }
            if (bl4) break;
            authorNode = authorNode.getParent();
        }
        return new Boolean[]{bl2, bl3};
    }

    protected boolean isTableElement(AuthorElement authorElement) {
        return authorElement == this.tableElement.getParent() || "table".equalsIgnoreCase(authorElement.getLocalName());
    }

    protected boolean isTgroupElement(AuthorElement authorElement) {
        return "tgroup".equalsIgnoreCase(authorElement.getLocalName());
    }

    private static String getAttributeValue(AuthorElement authorElement, String string) {
        String string2 = null;
        AttrValue attrValue = authorElement.getAttribute(string);
        if (attrValue != null) {
            string2 = attrValue.getValue();
        } else {
            attrValue = authorElement.getAttribute(string.toUpperCase());
            if (attrValue != null) {
                string2 = attrValue.getValue();
            }
        }
        return string2;
    }

    private static class ColspecComparator
    implements Comparator {
        private ColspecComparator() {
        }

        public int compare(Object object, Object object2) {
            int n2 = -1;
            if (object instanceof CALSColSpec && object2 instanceof CALSColSpec) {
                CALSColSpec cALSColSpec = (CALSColSpec)object;
                CALSColSpec cALSColSpec2 = (CALSColSpec)object2;
                n2 = cALSColSpec.getColumnNumber() - cALSColSpec2.getColumnNumber();
            }
            return n2;
        }
    }
}

