/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import java.io.Serializable;
import java.util.Map;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.TypedMaps;
import ro.sync.ecss.extensions.commons.table.operations.TableCustomizerConstants;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class TableInfo
implements Serializable {
    private static final long serialVersionUID = 616939850L;
    private final String title;
    private final int rowsNumber;
    private final int columnsNumber;
    private final boolean generateHeader;
    private final boolean generateFooter;
    private final String frame;
    private final String rowsep;
    private final String colsep;
    private final String align;
    private final int tableModel;
    public static final int TABLE_MODEL_NONE = -1;
    public static final int TABLE_MODEL_HTML = 0;
    public static final int TABLE_MODEL_CALS = 1;
    public static final int TABLE_MODEL_CUSTOM = 2;
    public static final int TABLE_MODEL_DITA_SIMPLE = 3;
    public static final int TABLE_MODEL_DITA_CHOICE = 4;
    public static final int TABLE_MODEL_DITA_PROPERTIES = 5;
    private final TableCustomizerConstants.ColumnWidthsType columnsWidthsType;
    public static final int MIN_ROWS_COUNT = 1;
    public static final int DEFAULT_ROWS_COUNT = 3;
    public static final int DEFAULT_COLUMNS_COUNT_CHOICE_TABLE = 2;
    public static final int DEFAULT_COLUMNS_COUNT = 2;
    public static final int DEFAULT_COLUMNS_COUNT_PROPERTIES_TABLE = 3;
    public static final int MIN_COLUMNS_COUNT = 1;
    public static final int MIN_COLUMNS_COUNT_PROPERTIES_TABLE = 2;
    public static final int MAX_COLUMNS_COUNT = 100;
    public static final int MAX_COLUMNS_COUNT_PROPERTIES_TABLE = 3;

    public TableInfo(String string, int n2, int n3, boolean bl, boolean bl2, String string2, int n4) {
        this(string, n2, n3, bl, bl2, string2, n4, null, null, null, null);
    }

    public TableInfo(String string, int n2, int n3, boolean bl, boolean bl2, String string2, int n4, TableCustomizerConstants.ColumnWidthsType columnWidthsType, String string3, String string4, String string5) {
        this.title = string;
        this.rowsNumber = n2;
        this.columnsNumber = n3;
        this.generateHeader = bl;
        this.generateFooter = bl2;
        this.frame = string2;
        this.tableModel = n4;
        this.columnsWidthsType = columnWidthsType;
        this.rowsep = string3;
        this.colsep = string4;
        this.align = string5;
    }

    public TableInfo(Map<String, Object> map, int n2) {
        this.title = TypedMaps.getString(map, (Object)"title", (String)"");
        this.rowsNumber = n2 > 0 ? n2 : TypedMaps.getInt(map, (Object)"rowsNumber", (int)3);
        this.columnsNumber = TypedMaps.getInt(map, (Object)"columnsNumber", (int)2);
        this.generateHeader = TypedMaps.getBoolean(map, (Object)"generateHeader", (boolean)true);
        this.generateFooter = TypedMaps.getBoolean(map, (Object)"generateFooter", (boolean)false);
        this.frame = TypedMaps.getString(map, (Object)"frame", null);
        this.tableModel = TypedMaps.getInt(map, (Object)"tableModel", (int)2);
        this.columnsWidthsType = TableCustomizerConstants.ColumnWidthsType.valueOf(TypedMaps.getString(map, (Object)"columnsWidthsType", null));
        this.rowsep = TypedMaps.getString(map, (Object)"rowsep", null);
        this.colsep = TypedMaps.getString(map, (Object)"colsep", null);
        this.align = TypedMaps.getString(map, (Object)"align", null);
    }

    @Deprecated
    public TableInfo(Map<String, Object> map) {
        this(map, 0);
    }

    public String getTitle() {
        return this.title;
    }

    public int getRowsNumber() {
        return this.rowsNumber;
    }

    public int getColumnsNumber() {
        return this.columnsNumber;
    }

    public boolean isGenerateHeader() {
        return this.generateHeader;
    }

    public boolean isGenerateFooter() {
        return this.generateFooter;
    }

    public String getFrame() {
        return this.frame;
    }

    public String getRowsep() {
        return this.rowsep;
    }

    public String getColsep() {
        return this.colsep;
    }

    public String getAlign() {
        return this.align;
    }

    public int getTableModel() {
        return this.tableModel;
    }

    public TableCustomizerConstants.ColumnWidthsType getColumnsWidthsType() {
        return this.columnsWidthsType;
    }

    public String toString() {
        return "title: " + this.title + ", rows: " + this.rowsNumber + ", cols: " + this.columnsNumber + ", generateHeader: " + this.generateHeader + ", generateFooter: " + this.generateFooter + ", frame" + this.frame + ", rowsep: " + this.rowsep + ", colsep: " + this.colsep + ", align: " + this.align + ", tableModel: " + this.tableModel;
    }
}

