/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.AbstractDocumentTypeHelper;
import ro.sync.ecss.extensions.commons.operations.CommonsOperationsUtil;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;
import ro.sync.exml.workspace.api.Platform;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class AbstractTableOperation
implements AuthorOperation {
    static final String CHANGE_TRACKING_BEHAVIOR = "changeTrackingBehavior";
    static final String CHANGE_TRACKING_BEHAVIOR_BLOCK = "Block";
    static final String CHANGE_TRACKING_BEHAVIOR_ALLOW = "Allow";
    static final String CHANGE_TRACKING_BEHAVIOR_ALLOW_WITHOUT = "Allow with change tracking disabled";
    static final String CHANGE_TRACKING_BEHAVIOR_AUTO = "Auto";
    public static final ArgumentDescriptor CHANGE_TRACKING_BEHAVIOR_ARGUMENT = new ArgumentDescriptor("changeTrackingBehavior", 3, "Configures the operation behavior when change tracking is activated. Can be one of:\n - Block: The operation is not performed when change tracking is activated.\n - Allow: The operation is performed when change tracking is activated. If complex\n     table operations are performed, the resulting table layout may become broken.\n - Allow with change tracking disabled: The operation is performed with change tracking disabled.\n - Auto: Let the application decide which strategy to use, possibly by asking the end user.", new String[]{"Allow", "Allow with change tracking disabled", "Block", "Auto"}, "Auto");
    public static final String TABLE_INFO_ARGUMENT_NAME = "table_info";
    public static final ArgumentDescriptor TABLE_INFO_ARGUMENT_DESCRIPTOR = new ArgumentDescriptor("table_info", 5, "Details of the table that will be inserted in the document. The value of the argument should be a Java Map<String, Object> with keys corresponding to TableInfo fields.If a null value is passed in, the table customized dialog will be shown.");
    protected AuthorTableHelper tableHelper;
    private boolean supportsChangeTracking = false;

    public AbstractTableOperation(AuthorTableHelper authorTableHelper) {
        this(authorTableHelper, false);
    }

    public AbstractTableOperation(AuthorTableHelper authorTableHelper, boolean bl) {
        this.tableHelper = authorTableHelper;
        this.supportsChangeTracking = bl;
    }

    protected AuthorElement getElementAncestor(AuthorNode authorNode, int n2) {
        AuthorNode authorNode2 = null;
        while (authorNode instanceof AuthorElement) {
            if (this.isTableElement(authorNode, n2)) {
                authorNode2 = (AuthorElement)authorNode;
                break;
            }
            authorNode = authorNode.getParent();
        }
        if (authorNode2 != null && authorNode2.getParent() != null && authorNode2.getParent().getType() == 7) {
            AuthorNode authorNode3 = authorNode2.getParent().getParent();
            if (this.tableHelper instanceof AbstractDocumentTypeHelper && ((AbstractDocumentTypeHelper)this.tableHelper).isContentReference(authorNode3)) {
                authorNode2 = this.getElementAncestor(authorNode2.getParent(), n2);
            }
        }
        return authorNode2;
    }

    protected boolean isElement(AuthorNode authorNode, String string) {
        return authorNode instanceof AuthorElement && string.equals(((AuthorElement)authorNode).getLocalName());
    }

    protected boolean isTableElement(AuthorNode authorNode, int n2) {
        boolean bl = false;
        switch (n2) {
            case 0: {
                bl = this.tableHelper.isTableCell(authorNode);
                break;
            }
            case 1: {
                bl = this.tableHelper.isTableRow(authorNode);
                break;
            }
            case 2: {
                bl = this.tableHelper.isTable(authorNode);
            }
        }
        return bl;
    }

    protected int findCellInsertionOffset(AuthorAccess authorAccess, AuthorElement authorElement, int n2, int n3) {
        int n4 = -1;
        AuthorElement authorElement2 = authorAccess.getTableAccess().getTableRow(n2, authorElement);
        if (authorElement2 != null) {
            AuthorElement authorElement3;
            n4 = n3 == 0 ? authorElement2.getStartOffset() + 1 : ((authorElement3 = this.findPreviousCellInRow(authorAccess, n3, authorElement2)) != null ? authorElement3.getEndOffset() + 1 : authorElement2.getStartOffset() + 1);
        }
        return n4;
    }

    private AuthorElement findPreviousCellInRow(AuthorAccess authorAccess, int n2, AuthorElement authorElement) {
        AuthorElement authorElement2 = null;
        for (AuthorNode authorNode : authorElement.getContentNodes()) {
            int[] nArray;
            if (!this.tableHelper.isTableCell(authorNode) || (nArray = authorAccess.getTableAccess().getTableCellIndex((AuthorElement)authorNode)) == null) continue;
            if (nArray[1] >= n2) break;
            authorElement2 = (AuthorElement)authorNode;
        }
        return authorElement2;
    }

    protected AuthorDocumentFragment createEmptyCell(AuthorAccess authorAccess, AuthorElement authorElement, String[] stringArray) throws BadLocationException {
        AuthorDocumentFragment authorDocumentFragment = null;
        AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
        authorDocumentFragment = authorDocumentController.createDocumentFragment(authorElement, false);
        CommonsOperationsUtil.removeUnwantedAttributes(stringArray, authorDocumentFragment, authorDocumentController);
        return authorDocumentFragment;
    }

    @Override
    public final void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        if (!this.supportsChangeTracking && authorAccess.getReviewController().isTrackingChanges()) {
            String string = AbstractTableOperation.getChangeTrackingBehavior(authorAccess, argumentsMap);
            if (CHANGE_TRACKING_BEHAVIOR_ALLOW.equals(string)) {
                this.doOperationInternal(authorAccess, argumentsMap);
            } else if (CHANGE_TRACKING_BEHAVIOR_ALLOW_WITHOUT.equals(string)) {
                this.doOperationWithoutChangeTracking(authorAccess, argumentsMap);
            } else if (CHANGE_TRACKING_BEHAVIOR_BLOCK.equals(string)) {
                authorAccess.getWorkspaceAccess().showErrorMessage(authorAccess.getAuthorResourceBundle().getMessage("Table_operation_when_tc_error_message"));
            }
        } else {
            this.doOperationInternal(authorAccess, argumentsMap);
        }
    }

    private static String getChangeTrackingBehavior(AuthorAccess authorAccess, ArgumentsMap argumentsMap) {
        String string = (String)argumentsMap.getArgumentValue(CHANGE_TRACKING_BEHAVIOR);
        if (string == null) {
            string = CHANGE_TRACKING_BEHAVIOR_AUTO;
        }
        if (CHANGE_TRACKING_BEHAVIOR_AUTO.equals(string)) {
            int n2;
            string = authorAccess.getWorkspaceAccess().getPlatform() == Platform.WEBAPP ? CHANGE_TRACKING_BEHAVIOR_BLOCK : ((n2 = authorAccess.getWorkspaceAccess().showConfirmDialog(authorAccess.getAuthorResourceBundle().getMessage("Track_changes"), authorAccess.getAuthorResourceBundle().getMessage("Action_not_marked_as_change"), new String[]{"OK", authorAccess.getAuthorResourceBundle().getMessage("cancel")}, new int[]{1, 0})) == 1 ? CHANGE_TRACKING_BEHAVIOR_ALLOW_WITHOUT : CHANGE_TRACKING_BEHAVIOR_BLOCK);
        }
        return string;
    }

    private void doOperationWithoutChangeTracking(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        authorAccess.getReviewController().toggleTrackChanges();
        try {
            this.doOperationInternal(authorAccess, argumentsMap);
        }
        finally {
            if (!authorAccess.getReviewController().isTrackingChanges()) {
                authorAccess.getReviewController().toggleTrackChanges();
            }
        }
    }

    protected abstract void doOperationInternal(AuthorAccess var1, ArgumentsMap var2) throws AuthorOperationException;
}

