/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations.text;

import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.css.Styles;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.content.OffsetInformation;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;
import ro.sync.ecss.extensions.commons.operations.text.FormSelectedTextOperation;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
@WebappRestSafe
public class CapitalizeWordsOperation
extends FormSelectedTextOperation {
    @Override
    protected boolean isDelimiterBeforeTextNode(AuthorAccess authorAccess, int n2) throws BadLocationException, AuthorOperationException {
        AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
        boolean bl = false;
        CharSequence charSequence = authorDocumentController.getContentCharSequence();
        --n2;
        while (n2 >= 1) {
            char c2 = charSequence.charAt(n2);
            if (c2 == '\u0000') {
                OffsetInformation offsetInformation = authorDocumentController.getContentInformationAtOffset(n2);
                AuthorNode authorNode = offsetInformation.getNodeForMarkerOffset();
                Styles styles = authorAccess.getEditorAccess().getStyles(authorNode);
                if (!styles.isInline()) {
                    bl = true;
                    break;
                }
            } else {
                if (!this.isWordDelimiter(c2)) break;
                bl = true;
                break;
            }
            --n2;
        }
        return bl;
    }

    @Override
    protected char[] processTextContent(char[] cArray, boolean bl) {
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            char c2 = cArray[i2];
            if (this.isWordDelimiter(c2)) {
                bl = true;
                continue;
            }
            if (bl) {
                cArray[i2] = Character.toUpperCase(c2);
            }
            bl = false;
        }
        return cArray;
    }

    @Override
    public String getDescription() {
        return "Capitalize the first letter of each word in the current selection.";
    }
}

