/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.contentcompletion.xml.ContextElement;
import ro.sync.contentcompletion.xml.WhatElementsCanGoHereContext;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorOperationStoppedByUserException;
import ro.sync.ecss.extensions.api.AuthorSchemaManager;
import ro.sync.ecss.extensions.api.AuthorSelectionModel;
import ro.sync.ecss.extensions.api.ContentInterval;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.content.OffsetInformation;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.AuthorNodeUtil;
import ro.sync.ecss.extensions.api.node.AuthorParentNode;
import ro.sync.ecss.extensions.commons.operations.CommonsOperationsUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class ToggleSurroundWithElementOperation
implements AuthorOperation {
    private static final Logger logger = LoggerFactory.getLogger((String)ToggleSurroundWithElementOperation.class.getName());
    public static final String ARGUMENT_ELEMENT = "element";
    private static final ArgumentDescriptor[] ARGUMENTS = new ArgumentDescriptor[]{new ArgumentDescriptor("element", 1, "The element to surround with."), new ArgumentDescriptor("schemaAware", 3, "This argument applies only on the surround with element operation and controls if the insertion is schema aware or not. When schema aware is enabled and the element insertion is not allowed, a dialog will be shown proposing insertion solutions, like:\n - splitting an ancestor of the node at insertion offset and inserting the element between the resulted elements;\n - inserting the element somewhere in the proximity of the insertion offset (left or right without skipping content);\n - inserting the element at insertion offset, even it is not allowed.\n\nNote: if a selection exists the surround with element operation is not schema aware.\nPossible values are: true, false. Default value is true.", new String[]{"true", "false"}, "true")};

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        Object object = argumentsMap.getArgumentValue(ARGUMENT_ELEMENT);
        Object object2 = argumentsMap.getArgumentValue("schemaAware");
        if (object != null && object instanceof String && ((String)object).length() > 0) {
            String string = (String)object;
            AuthorElement authorElement = this.getElementFromFragment(string, authorAccess);
            boolean bl = !"false".equals(object2);
            authorAccess.getDocumentController().beginCompoundEdit();
            try {
                boolean bl2;
                if (authorAccess.getEditorAccess().hasSelection()) {
                    this.performToggleSelection(authorAccess, string, authorElement, bl);
                }
                int[] nArray = authorAccess.getEditorAccess().getWordAtCaret();
                int n2 = authorAccess.getEditorAccess().getCaretOffset();
                AuthorElement authorElement2 = this.getElementAtCaretOffset(authorAccess);
                AuthorElement authorElement3 = this.getElementMatchingReferenceElement(authorElement2, authorAccess, authorElement, true);
                boolean bl3 = bl2 = nArray != null && nArray[0] != n2 && nArray[1] != n2;
                if (authorElement3 != null) {
                    int n3 = 0;
                    if (bl2) {
                        OffsetInformation offsetInformation;
                        int[] nArray2 = this.unwrap(authorElement3, nArray[0], nArray[1] - 1, authorAccess);
                        int n4 = 0;
                        for (int i2 = nArray2[0]; i2 < nArray2[1] && (offsetInformation = authorAccess.getDocumentController().getContentInformationAtOffset(i2)).getPositionType() == 1; ++i2) {
                            ++n4;
                        }
                        n3 = n2 + n4 - (nArray[0] - nArray2[0]);
                    } else {
                        n3 = this.unwrap(authorElement3, n2, n2 - 1, authorAccess)[0];
                    }
                    authorAccess.getEditorAccess().setCaretPosition(n3);
                }
                if (bl2) {
                    CommonsOperationsUtil.surroundWithFragment(authorAccess, string, nArray[0], nArray[1] - 1);
                    authorAccess.getEditorAccess().setCaretPosition(n2 + 1);
                }
                CommonsOperationsUtil.surroundWithFragment(authorAccess, bl, string);
            }
            catch (AuthorOperationStoppedByUserException authorOperationStoppedByUserException) {
                authorAccess.getDocumentController().cancelCompoundEdit();
            }
            catch (AuthorOperationException authorOperationException) {
                authorAccess.getDocumentController().cancelCompoundEdit();
                throw authorOperationException;
            }
            catch (Exception exception) {
                logger.error((Object)exception, (Throwable)exception);
                authorAccess.getDocumentController().cancelCompoundEdit();
                throw new AuthorOperationException("The operation could not be executed.", exception);
            }
            finally {
                authorAccess.getDocumentController().endCompoundEdit();
            }
        } else {
            throw new IllegalArgumentException("The value of the 'element' argument was not specified.");
        }
    }

    private List<int[]> getSelectedIntervals(AuthorAccess authorAccess) {
        AuthorSelectionModel authorSelectionModel = authorAccess.getEditorAccess().getAuthorSelectionModel();
        List<ContentInterval> list = authorSelectionModel.getSelectionIntervals();
        ArrayList<int[]> arrayList = new ArrayList<int[]>(list.size());
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ContentInterval contentInterval = list.get(i2);
            int[] nArray = authorAccess.getEditorAccess().getBalancedSelection(contentInterval.getStartOffset(), contentInterval.getEndOffset());
            arrayList.add(new int[]{nArray[0], nArray[1] - 1});
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performToggleSelection(AuthorAccess authorAccess, String string, AuthorElement authorElement, boolean bl) throws AuthorOperationException, BadLocationException {
        Object object;
        Object object2;
        boolean bl2 = authorAccess.getEditorAccess().getCaretOffset() == authorAccess.getEditorAccess().getSelectionStart();
        ArrayList<IntervalAndAction> arrayList = new ArrayList<IntervalAndAction>();
        AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
        AuthorDocumentFragment authorDocumentFragment = authorDocumentController.createNewDocumentFragmentInContext(string, authorAccess.getEditorAccess().getCaretOffset());
        List<int[]> list = this.getSelectedIntervals(authorAccess);
        Object object3 = list.iterator();
        while (object3.hasNext()) {
            this.collectToggleIntervals(authorAccess, arrayList, authorDocumentController, authorElement, authorDocumentFragment, object3.next(), true, bl);
        }
        this.sortAscending(arrayList);
        object3 = null;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object2 = (IntervalAndAction)iterator.next();
            object = ((IntervalAndAction)object2).interval;
            if (object3 != null && ((IntervalAndAction)object3).interval[1] + 1 == object[0] && ((IntervalAndAction)object3).action == ((IntervalAndAction)object2).action) {
                ((IntervalAndAction)object3).interval[1] = object[1];
                ((IntervalAndAction)object3).entireIntervalWrapped = ((IntervalAndAction)object3).entireIntervalWrapped && ((IntervalAndAction)object2).entireIntervalWrapped;
                iterator.remove();
                continue;
            }
            object3 = object2;
        }
        if (!arrayList.isEmpty()) {
            boolean bl3 = this.isAllWrapped(arrayList);
            object2 = null;
            authorAccess.getDocumentController().disableLayoutUpdate();
            try {
                Object object4;
                int n2;
                int n3;
                Object object5;
                Object object6;
                int n4;
                object = authorAccess.getDocumentController();
                boolean bl4 = false;
                if (logger.isDebugEnabled()) {
                    logger.debug("All intervals are fully wrapped: " + bl3);
                }
                ArrayList<Position[]> arrayList2 = new ArrayList<Position[]>(arrayList.size());
                ArrayList<Integer> arrayList3 = new ArrayList<Integer>(arrayList.size());
                int n5 = arrayList.size();
                for (n4 = arrayList.size() - 1; n4 >= 0; --n4) {
                    IntervalAndAction intervalAndAction = (IntervalAndAction)arrayList.get(n4);
                    object5 = object6 = intervalAndAction.interval;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Process interval: " + intervalAndAction.action);
                        logger.debug("         Content: '" + authorDocumentController.serializeFragmentToXML(authorDocumentController.createDocumentFragment(object6[0], object6[1])) + "'");
                    }
                    n3 = intervalAndAction.action;
                    if (intervalAndAction.action == 0) {
                        int n6 = object6[0];
                        n2 = object6[1];
                        if (!intervalAndAction.entireIntervalWrapped || bl3) {
                            object4 = this.unwrapElementsMatchingReferenceElement(n6, n2, authorElement, authorAccess);
                            bl4 = bl4 || ((UnwrapResult)object4).performSurround;
                            object5 = ((UnwrapResult)object4).intervalToSurround;
                        } else {
                            n3 = 4;
                        }
                    } else {
                        bl4 = true;
                    }
                    arrayList2.add(new Position[]{object.createPositionInContent(object5[0]), object.createPositionInContent(object5[1])});
                    if (logger.isDebugEnabled()) {
                        logger.debug("Before " + object6[0] + ", " + object6[1] + " => " + (int)object5[0] + ", " + (int)object5[1]);
                    }
                    arrayList3.add(n3);
                }
                n4 = ((Position[])arrayList2.get(0))[1].getOffset();
                int n7 = ((Position[])arrayList2.get(arrayList.size() - 1))[0].getOffset();
                object2 = authorAccess.getDocumentController().getCommonParentNode(authorAccess.getDocumentController().getAuthorDocumentNode(), n7, n4);
                object6 = null;
                object5 = authorAccess.getEditorAccess().getAuthorSelectionModel();
                if (bl4) {
                    n5 = arrayList2.size();
                    if (n5 > 1) {
                        object6 = new ArrayList(arrayList2.size());
                    }
                    for (n3 = n5 - 1; n3 >= 0; --n3) {
                        Position[] positionArray = (Position[])arrayList2.get(n3);
                        Integer n8 = (Integer)arrayList3.get(n3);
                        if (n8 == 0) {
                            object4 = authorDocumentController.createNewDocumentFragmentInContext(string, positionArray[0].getOffset());
                            authorAccess.getDocumentController().surroundInFragment((AuthorDocumentFragment)object4, positionArray[0].getOffset(), positionArray[1].getOffset());
                        } else if (n8 == 2) {
                            authorAccess.getDocumentController().insertFragment(positionArray[0].getOffset(), authorDocumentFragment);
                        }
                        if (object6 == null) continue;
                        if (n8 == 4) {
                            object6.add(new ContentInterval(positionArray[0].getOffset(), positionArray[1].getOffset() + 1));
                            continue;
                        }
                        object6.add(object5.getSelectionInterval());
                    }
                } else {
                    object6 = new ArrayList(arrayList2.size());
                    for (n3 = arrayList2.size() - 1; n3 >= 0; --n3) {
                        Position[] positionArray = (Position[])arrayList2.get(n3);
                        n2 = !bl2 ? positionArray[0].getOffset() : positionArray[1].getOffset() + 1;
                        int n9 = !bl2 ? positionArray[1].getOffset() + 1 : positionArray[0].getOffset();
                        object6.add(new ContentInterval(n2, n9));
                    }
                }
                object5.setSelectionIntervals((List<ContentInterval>)object6, true);
            }
            finally {
                authorAccess.getDocumentController().enableLayoutUpdate((AuthorNode)object2);
            }
        }
    }

    private boolean isAllWrapped(List<IntervalAndAction> list) {
        boolean bl = true;
        for (IntervalAndAction intervalAndAction : list) {
            if (intervalAndAction.entireIntervalWrapped) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private void sortAscending(List<IntervalAndAction> list) {
        Collections.sort(list, new Comparator<IntervalAndAction>(){

            @Override
            public int compare(IntervalAndAction intervalAndAction, IntervalAndAction intervalAndAction2) {
                return intervalAndAction.interval[0] - intervalAndAction2.interval[0];
            }
        });
    }

    private void collectToggleIntervals(AuthorAccess authorAccess, List<IntervalAndAction> list, AuthorDocumentController authorDocumentController, AuthorElement authorElement, AuthorDocumentFragment authorDocumentFragment, int[] nArray, boolean bl, boolean bl2) throws BadLocationException {
        block20: {
            block22: {
                block23: {
                    AuthorSchemaManager authorSchemaManager;
                    block21: {
                        block19: {
                            IntervalAndAction intervalAndAction = new IntervalAndAction(nArray, 0);
                            if (bl2) {
                                intervalAndAction = this.canToggleSchemaAware(authorAccess, nArray[0], nArray[1], authorElement, authorDocumentFragment);
                            }
                            if (logger.isDebugEnabled()) {
                                logger.debug("Tested '" + authorDocumentController.serializeFragmentToXML(authorDocumentController.createDocumentFragment(nArray[0], nArray[1])) + "' - action: " + intervalAndAction);
                            }
                            if (intervalAndAction.action == 3) break block19;
                            list.add(intervalAndAction);
                            break block20;
                        }
                        if (!bl) break block21;
                        List<int[]> list2 = ToggleSurroundWithElementOperation.getEquiIntervalFromMarker(authorAccess, nArray);
                        for (int[] nArray2 : list2) {
                            this.collectToggleIntervals(authorAccess, list, authorDocumentController, authorElement, authorDocumentFragment, nArray2, false, bl2);
                        }
                        break block20;
                    }
                    AuthorNode authorNode = authorAccess.getEditorAccess().getFullySelectedNode(nArray[0], nArray[1] + 1);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Go deep |" + authorDocumentController.serializeFragmentToXML(authorDocumentController.createDocumentFragment(nArray[0], nArray[1])) + "| fully " + (authorNode != null));
                    }
                    if (authorNode == null) break block22;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Fully selected node " + authorNode);
                    }
                    if (nArray[0] + 1 != nArray[1]) break block23;
                    boolean bl3 = true;
                    if (bl2 && (authorSchemaManager = authorAccess.getDocumentController().getAuthorSchemaManager()) != null && !authorSchemaManager.hasLoadingErrors() && !authorSchemaManager.isLearnSchema()) {
                        bl3 = authorSchemaManager.canInsertDocumentFragment(authorDocumentFragment, nArray[0] + 1, (short)1);
                    }
                    if (!bl3) break block20;
                    list.add(new IntervalAndAction(new int[]{nArray[0] + 1, nArray[1]}, 2));
                    break block20;
                }
                this.collectToggleIntervals(authorAccess, list, authorDocumentController, authorElement, authorDocumentFragment, new int[]{nArray[0] + 1, nArray[1] - 1}, false, bl2);
                break block20;
            }
            AuthorNode authorNode = authorAccess.getDocumentController().getCommonParentNode(authorAccess.getDocumentController().getAuthorDocumentNode(), nArray[0], nArray[1]);
            if (logger.isDebugEnabled()) {
                logger.debug("Common " + authorNode);
            }
            if (authorNode instanceof AuthorParentNode) {
                List<AuthorNode> list3 = ((AuthorParentNode)authorNode).getContentNodes();
                ArrayList<int[]> arrayList = new ArrayList<int[]>();
                int n2 = nArray[0];
                int n3 = nArray[1];
                if (logger.isDebugEnabled()) {
                    logger.debug("Interval " + n2 + ", " + n3);
                }
                for (AuthorNode authorNode2 : list3) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Child " + authorNode2);
                    }
                    if (authorNode2.getStartOffset() >= n2 && authorNode2.getEndOffset() <= n3) {
                        if (n2 < authorNode2.getStartOffset()) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Add interval " + n2 + ",  " + (authorNode2.getStartOffset() - 1));
                            }
                            arrayList.add(new int[]{n2, authorNode2.getStartOffset() - 1});
                        }
                        arrayList.add(new int[]{authorNode2.getStartOffset(), authorNode2.getEndOffset()});
                        if (logger.isDebugEnabled()) {
                            logger.debug("Addd interval" + authorNode2.getStartOffset() + ", " + authorNode2.getEndOffset());
                        }
                        n2 = authorNode2.getEndOffset() + 1;
                        continue;
                    }
                    if (authorNode2.getStartOffset() <= n3) continue;
                    break;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("At end " + n2 + ", " + n3);
                }
                if (n2 <= n3) {
                    arrayList.add(new int[]{n2, n3});
                }
                if (arrayList.size() > 1) {
                    for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                        this.collectToggleIntervals(authorAccess, list, authorDocumentController, authorElement, authorDocumentFragment, (int[])arrayList.get(i2), false, bl2);
                    }
                }
            }
        }
    }

    private int[] extendSelectionOverSentinels(int n2, int n3, int n4, int n5, AuthorAccess authorAccess) throws BadLocationException {
        AuthorNode authorNode = authorAccess.getDocumentController().getCommonParentNode(authorAccess.getDocumentController().getAuthorDocumentNode(), n2, n3);
        if (authorNode != null) {
            boolean bl = false;
            if (authorNode.getStartOffset() == n2 - 1 && n2 - 1 >= n4) {
                --n2;
                bl = true;
            }
            if (authorNode.getEndOffset() == n3 + 1 && n3 + 1 <= n5) {
                ++n3;
                bl = true;
            }
            if (bl) {
                return this.extendSelectionOverSentinels(n2, n3, n4, n5, authorAccess);
            }
        }
        return new int[]{n2, n3};
    }

    private AuthorElement getElementAtCaretOffset(AuthorAccess authorAccess) throws AuthorOperationException {
        AuthorNode authorNode = null;
        try {
        }
        catch (BadLocationException badLocationException) {
            logger.error((Object)badLocationException, (Throwable)badLocationException);
            throw new AuthorOperationException("Cannot identify the current element", badLocationException);
        }
        for (authorNode = authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset()); authorNode != null && !(authorNode instanceof AuthorElement); authorNode = authorNode.getParent()) {
        }
        if (!(authorNode instanceof AuthorElement)) {
            throw new AuthorOperationException("The carret is not inside an element.");
        }
        AuthorElement authorElement = (AuthorElement)authorNode;
        return authorElement;
    }

    private AuthorElement getElementMatchingReferenceElement(AuthorElement authorElement, AuthorAccess authorAccess, AuthorElement authorElement2, boolean bl) {
        AuthorNode authorNode;
        AuthorElement authorElement3 = null;
        if (this.elementMatchesReferenceElement(authorElement, authorElement2)) {
            authorElement3 = authorElement;
        }
        AuthorElement authorElement4 = authorAccess.getDocumentController().getAuthorDocumentNode().getRootElement();
        while ((authorElement3 == null || bl) && (authorNode = authorElement.getParent()) instanceof AuthorElement && authorNode != authorElement4) {
            authorElement = (AuthorElement)authorNode;
            if (!this.elementMatchesReferenceElement(authorElement, authorElement2)) continue;
            authorElement3 = authorElement;
        }
        return authorElement3;
    }

    private boolean elementMatchesReferenceElement(AuthorElement authorElement, AuthorElement authorElement2) {
        boolean bl = true;
        if (authorElement.getName().equals(authorElement2.getName())) {
            if (authorElement.getNamespace().equals(authorElement2.getNamespace())) {
                int n2 = authorElement2.getAttributesCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    String string = authorElement2.getAttributeAtIndex(i2);
                    if (string.startsWith("xmlns")) continue;
                    AttrValue attrValue = authorElement.getAttribute(string);
                    AttrValue attrValue2 = authorElement2.getAttribute(string);
                    if (attrValue != null && attrValue2.getValue().equals(attrValue.getValue())) continue;
                    bl = false;
                    break;
                }
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private AuthorElement getElementFromFragment(String string, AuthorAccess authorAccess) throws AuthorOperationException {
        AuthorElement authorElement = null;
        AuthorDocumentFragment authorDocumentFragment = authorAccess.getDocumentController().createNewDocumentFragmentInContext(string, authorAccess.getEditorAccess().getCaretOffset());
        List<AuthorNode> list = authorDocumentFragment.getContentNodes();
        if (list.size() != 1 || authorDocumentFragment.containsSimpleText()) {
            throw new AuthorOperationException("The value of the 'element' argument is not valid. It must be an XML fragment containing a single element.");
        }
        AuthorNode authorNode = list.get(0);
        if (authorNode instanceof AuthorElement) {
            if (((AuthorElement)authorNode).getContentNodes().size() > 0) {
                throw new AuthorOperationException("The value of the 'element' argument is not valid. It must be an XML fragment containing a single element.");
            }
        } else {
            throw new AuthorOperationException("The value of the 'element' argument is not valid. It must be an XML fragment containing a single element.");
        }
        authorElement = (AuthorElement)authorNode;
        return authorElement;
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return ARGUMENTS;
    }

    @Override
    public String getDescription() {
        return "Toggle \"surround with element\" operation.\n If there is no selection in the document and the caret is inside a word,\nthe word is wrapped in the given element (or unwrapped if it is already\nincluded in the element), else the fragment is inserted at caret position.\n If there is a selection in the document, it is wrapped in the given element\n(or unwrapped if it is already included in the element).\n";
    }

    private int[] unwrap(AuthorElement authorElement, int n2, int n3, AuthorAccess authorAccess) {
        try {
            boolean bl = n2 > n3;
            AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
            int n4 = authorElement.getStartOffset();
            int n5 = authorElement.getEndOffset();
            int[] nArray = this.extendSelectionOverSentinels(n2, n3, authorElement.getStartOffset(), authorElement.getEndOffset(), authorAccess);
            n2 = nArray[0];
            n3 = nArray[1];
            if (n2 > n4 && n3 < n5) {
                AuthorDocumentFragment authorDocumentFragment = authorDocumentController.createDocumentFragment(n3 + 1, n5);
                authorDocumentController.delete(n3 + 1, n5);
                AuthorNode authorNode = authorDocumentController.getNodeAtOffset(n4 + 1);
                int n6 = authorNode.getEndOffset() + 1;
                authorDocumentController.insertFragment(n6, authorDocumentFragment);
                int n7 = 0;
                int n8 = n2 < n3 ? n3 - n2 + 1 : 0;
                AuthorDocumentFragment authorDocumentFragment2 = null;
                if (n2 <= authorNode.getEndOffset() - 1) {
                    authorDocumentFragment2 = authorDocumentController.createDocumentFragment(n2, authorNode.getEndOffset() - 1);
                    n7 = (authorDocumentFragment2.getLength() - n8) / 2;
                    authorDocumentController.delete(n2, authorNode.getEndOffset() - 1);
                    authorNode = authorDocumentController.getNodeAtOffset(n4 + 1);
                    n6 = authorNode.getEndOffset() + 1;
                    authorDocumentController.insertFragment(n6, authorDocumentFragment2);
                }
                n2 = n6 + n7;
                n3 = n2 + n8 - 1;
            } else if (n4 >= n2 && n3 >= n5 - 1) {
                if (n4 == n5 - 1) {
                    authorDocumentController.deleteNode(authorElement);
                } else {
                    AuthorDocumentFragment authorDocumentFragment = authorDocumentController.createDocumentFragment(n4 + 1, n5 - 1);
                    authorDocumentController.delete(n4, n5);
                    authorDocumentController.insertFragment(n4, authorDocumentFragment);
                }
                if (n2 > n4) {
                    --n2;
                }
                if (n3 != n5 - 1) {
                    n3 -= 2;
                }
            } else if (n4 < n2) {
                if (n2 < n5) {
                    AuthorDocumentFragment authorDocumentFragment = authorDocumentController.createDocumentFragment(n2, n5 - 1);
                    authorDocumentController.delete(n2, n5 - 1);
                    AuthorNode authorNode = authorDocumentController.getNodeAtOffset(n4 + 1);
                    int n9 = authorNode.getEndOffset() + 1;
                    authorDocumentController.insertFragment(n9, authorDocumentFragment);
                    if (bl) {
                        n3 = n2 = n9 + authorDocumentFragment.getLength() / 2;
                    } else {
                        n2 = n9;
                        n3 = n9 + authorDocumentFragment.getLength() + n3 - (n5 + 1);
                    }
                }
            } else if (n3 > n4) {
                AuthorDocumentFragment authorDocumentFragment = authorDocumentController.createDocumentFragment(n4 + 1, n3);
                authorDocumentController.delete(n4 + 1, n3);
                authorDocumentController.insertFragment(n4, authorDocumentFragment);
                n3 = bl ? (n2 = n4 + authorDocumentFragment.getLength() / 2) : n4 + authorDocumentFragment.getLength() - 1;
            } else {
                --n3;
            }
        }
        catch (BadLocationException badLocationException) {
            logger.error((Object)badLocationException, (Throwable)badLocationException);
        }
        return new int[]{++n2, --n3};
    }

    private UnwrapResult unwrapElementsMatchingReferenceElement(int object, int object2, AuthorElement authorElement, AuthorAccess authorAccess) throws AuthorOperationException {
        boolean bl = false;
        int[] nArray = new int[]{object, object2};
        try {
            AuthorElement authorElement2;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            Object object3;
            AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
            Segment segment = new Segment();
            authorDocumentController.getChars((int)object, object2 - object + 1, segment);
            char c2 = segment.first();
            int n7 = object;
            AuthorNode authorNode = null;
            AuthorNode authorNode2 = null;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean[] blArray = new boolean[object2 - object + 1];
            while (c2 != '\uffff') {
                if (c2 == '\u0000') {
                    OffsetInformation offsetInformation = authorDocumentController.getContentInformationAtOffset(n7);
                    object3 = offsetInformation.getNodeForMarkerOffset();
                    if (object3 instanceof AuthorElement) {
                        n6 = object3.getStartOffset();
                        n5 = object3.getEndOffset();
                        if (this.elementMatchesReferenceElement((AuthorElement)object3, authorElement)) {
                            n4 = Math.max(object, n6);
                            n3 = Math.min(object2, n5);
                            for (n2 = n4 - object; n2 <= n3 - object; ++n2) {
                                blArray[n2] = true;
                            }
                            if (offsetInformation.getPositionType() == 1) {
                                if (object2 < n5) {
                                    authorNode2 = (AuthorElement)object3;
                                    break;
                                }
                            } else if (offsetInformation.getPositionType() == 2 && object > n6) {
                                authorNode = (AuthorElement)object3;
                                bl2 = false;
                            }
                        } else {
                            blArray[n7 - object] = true;
                            if (offsetInformation.getPositionType() == 1) {
                                if (object2 < n5) {
                                    bl3 = true;
                                }
                            } else if (offsetInformation.getPositionType() == 2 && object > n6) {
                                bl2 = true;
                            }
                        }
                    }
                } else if (Character.isWhitespace(c2)) {
                    blArray[n7 - object] = true;
                }
                c2 = segment.next();
                ++n7;
            }
            for (int i2 = 0; i2 < blArray.length; ++i2) {
                if (blArray[i2]) continue;
                bl = true;
                break;
            }
            AuthorNode authorNode3 = null;
            if (!bl || bl2 || bl3) {
                if (authorNode2 != null) {
                    object3 = this.unwrap((AuthorElement)authorNode2, (int)object, (int)object2, authorAccess);
                    object = object3[0];
                    object2 = object3[1];
                }
                if (authorNode != null) {
                    object3 = this.unwrap((AuthorElement)authorNode, (int)object, (int)object2, authorAccess);
                    object = object3[0];
                    object2 = object3[1];
                }
            } else if (authorNode != null) {
                int n8 = authorNode.getEndOffset() + 1;
                n6 = authorNode2 != null ? authorNode2.getStartOffset() - 1 : object2;
                AuthorDocumentFragment authorDocumentFragment = authorDocumentController.createDocumentFragment(n8, n6);
                AuthorDocumentFragment authorDocumentFragment2 = null;
                n3 = 0;
                if (authorNode2 != null) {
                    n3 = authorNode2.getEndOffset() - object2;
                    authorDocumentFragment2 = authorDocumentController.createDocumentFragment(authorNode2.getStartOffset() + 1, authorNode2.getEndOffset() - 1);
                    authorDocumentController.deleteNode(authorNode2);
                }
                authorDocumentController.delete(n8, n6);
                n2 = authorNode.getEndOffset();
                if (authorNode2 != null) {
                    authorDocumentController.insertFragment(n2, authorDocumentFragment2);
                }
                authorDocumentController.insertFragment(n2, authorDocumentFragment);
                AuthorNode authorNode4 = authorDocumentController.getNodeAtOffset(n2);
                object2 = authorNode4.getEndOffset() - n3;
                authorNode3 = authorNode4;
                bl = false;
            } else if (authorNode2 != null) {
                object3 = authorDocumentController.createDocumentFragment((int)object, authorNode2.getStartOffset() - 1);
                n6 = authorNode2.getEndOffset() - object2;
                authorDocumentController.delete((int)object, authorNode2.getStartOffset() - 1);
                n5 = authorNode2.getStartOffset() + 1;
                authorDocumentController.insertFragment(n5, (AuthorDocumentFragment)object3);
                AuthorNode authorNode5 = authorDocumentController.getNodeAtOffset(n5);
                object2 = authorNode5.getEndOffset() - n6;
                authorNode3 = authorNode5;
                bl = false;
            }
            segment = new Segment();
            authorDocumentController.getChars((int)object, object2 - object + 1, segment);
            n7 = object;
            c2 = segment.first();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            while (c2 != '\uffff') {
                OffsetInformation offsetInformation;
                AuthorNode authorNode6;
                if (c2 == '\u0000' && (authorNode6 = (offsetInformation = authorDocumentController.getContentInformationAtOffset(n7)).getNodeForMarkerOffset()) instanceof AuthorElement && this.elementMatchesReferenceElement((AuthorElement)authorNode6, authorElement)) {
                    n4 = authorNode6.getStartOffset();
                    n3 = authorNode6.getEndOffset();
                    if (offsetInformation.getPositionType() == 1 && object2 >= n3) {
                        arrayList.add(0, n4);
                    }
                }
                c2 = segment.next();
                ++n7;
            }
            for (Integer n9 : arrayList) {
                AuthorNode authorNode7 = authorDocumentController.getNodeAtOffset(n9 + 1);
                int[] nArray2 = this.unwrap((AuthorElement)authorNode7, (int)object, (int)object2, authorAccess);
                object = nArray2[0];
                object2 = nArray2[1];
            }
            nArray = new int[]{object, object2};
            AuthorNode authorNode8 = authorAccess.getDocumentController().getCommonParentNode(authorAccess.getDocumentController().getAuthorDocumentNode(), (int)object, (int)object2);
            if (authorNode8 instanceof AuthorElement && (authorElement2 = this.getElementMatchingReferenceElement((AuthorElement)authorNode8, authorAccess, authorElement, true)) != null && authorElement2 != authorNode3) {
                int[] nArray3 = this.unwrap(authorElement2, (int)object, (int)object2, authorAccess);
                nArray = new int[]{nArray3[0], nArray3[1]};
                bl = false;
            }
        }
        catch (BadLocationException badLocationException) {
            throw new AuthorOperationException("The operation could not be executed.", badLocationException);
        }
        return new UnwrapResult(bl, nArray);
    }

    private IntervalAndAction canToggleSchemaAware(AuthorAccess authorAccess, int n2, int n3, AuthorElement authorElement, AuthorDocumentFragment authorDocumentFragment) throws BadLocationException {
        int n4 = 0;
        boolean bl = false;
        AuthorSchemaManager authorSchemaManager = authorAccess.getDocumentController().getAuthorSchemaManager();
        if (authorSchemaManager != null && !authorSchemaManager.hasLoadingErrors() && !authorSchemaManager.isLearnSchema()) {
            n4 = 3;
            AuthorNode authorNode = authorAccess.getDocumentController().getCommonParentNode(authorAccess.getDocumentController().getAuthorDocumentNode(), n2, n3);
            boolean bl2 = true;
            bl = this.isFullyWrappedInterval(authorAccess, n2, n3, authorElement);
            bl2 = bl;
            if (!bl2 && authorNode instanceof AuthorElement) {
                bl2 = this.elementMatchesReferenceElement((AuthorElement)authorNode, authorElement);
            }
            boolean bl3 = false;
            if (!bl2) {
                bl3 = this.canWrap(authorAccess, authorDocumentFragment, n2, n3, authorNode, (short)1);
            }
            if (bl3 || bl2) {
                n4 = 0;
            }
        }
        return new IntervalAndAction(new int[]{n2, n3}, n4, bl);
    }

    private boolean isFullyWrappedInterval(AuthorAccess authorAccess, int n2, int n3, AuthorElement authorElement) throws BadLocationException {
        int n4;
        int n5;
        AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
        Segment segment = new Segment();
        authorDocumentController.getChars(n2, n3 - n2 + 1, segment);
        char c2 = segment.first();
        int n6 = n2;
        short[] sArray = new short[n3 - n2 + 1];
        short s2 = 0;
        short s3 = 1;
        int n7 = 2;
        while (c2 != '\uffff') {
            if (c2 == '\u0000') {
                OffsetInformation offsetInformation = authorDocumentController.getContentInformationAtOffset(n6);
                AuthorNode authorNode = offsetInformation.getNodeForMarkerOffset();
                if (authorNode instanceof AuthorElement) {
                    n5 = authorNode.getStartOffset();
                    n4 = authorNode.getEndOffset();
                    if (this.elementMatchesReferenceElement((AuthorElement)authorNode, authorElement)) {
                        int n8 = Math.max(n2, n5);
                        int n9 = Math.min(n3, n4);
                        for (int i2 = n8 - n2; i2 <= n9 - n2; ++i2) {
                            sArray[i2] = s3;
                        }
                        if (offsetInformation.getPositionType() == 1 && n3 < n4) {
                            break;
                        }
                    } else {
                        sArray[n6 - n2] = n7;
                    }
                }
            } else if (Character.isWhitespace(c2)) {
                sArray[n6 - n2] = n7;
            }
            c2 = segment.next();
            ++n6;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (logger.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (n4 = 0; n4 < sArray.length; ++n4) {
                stringBuilder.append(sArray[n4]).append(",");
            }
            logger.debug("Mask: " + stringBuilder.toString());
        }
        for (n5 = 0; n5 < sArray.length; ++n5) {
            if (sArray[n5] == s2) {
                bl = true;
                break;
            }
            if (sArray[n5] != s3) continue;
            bl2 = true;
        }
        int n10 = n5 = !bl && bl2 ? 1 : 0;
        if (n5 == 0) {
            AuthorNode authorNode = authorAccess.getDocumentController().getCommonParentNode(authorAccess.getDocumentController().getAuthorDocumentNode(), n2, n3);
            if (logger.isDebugEnabled()) {
                logger.debug("CommonParentNode " + authorNode);
            }
            if (authorNode instanceof AuthorElement) {
                AuthorElement authorElement2 = this.getElementMatchingReferenceElement((AuthorElement)authorNode, authorAccess, authorElement, true);
                if (logger.isDebugEnabled()) {
                    logger.debug("Ancestor toggle element: " + authorElement2);
                }
                n5 = authorElement2 != null ? 1 : 0;
            }
        }
        return n5 != 0;
    }

    private boolean canWrap(AuthorAccess authorAccess, AuthorDocumentFragment authorDocumentFragment, int n2, int n3, AuthorNode authorNode, short s2) throws BadLocationException {
        boolean bl = true;
        AuthorSchemaManager authorSchemaManager = authorAccess.getDocumentController().getAuthorSchemaManager();
        if (authorSchemaManager != null && !authorSchemaManager.hasLoadingErrors() && !authorSchemaManager.isLearnSchema() && (bl = authorSchemaManager.canInsertDocumentFragment(authorDocumentFragment, n2, s2))) {
            WhatElementsCanGoHereContext whatElementsCanGoHereContext = null;
            whatElementsCanGoHereContext = authorNode instanceof AuthorElement ? authorSchemaManager.createWhatElementsCanGoHereContext(authorNode.getStartOffset() + 1) : new WhatElementsCanGoHereContext();
            AuthorElement[] authorElementArray = ToggleSurroundWithElementOperation.getElementsPath(authorDocumentFragment);
            for (int i2 = 0; i2 < authorElementArray.length; ++i2) {
                this.pushContextElement(whatElementsCanGoHereContext, authorElementArray[i2].getName());
            }
            AuthorDocumentFragment authorDocumentFragment2 = authorAccess.getDocumentController().createDocumentFragment(n2, n3);
            bl = authorSchemaManager.canInsertDocumentFragments(new AuthorDocumentFragment[]{authorDocumentFragment2}, whatElementsCanGoHereContext, s2);
        }
        return bl;
    }

    private void pushContextElement(WhatElementsCanGoHereContext whatElementsCanGoHereContext, String string) {
        ContextElement contextElement = new ContextElement();
        contextElement.setQName(string);
        whatElementsCanGoHereContext.pushContextElement(contextElement, null);
    }

    public static AuthorElement[] getElementsPath(AuthorDocumentFragment authorDocumentFragment) {
        LinkedList<AuthorElement> linkedList = new LinkedList<AuthorElement>();
        for (AuthorNode authorNode = AuthorNodeUtil.getFirstLeaf(authorDocumentFragment); authorNode != null; authorNode = authorNode.getParent()) {
            if (!(authorNode instanceof AuthorElement)) continue;
            linkedList.addFirst((AuthorElement)authorNode);
        }
        return linkedList.toArray(new AuthorElement[0]);
    }

    public static List<int[]> getEquiIntervalFromMarker(AuthorAccess authorAccess, int[] nArray) throws BadLocationException {
        AuthorNode authorNode;
        ArrayList<int[]> arrayList = new ArrayList<int[]>(1);
        AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
        int n2 = nArray[0];
        int n3 = nArray[1];
        AuthorNode authorNode2 = authorDocumentController.getNodeAtOffset(n2);
        if (authorNode2 == (authorNode = authorDocumentController.getNodeAtOffset(n3 + 1))) {
            if (logger.isDebugEnabled()) {
                logger.debug("Same node:" + authorNode2);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("SO:" + n2 + " EO:" + n3);
            }
            arrayList.add(nArray);
        } else {
            AuthorNode authorNode3 = authorAccess.getDocumentController().getCommonParentNode(authorAccess.getDocumentController().getAuthorDocumentNode(), n2, n3);
            if (logger.isDebugEnabled()) {
                logger.debug("SO:" + n2 + " EO:" + n3);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("startNode:" + authorNode2 + " endNode: " + authorNode);
            }
            while (authorNode3 != authorNode2 && authorNode2 != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Split at start end:" + authorNode2.getEndOffset());
                }
                if (n2 <= authorNode2.getEndOffset() - 1) {
                    arrayList.add(new int[]{n2, authorNode2.getEndOffset() - 1});
                }
                n2 = authorNode2.getEndOffset() + 1;
                authorNode2 = authorNode2.getParent();
            }
            int n4 = arrayList.size();
            while (authorNode3 != authorNode && authorNode != null) {
                if (authorNode.getStartOffset() + 1 <= n3) {
                    arrayList.add(n4, new int[]{authorNode.getStartOffset() + 1, n3});
                }
                n3 = authorNode.getStartOffset() - 1;
                authorNode = authorNode.getParent();
            }
            if (n2 <= n3) {
                arrayList.add(n4, new int[]{n2, n3});
            }
        }
        return arrayList;
    }

    private static class IntervalAndAction {
        private static final int ACTION_SURROUND = 0;
        private static final int ACTION_INSERT = 2;
        private static final int ACTION_INVALID = 3;
        private static final int ACTION_SKIP = 4;
        int[] interval;
        int action = 0;
        private boolean entireIntervalWrapped;

        public IntervalAndAction(int[] nArray, int n2) {
            this.interval = nArray;
            this.action = n2;
        }

        public IntervalAndAction(int[] nArray, int n2, boolean bl) {
            this.interval = nArray;
            this.action = n2;
            this.entireIntervalWrapped = bl;
        }

        public String toString() {
            return "[" + this.interval[0] + ", " + this.interval[1] + "], action: " + this.action + ", fullyWrapped: " + this.entireIntervalWrapped;
        }
    }

    private static class UnwrapResult {
        boolean performSurround;
        int[] intervalToSurround;

        public UnwrapResult(boolean bl, int[] nArray) {
            this.performSurround = bl;
            this.intervalToSurround = nArray;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            if (this.intervalToSurround != null) {
                stringBuilder.append(this.intervalToSurround[0] + ", " + this.intervalToSurround[1]);
            }
            stringBuilder.append("] perform surround ").append(this.performSurround);
            return stringBuilder.toString();
        }
    }
}

