/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class ReplaceElementContentOperation
implements AuthorOperation {
    public static final String ARGUMENT_FRAGMENT = "fragment";
    static final String ARGUMENT_ELEMENT_XPATH_LOCATION = "elementLocation";
    private ArgumentDescriptor[] arguments = new ArgumentDescriptor[]{new ArgumentDescriptor("elementLocation", 2, "An XPath expression indicating the element whose attribute will be changed.\nNote: If it is not defined then the element at the caret position or the current fully selected element will be used."), new ArgumentDescriptor("fragment", 1, "The new content of the element.")};

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        try {
            boolean bl;
            AuthorNode authorNode = ReplaceElementContentOperation.getNodeToReplaceContent(authorAccess, argumentsMap);
            int n2 = authorNode.getStartOffset() + 1;
            int n3 = authorNode.getEndOffset() - 1;
            AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
            if (n2 <= n3 && !(bl = authorDocumentController.delete(n2, n3))) {
                throw new AuthorOperationException("Could not delete old content node.");
            }
            String string = ReplaceElementContentOperation.getFragmentToInsert(argumentsMap);
            if (string.length() > 0) {
                AuthorDocumentFragment authorDocumentFragment = authorDocumentController.createNewDocumentFragmentInContext(string, n2);
                authorDocumentController.insertFragment(n2, authorDocumentFragment);
            }
        }
        catch (BadLocationException badLocationException) {
            throw new AuthorOperationException("Could not determine the node for which to replace the content.", badLocationException);
        }
    }

    private static String getFragmentToInsert(ArgumentsMap argumentsMap) {
        String string = null;
        Object object = argumentsMap.getArgumentValue(ARGUMENT_FRAGMENT);
        if (object == null) {
            string = "";
        } else if (object instanceof String) {
            string = (String)object;
        } else {
            throw new IllegalArgumentException("Incorrect fragment argument: " + object);
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static AuthorNode getNodeToReplaceContent(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws BadLocationException, AuthorOperationException {
        AuthorNode authorNode = null;
        Object object = argumentsMap.getArgumentValue(ARGUMENT_ELEMENT_XPATH_LOCATION);
        if (object instanceof String && !((String)object).isEmpty()) {
            AuthorNode[] authorNodeArray = authorAccess.getDocumentController().findNodesByXPath((String)object, true, true, true);
            if (authorNodeArray.length <= 0) throw new AuthorOperationException("The element XPath location does not identify an element: " + object);
            if (!(authorNodeArray[0] instanceof AuthorElement)) throw new AuthorOperationException("The element XPath location does not identify an element: " + object);
            return authorNodeArray[0];
        }
        authorNode = authorAccess.getEditorAccess().getFullySelectedNode();
        if (authorNode != null) return authorNode;
        int n2 = authorAccess.getEditorAccess().getCaretOffset();
        return authorAccess.getDocumentController().getNodeAtOffset(n2);
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }

    @Override
    public String getDescription() {
        return "Replaces the content of the fully selected element or the content of the element at caret (if the selection is empty or a node is not entirely selected)";
    }
}

