/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import java.util.ArrayList;
import java.util.List;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorReviewController;
import ro.sync.ecss.extensions.api.highlights.AuthorPersistentHighlight;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
final class ElementLocationPath {
    private final List<ElementLocationPathComponent> path = new ArrayList<ElementLocationPathComponent>();

    private ElementLocationPath() {
    }

    public List<ElementLocationPathComponent> getPath() {
        return this.path;
    }

    public String toXPath() {
        StringBuilder stringBuilder = new StringBuilder();
        for (ElementLocationPathComponent elementLocationPathComponent : this.path) {
            stringBuilder.append(elementLocationPathComponent.toXPath());
        }
        return stringBuilder.toString();
    }

    private ElementLocationPath addFront(ElementLocationPathComponent elementLocationPathComponent) {
        this.path.add(0, elementLocationPathComponent);
        return this;
    }

    public static ElementLocationPath getCurrentElementLocation(AuthorReviewController authorReviewController, AuthorElement authorElement, AuthorElement authorElement2) {
        ElementLocationPath elementLocationPath = new ElementLocationPath();
        AuthorElement authorElement3 = authorElement;
        if (authorElement3.isDescendentOf(authorElement2)) {
            while (authorElement3 != authorElement2) {
                AuthorNode authorNode;
                AuthorElement authorElement4 = (AuthorElement)authorElement3.getParent();
                List<AuthorNode> list = authorElement4.getContentNodes();
                int n2 = 1;
                for (int i2 = 0; i2 < list.size() && (authorNode = list.get(i2)) != authorElement3; ++i2) {
                    boolean bl = false;
                    if (authorNode.getType() != 0) {
                        bl = true;
                    } else {
                        AuthorPersistentHighlight[] authorPersistentHighlightArray = authorReviewController.getChangeHighlights(authorNode.getStartOffset(), authorNode.getEndOffset());
                        if (authorPersistentHighlightArray != null) {
                            for (int i3 = 0; i3 < authorPersistentHighlightArray.length; ++i3) {
                                if (authorPersistentHighlightArray[i3].getType() != AuthorPersistentHighlight.PersistentHighlightType.CHANGE_DELETE || authorPersistentHighlightArray[i3].getStartOffset() > authorNode.getStartOffset() || authorNode.getEndOffset() > authorPersistentHighlightArray[i3].getEndOffset()) continue;
                                bl = true;
                                break;
                            }
                        }
                    }
                    if (bl) continue;
                    ++n2;
                }
                elementLocationPath.addFront(new Child(n2));
                authorElement3 = authorElement4;
            }
            elementLocationPath.addFront(new Child(1));
        } else {
            elementLocationPath = authorElement3.equals(authorElement2) ? new ElementLocationPath().addFront(new Root()) : new ElementLocationPath().addFront(new Parent());
        }
        return elementLocationPath;
    }

    public static interface ElementLocationPathComponent {
        public String toXPath();
    }

    public static class Child
    implements ElementLocationPathComponent {
        private final int index;

        public Child(int n2) {
            this.index = n2;
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public String toXPath() {
            return "/*[" + this.index + "]";
        }
    }

    public static class Root
    implements ElementLocationPathComponent {
        @Override
        public String toXPath() {
            return "/*";
        }
    }

    public static class Parent
    implements ElementLocationPathComponent {
        @Override
        public String toXPath() {
            return "/..";
        }
    }
}

