/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.imagemap.operations;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.commons.imagemap.operations.NewShapeDescriptor;

@API(type=APIType.EXTENDABLE, src=SourceType.PUBLIC)
@WebappCompatible
public abstract class UpdateImageMapOperationBase
implements AuthorOperation {
    private static final Logger logger = LoggerFactory.getLogger((String)UpdateImageMapOperationBase.class.getName());
    public static final String ARGUMENT_SHAPES = "shapes";
    protected static final ArgumentDescriptor[] ARGUMENTS = new ArgumentDescriptor[]{new ArgumentDescriptor("shapes", 0, "An SVG with the shapes to be used to update the Image Map at caret.\nIn order to match shapes from the SVG with shapes in the document, this operation needs the \"data-original-layer\" attribute of the SVG element to match the layer of the shape in the document.")};

    @Override
    public String getDescription() {
        return "Updates an image map with shape information from an SVG";
    }

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        int n2;
        AuthorEditorAccess authorEditorAccess;
        String string = (String)argumentsMap.getArgumentValue(ARGUMENT_SHAPES);
        AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
        AuthorElement authorElement = this.getNodeToReplace(authorDocumentController, authorEditorAccess = authorAccess.getEditorAccess(), n2 = authorEditorAccess.getCaretOffset());
        if (authorElement != null) {
            List<? extends NewShapeDescriptor> list = this.getNewShapesList(string);
            authorDocumentController.beginCompoundEdit();
            try {
                this.mergeImageMaps(authorDocumentController, authorElement, list);
            }
            catch (Exception exception) {
                throw new AuthorOperationException("Cannot obtain the image map from internal model!", exception);
            }
            finally {
                authorDocumentController.endCompoundEdit();
            }
        } else {
            throw new AuthorOperationException("Could not identify Image Map!");
        }
    }

    protected abstract AuthorElement getImageMapElement(AuthorElement var1);

    protected abstract List<? extends NewShapeDescriptor> getNewShapesList(String var1) throws AuthorOperationException;

    protected abstract AuthorElement[] getExistingShapesList(AuthorElement var1);

    private void mergeImageMaps(AuthorDocumentController authorDocumentController, AuthorElement authorElement, List<? extends NewShapeDescriptor> list) throws AuthorOperationException {
        Map<Integer, AuthorElement> map = UpdateImageMapOperationBase.getShapesMap(this.getExistingShapesList(authorElement));
        List list2 = list.stream().map(newShapeDescriptor -> this.getXmlForNewShape(authorDocumentController, map, (NewShapeDescriptor)newShapeDescriptor)).filter(Objects::nonNull).collect(Collectors.toList());
        int n2 = authorElement.getEndOffset();
        for (AuthorElement object : map.values()) {
            n2 = Math.min(n2, object.getStartOffset());
            authorDocumentController.deleteNode(object);
        }
        Collections.reverse(list2);
        for (String string : list2) {
            authorDocumentController.insertXMLFragment(string, n2);
        }
    }

    private String getXmlForNewShape(AuthorDocumentController authorDocumentController, Map<Integer, AuthorElement> map, NewShapeDescriptor newShapeDescriptor) {
        String string;
        Optional<Integer> optional = newShapeDescriptor.getOriginalLayer();
        if (optional.isPresent()) {
            try {
                AuthorElement authorElement = map.get(optional.get());
                newShapeDescriptor.mergeIntoOriginalShape(authorDocumentController, authorElement);
                string = authorDocumentController.serializeFragmentToXML(authorDocumentController.createDocumentFragment(authorElement, true));
            }
            catch (BadLocationException badLocationException) {
                logger.warn("Unable to merge shapes.", (Throwable)badLocationException);
                string = newShapeDescriptor.serializeToXml().orElse(null);
            }
        } else {
            string = newShapeDescriptor.serializeToXml().orElse(null);
        }
        return string;
    }

    private static Map<Integer, AuthorElement> getShapesMap(AuthorElement[] authorElementArray) {
        HashMap<Integer, AuthorElement> hashMap = new HashMap<Integer, AuthorElement>();
        for (int i2 = 0; i2 < authorElementArray.length; ++i2) {
            hashMap.put(i2, authorElementArray[i2]);
        }
        return hashMap;
    }

    private AuthorElement getNodeToReplace(AuthorDocumentController authorDocumentController, AuthorEditorAccess authorEditorAccess, int n2) throws AuthorOperationException {
        AuthorElement authorElement = (AuthorElement)authorEditorAccess.getFullySelectedNode();
        if (authorElement == null) {
            try {
                authorElement = (AuthorElement)authorDocumentController.getNodeAtOffset(n2);
            }
            catch (BadLocationException badLocationException) {
                throw new AuthorOperationException(badLocationException.getMessage(), badLocationException);
            }
        }
        return this.getImageMapElement(authorElement);
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return ARGUMENTS;
    }
}

