/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.id;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.UniqueAttributesRecognizer;
import ro.sync.ecss.extensions.api.content.ClipboardFragmentInformation;
import ro.sync.ecss.extensions.api.content.ClipboardFragmentProcessor;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.AuthorParentNode;
import ro.sync.ecss.extensions.commons.id.GenerateIDElementsInfo;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DefaultUniqueAttributesRecognizer
implements UniqueAttributesRecognizer,
ClipboardFragmentProcessor {
    protected String idAttrQname = "id";
    protected AuthorAccess authorAccess;
    private GenerateIDElementsInfo defaultOptions = new GenerateIDElementsInfo(false, "${localName}_${id}", new String[0]);
    private static final Logger logger = LoggerFactory.getLogger((String)DefaultUniqueAttributesRecognizer.class.getName());

    public DefaultUniqueAttributesRecognizer() {
    }

    public DefaultUniqueAttributesRecognizer(String string) {
        this.idAttrQname = string;
    }

    @Override
    public boolean copyAttributeOnSplit(String string, AuthorElement authorElement) {
        return !this.idAttrQname.equals(string);
    }

    @Override
    public void activated(AuthorAccess authorAccess) {
        this.authorAccess = authorAccess;
        this.defaultOptions = GenerateIDElementsInfo.loadDefaultsFromConfiguration(authorAccess, this.getDefaultOptionsXMLResourceName());
        if (this.defaultOptions.getAttrQname() != null) {
            this.idAttrQname = this.defaultOptions.getAttrQname();
        }
    }

    @Override
    public void deactivated(AuthorAccess authorAccess) {
        this.authorAccess = null;
    }

    protected GenerateIDElementsInfo getDefaultOptions() {
        return this.defaultOptions;
    }

    protected String getDefaultOptionsXMLResourceName() {
        return null;
    }

    @Override
    public boolean isAutoIDGenerationActive() {
        GenerateIDElementsInfo generateIDElementsInfo = this.getGenerateIDElementsInfo();
        return generateIDElementsInfo != null && generateIDElementsInfo.isAutoGenerateIDs() && generateIDElementsInfo.getElementsWithIDGeneration() != null;
    }

    protected String getGenerateIDAttributeQName(AuthorElement authorElement, String[] stringArray, boolean bl) {
        String string = null;
        if (bl) {
            string = this.idAttrQname;
        } else {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string2 = stringArray[i2];
                boolean bl2 = false;
                if (authorElement.getLocalName().equals(string2)) {
                    bl2 = true;
                }
                if (!bl2) continue;
                string = this.idAttrQname;
                break;
            }
        }
        return string;
    }

    protected String generateUniqueIDFor(String string, AuthorElement authorElement) {
        URL uRL = authorElement.getXMLBaseURL();
        return GenerateIDElementsInfo.generateID(string, authorElement.getLocalName(), uRL != null ? uRL.toString() : null);
    }

    @Override
    public void assignUniqueIDs(int n2, int n3, boolean bl) {
        GenerateIDElementsInfo generateIDElementsInfo;
        if (this.authorAccess != null && (generateIDElementsInfo = this.getGenerateIDElementsInfo()) != null && (bl || generateIDElementsInfo.getElementsWithIDGeneration() != null && generateIDElementsInfo.getElementsWithIDGeneration().length > 0)) {
            try {
                AuthorNode authorNode = this.authorAccess.getDocumentController().getCommonParentNode(this.authorAccess.getDocumentController().getAuthorDocumentNode(), n2, n3);
                this.authorAccess.getDocumentController().beginCompoundEdit();
                ArrayList<AttributeSetInfo> arrayList = new ArrayList<AttributeSetInfo>();
                this.generateUniqueIDs(this.authorAccess, authorNode, n2, n3, generateIDElementsInfo.getIdGenerationPattern(), generateIDElementsInfo.getElementsWithIDGeneration(), bl, arrayList);
                this.setIDs(arrayList);
            }
            catch (BadLocationException badLocationException) {
                logger.warn((Object)badLocationException, (Throwable)badLocationException);
            }
        }
    }

    private void generateUniqueIDs(AuthorAccess authorAccess, AuthorNode authorNode, int n2, int n3, String string, String[] stringArray, boolean bl, List<AttributeSetInfo> list) {
        if (authorAccess.getDocumentController().isEditable(authorNode)) {
            boolean bl2;
            int n4 = authorNode.getStartOffset();
            int n5 = authorNode.getEndOffset();
            boolean bl3 = n2 <= n4 && n5 <= n3 || n2 <= n4 && n4 <= n3 || n2 <= n5 && n5 <= n3;
            boolean bl4 = bl2 = n4 <= n2 && n2 <= n5 || n4 <= n3 && n3 <= n5 || n2 <= n4 && n4 <= n3 || n2 <= n5 && n5 <= n3;
            if (bl2) {
                Object object;
                if (bl3 && (object = this.generateUniqueIdForNode(authorNode, string, stringArray, bl)) != null) {
                    list.add((AttributeSetInfo)object);
                }
                if (authorNode instanceof AuthorParentNode) {
                    object = (AuthorParentNode)authorNode;
                    List<AuthorNode> list2 = object.getContentNodes();
                    for (int i2 = 0; i2 < list2.size(); ++i2) {
                        this.generateUniqueIDs(authorAccess, list2.get(i2), n2, n3, string, stringArray, bl, list);
                    }
                }
            }
        }
    }

    private AttributeSetInfo generateUniqueIdForNode(AuthorNode authorNode, String string, String[] stringArray, boolean bl) {
        AttrValue attrValue;
        AuthorElement authorElement;
        String string2;
        AttributeSetInfo attributeSetInfo = null;
        if (authorNode.getType() == 0 && (string2 = this.getGenerateIDAttributeQName(authorElement = (AuthorElement)authorNode, stringArray, bl)) != null && ((attrValue = authorElement.getAttribute(string2)) == null || "".equals(attrValue.getValue()) || !attrValue.isSpecified())) {
            AttributeSetInfo attributeSetInfo2 = new AttributeSetInfo();
            attributeSetInfo2.attrQName = string2;
            attributeSetInfo2.attrValue = this.generateUniqueIDFor(string, authorElement);
            attributeSetInfo2.element = authorElement;
            attributeSetInfo = attributeSetInfo2;
        }
        return attributeSetInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setIDs(List<AttributeSetInfo> list) {
        try {
            int n2 = list.size();
            if (n2 == 1) {
                AttributeSetInfo attributeSetInfo = list.get(0);
                this.authorAccess.getDocumentController().setAttribute(attributeSetInfo.attrQName, new AttrValue(attributeSetInfo.attrValue), attributeSetInfo.element);
            } else {
                int[] nArray = new int[n2];
                AuthorNode[] authorNodeArray = new AuthorNode[n2];
                ArrayList<Map<String, AttrValue>> arrayList = new ArrayList<Map<String, AttrValue>>(n2);
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    AttributeSetInfo attributeSetInfo = list.get(i2);
                    authorNodeArray[i2] = attributeSetInfo.element;
                    nArray[i2] = attributeSetInfo.element.getStartOffset();
                    HashMap<String, AttrValue> hashMap = new HashMap<String, AttrValue>();
                    hashMap.put(attributeSetInfo.attrQName, new AttrValue(attributeSetInfo.attrValue));
                    arrayList.add(hashMap);
                }
                AuthorNode authorNode = this.authorAccess.getDocumentController().getCommonAncestor(authorNodeArray);
                if (authorNode == null) {
                    authorNode = this.authorAccess.getDocumentController().getAuthorDocumentNode();
                }
                if (!arrayList.isEmpty()) {
                    this.authorAccess.getDocumentController().setMultipleDistinctAttributes(authorNode.getStartOffset(), nArray, arrayList);
                }
            }
        }
        finally {
            this.authorAccess.getDocumentController().endCompoundEdit();
        }
    }

    public GenerateIDElementsInfo getGenerateIDElementsInfo() {
        if (this.authorAccess != null) {
            return new GenerateIDElementsInfo(this.authorAccess, this.getDefaultOptions());
        }
        return null;
    }

    @Override
    public void process(ClipboardFragmentInformation clipboardFragmentInformation) {
        String string;
        if (this.authorAccess == null) {
            logger.warn("NULL Author Access, should not happen", (Throwable)new Exception());
            return;
        }
        GenerateIDElementsInfo generateIDElementsInfo = this.getGenerateIDElementsInfo();
        if (generateIDElementsInfo != null && !generateIDElementsInfo.isFilterIDsOnCopy()) {
            return;
        }
        boolean bl = false;
        String string2 = string = clipboardFragmentInformation.getLocationOfLastPaste() != null ? clipboardFragmentInformation.getLocationOfLastPaste() : clipboardFragmentInformation.getOriginalLocation();
        if (string != null && !string.equals(this.authorAccess.getEditorAccess().getEditorLocation().toString())) {
            bl = !this.preserveIDsWhenPastingBetweenResources(clipboardFragmentInformation.getPurposeID());
        } else {
            int n2 = clipboardFragmentInformation.getPurposeID();
            if (n2 == 0 || n2 == 2) {
                bl = true;
            }
        }
        if (bl) {
            this.filterIDAttributes(clipboardFragmentInformation.getFragment().getContentNodes());
        }
    }

    protected boolean preserveIDsWhenPastingBetweenResources(int n2) {
        return true;
    }

    private void filterIDAttributes(List<AuthorNode> list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            AuthorNode authorNode = list.get(i2);
            if (authorNode.getType() == 0) {
                ((AuthorElement)authorNode).removeAttribute(this.idAttrQname);
            }
            if (!(authorNode instanceof AuthorParentNode)) continue;
            this.filterIDAttributes(((AuthorParentNode)authorNode).getContentNodes());
        }
    }

    @Override
    public String getDescription() {
        return "Default unique attributes generation";
    }

    private static class AttributeSetInfo {
        private AuthorElement element;
        private String attrQName;
        private String attrValue;

        private AttributeSetInfo() {
        }
    }
}

