/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.editor;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.util.function.Supplier;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.editor.AuthorInplaceContext;
import ro.sync.exml.workspace.api.Platform;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public final class InplaceEditorUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)InplaceEditorUtil.class.getName());

    private InplaceEditorUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static ro.sync.exml.view.graphics.Dimension getPreferredSize(JPanel jPanel, AuthorInplaceContext authorInplaceContext) {
        Dimension dimension = InplaceEditorUtil.getPreferredSize((Component)jPanel, (Container)authorInplaceContext.getParentHost());
        int n2 = dimension.width;
        int n3 = authorInplaceContext.getPropertyEvaluator().evaluateWidthProperty(authorInplaceContext.getArguments(), authorInplaceContext.getStyles().getFont().getSize());
        if (n3 != -1) {
            n2 = n3;
        } else {
            Integer n4 = (Integer)authorInplaceContext.getArguments().get("columns");
            if (n4 != null && n4 > 0) {
                FontMetrics fontMetrics = jPanel.getFontMetrics(jPanel.getFont());
                n2 = InplaceEditorUtil.getApproximativeCharsWidth(n4, fontMetrics);
            }
        }
        return new ro.sync.exml.view.graphics.Dimension(n2, dimension.height);
    }

    public static ro.sync.exml.view.graphics.Dimension getPreferredSize(JComboBox jComboBox, AuthorInplaceContext authorInplaceContext) {
        Dimension dimension = InplaceEditorUtil.getPreferredSize((Component)jComboBox, (Container)authorInplaceContext.getParentHost());
        int n2 = dimension.width;
        int n3 = authorInplaceContext.getPropertyEvaluator().evaluateWidthProperty(authorInplaceContext.getArguments(), authorInplaceContext.getStyles().getFont().getSize());
        if (n3 != -1) {
            n2 = n3;
        } else {
            Integer n4 = (Integer)authorInplaceContext.getArguments().get("columns");
            if (n4 != null && n4 > 0) {
                FontMetrics fontMetrics = jComboBox.getFontMetrics(jComboBox.getFont());
                n2 = InplaceEditorUtil.getApproximativeCharsWidth(n4, fontMetrics);
            }
        }
        return new ro.sync.exml.view.graphics.Dimension(n2, dimension.height);
    }

    public static ro.sync.exml.view.graphics.Dimension getPreferredSize(JTextField jTextField, AuthorInplaceContext authorInplaceContext) {
        FontMetrics fontMetrics = jTextField.getFontMetrics(jTextField.getFont());
        Dimension dimension = InplaceEditorUtil.getPreferredSize((Component)jTextField, (Container)authorInplaceContext.getParentHost());
        int n2 = dimension.width + InplaceEditorUtil.getApproximativeCharsWidth(1, fontMetrics);
        int n3 = authorInplaceContext.getPropertyEvaluator().evaluateWidthProperty(authorInplaceContext.getArguments(), authorInplaceContext.getStyles().getFont().getSize());
        if (n3 != -1) {
            n2 = n3;
        } else {
            Integer n4 = (Integer)authorInplaceContext.getArguments().get("columns");
            if (n4 != null && n4 > 0) {
                n2 = InplaceEditorUtil.getApproximativeCharsWidth(n4, fontMetrics);
            } else if (jTextField.getText().length() == 0) {
                n2 = InplaceEditorUtil.getApproximativeCharsWidth(2, fontMetrics);
            }
        }
        return new ro.sync.exml.view.graphics.Dimension(n2, dimension.height);
    }

    public static void relayout(JComboBox jComboBox, AuthorInplaceContext authorInplaceContext) {
        ro.sync.exml.view.graphics.Dimension dimension = InplaceEditorUtil.getPreferredSize(jComboBox, authorInplaceContext);
        jComboBox.setSize(dimension.width, dimension.height);
        jComboBox.doLayout();
        InplaceEditorUtil.setCaretAtEnd((JTextField)jComboBox.getEditor().getEditorComponent(), authorInplaceContext);
    }

    public static void relayout(JTextField jTextField, AuthorInplaceContext authorInplaceContext) {
        ro.sync.exml.view.graphics.Dimension dimension = InplaceEditorUtil.getPreferredSize(jTextField, authorInplaceContext);
        jTextField.setSize(dimension.width, dimension.height);
        jTextField.doLayout();
        InplaceEditorUtil.setCaretAtEnd(jTextField, authorInplaceContext);
    }

    public static void setCaretAtEnd(final JTextComponent jTextComponent, AuthorInplaceContext authorInplaceContext) {
        boolean bl = true;
        if (authorInplaceContext.getAuthorAccess() != null && authorInplaceContext.getAuthorAccess().getWorkspaceAccess() != null) {
            bl = Platform.STANDALONE == authorInplaceContext.getAuthorAccess().getWorkspaceAccess().getPlatform();
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (jTextComponent != null) {
                        try {
                            int n2 = jTextComponent.getText(0, jTextComponent.getDocument().getLength()).length();
                            jTextComponent.setCaretPosition(n2);
                            Rectangle rectangle = jTextComponent.modelToView(n2);
                            if (rectangle != null) {
                                jTextComponent.scrollRectToVisible(rectangle);
                            }
                        }
                        catch (IllegalArgumentException | BadLocationException exception) {
                            if (!logger.isDebugEnabled()) break block4;
                            logger.debug((Object)exception, (Throwable)exception);
                        }
                    }
                }
            }
        };
        if (bl || SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private static int getApproximativeCharsWidth(int n2, FontMetrics fontMetrics) {
        char[] cArray = new char[n2];
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            cArray[i2] = 119;
        }
        return fontMetrics.charsWidth(cArray, 0, cArray.length);
    }

    public static Dimension getPreferredSize(final Component component, Container container) {
        return InplaceEditorUtil.addToParent(component, container, new Supplier<Dimension>(){

            @Override
            public Dimension get() {
                return component.getPreferredSize();
            }
        });
    }

    public static <T> T addToParent(Component component, Container container, Supplier<T> supplier) {
        return supplier.get();
    }
}

