/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons;

import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.access.AuthorUtilAccess;
import ro.sync.ecss.extensions.api.node.AuthorNode;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class ObjectChooser {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ObjectChooser.class.getName());
    public static final String[] ALLOWED_IMAGE_EXTENSIONS = new String[]{"gif", "jpg", "jpeg", "bmp", "png", "svg", "svgz", "wmf", "mathml", "mml", "cgm", "tif", "tiff", "eps", "ai", "pdf", "psd"};

    public static String makeUrlRelative(AuthorAccess authorAccess, String string) {
        String string2;
        AuthorUtilAccess authorUtilAccess = authorAccess.getUtilAccess();
        try {
            URL uRL = ObjectChooser.getBaseURL(authorAccess);
            string2 = authorAccess.getXMLUtilAccess().escapeAttributeValue(authorUtilAccess.makeRelative(uRL, authorUtilAccess.removeUserCredentials(new URL(string))));
        }
        catch (MalformedURLException malformedURLException) {
            string2 = string;
        }
        return string2;
    }

    private static URL getBaseURL(AuthorAccess authorAccess) {
        URL uRL = authorAccess.getEditorAccess().getEditorLocation();
        int n2 = authorAccess.getEditorAccess().getCaretOffset();
        try {
            AuthorNode authorNode = authorAccess.getDocumentController().getNodeAtOffset(n2);
            if (authorNode != null) {
                uRL = authorNode.getXMLBaseURL();
            }
        }
        catch (BadLocationException badLocationException) {
            LOGGER.debug(badLocationException.getMessage(), (Throwable)badLocationException);
        }
        return uRL;
    }
}

