/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons;

import java.net.URL;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.ArraysUtil;
import ro.sync.basic.util.URLUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public final class MediaObjectsUtil {
    private static final String VIMEO_EMBEDDED_HOST = "player.vimeo.com";
    private static final String VIDYARD_EMBEDDED_HOST = "play.vidyard.com";
    private static final String VIMEO_HOST = "vimeo.com";
    private static final String YOUTUBE_HOST = "www.youtube.com";
    public static final String REFERENCE_ATTR_DATA = "data";
    public static final String REFERENCE_ATTR_DATAKEYREF = "datakeyref";
    public static final String[] MEDIA_AUDIO_EXTENSIONS = new String[]{"mp3", "wav", "pcm", "m4a", "aif", "aiff"};
    public static final String[] MEDIA_VIDEO_EXTENSIONS = new String[]{"mp4", "flv", "m4v", "avi", "wmv"};
    public static final String[] ALLOWED_MEDIA_EXTENSIONS = (String[])ArraysUtil.mergeArrays((Object)MEDIA_AUDIO_EXTENSIONS, (Object)MEDIA_VIDEO_EXTENSIONS, (int)ArraysUtil.getArrayLength((Object)MEDIA_AUDIO_EXTENSIONS));
    public static final String[] RECOGNIZED_MEDIA_HOSTS = new String[]{"www.youtube.com", "vimeo.com", "player.vimeo.com", "play.vidyard.com"};

    private MediaObjectsUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static boolean containsExtension(String string, String[] stringArray) {
        boolean bl = false;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!string.equalsIgnoreCase(stringArray[i2])) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static String detectOutputclass(String string) {
        String string2 = "iframe";
        if (MediaObjectsUtil.isAudioReference(string)) {
            string2 = "audio";
        } else if (MediaObjectsUtil.isVideoReference(string)) {
            string2 = "video";
        }
        return string2;
    }

    public static boolean isMediaReference(URL uRL) {
        boolean bl = false;
        if (uRL != null) {
            String string = uRL.toExternalForm();
            String string2 = URLUtil.getExtension((String)string);
            String string3 = uRL.getHost().toLowerCase();
            bl = MediaObjectsUtil.containsExtension(string2, ALLOWED_MEDIA_EXTENSIONS) || MediaObjectsUtil.isRecognizedAsMedia(string3);
        }
        return bl;
    }

    public static boolean isEmbeddedContent(String string) {
        boolean bl = false;
        if (string != null) {
            String string2 = string.toLowerCase();
            boolean bl2 = string2.contains(".youtube.") && string2.contains("embed");
            boolean bl3 = string2.contains(VIMEO_EMBEDDED_HOST);
            boolean bl4 = string2.contains(VIDYARD_EMBEDDED_HOST);
            bl = bl2 || bl3 || bl4;
        }
        return bl;
    }

    public static boolean isRecognizedAsMedia(String string) {
        boolean bl = false;
        for (int i2 = 0; i2 < RECOGNIZED_MEDIA_HOSTS.length; ++i2) {
            if (!RECOGNIZED_MEDIA_HOSTS[i2].equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static String correctMediaEmbeddedReference(String string) {
        String string2;
        String string3 = string;
        URL uRL = null;
        try {
            uRL = URLUtil.convertToURL((String)string);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        String string4 = string2 = uRL != null ? uRL.getHost() : null;
        if (string2 != null && MediaObjectsUtil.isRecognizedAsMedia(string2)) {
            if (YOUTUBE_HOST.equals(string2) && string3.contains("/watch?v=")) {
                string3 = string3.replace("/watch?v=", "/embed/");
            } else if (VIMEO_HOST.equals(string2) && string3.contains("/vimeo.com/")) {
                string3 = string3.replace("/vimeo.com/", "/player.vimeo.com/video/");
            }
        }
        return string3;
    }

    public static boolean isAudioReference(String string) {
        String string2 = URLUtil.getExtension((String)string);
        return MediaObjectsUtil.hasAudioFormat(string2);
    }

    public static boolean hasAudioFormat(String string) {
        return string != null && MediaObjectsUtil.containsExtension(string, MEDIA_AUDIO_EXTENSIONS);
    }

    public static boolean isVideoReference(String string) {
        String string2 = URLUtil.getExtension((String)string);
        return MediaObjectsUtil.hasVideoFormat(string2);
    }

    public static boolean hasVideoFormat(String string) {
        return string != null && MediaObjectsUtil.containsExtension(string, MEDIA_VIDEO_EXTENSIONS);
    }
}

