/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api.webapp.plugin;

import java.io.IOException;
import java.text.MessageFormat;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.ServletConfig;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.ServletException;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.http.HttpServletRequest;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.http.HttpServletResponse;
import ro.sync.exml.plugin.PluginExtension;

@API(type=APIType.EXTENDABLE, src=SourceType.PUBLIC)
public abstract class ServletPluginExtension
implements PluginExtension {
    private static final Object METHOD_GET = "GET";
    private static final Object METHOD_POST = "POST";
    private static final Object METHOD_PUT = "PUT";
    private static final Object METHOD_DELETE = "DELETE";
    protected ServletConfig config;

    public abstract String getPath();

    public void init(ServletConfig servletConfig) throws ServletException {
        this.config = servletConfig;
        this.init();
    }

    public void init() throws ServletException {
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getMethod();
        if (string.equals(METHOD_GET)) {
            this.doGet(httpServletRequest, httpServletResponse);
        } else if (string.equals(METHOD_POST)) {
            this.doPost(httpServletRequest, httpServletResponse);
        } else if (string.equals(METHOD_PUT)) {
            this.doPut(httpServletRequest, httpServletResponse);
        } else if (string.equals(METHOD_DELETE)) {
            this.doDelete(httpServletRequest, httpServletResponse);
        } else {
            String string2 = "Not implemented http method";
            Object[] objectArray = new Object[]{string};
            string2 = MessageFormat.format(string2, objectArray);
            httpServletResponse.sendError(501, string2);
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
    }

    public void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
    }

    public void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public boolean requiresAuthorization() {
        return false;
    }
}

