/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api.webapp;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;
import ro.sync.ecss.extensions.api.webapp.WebappMessage;
import ro.sync.ecss.extensions.api.webapp.license.UserNotLicensedException;
import ro.sync.ecss.webapp.BaseAuthorDocumentModel;
import ro.sync.ecss.webapp.ab;
import ro.sync.ecss.webapp.b;
import ro.sync.ecss.webapp.d.k;
import ro.sync.ecss.webapp.d.t;
import ro.sync.ecss.webapp.d.v;

@API(type=APIType.INTERNAL, src=SourceType.PRIVATE)
public abstract class InternalDocumentBuilderBase {
    private static final Logger logger = LoggerFactory.getLogger((String)InternalDocumentBuilderBase.class.getName());
    private static ImmutableMap<String, String> EXTENSION_TO_CONTENT_TYPE = ImmutableMap.of((Object)"json", (Object)"text/json");
    boolean background = false;
    private URL systemId;
    private Map<String, ?> sessionAttributes = Collections.emptyMap();
    private Reader reader;
    private List<Byte> bomBytes;

    public InternalDocumentBuilderBase setBackground(boolean bl) {
        this.background = bl;
        return this;
    }

    public InternalDocumentBuilderBase setSystemId(URL uRL) {
        this.systemId = uRL;
        return this;
    }

    public InternalDocumentBuilderBase setSessionAttributes(Map<String, ?> map) {
        this.sessionAttributes = map;
        return this;
    }

    public InternalDocumentBuilderBase setContent(Reader reader) {
        this.reader = reader;
        this.bomBytes = new ArrayList<Byte>();
        return this;
    }

    public InternalDocumentBuilderBase setContent(Reader reader, List<Byte> list) {
        this.reader = reader;
        this.bomBytes = new ArrayList<Byte>(list);
        return this;
    }

    private String getContentType() {
        String string = (String)this.sessionAttributes.get("contentType");
        String string2 = URLUtil.getExtension((String)this.systemId.getPath());
        String string3 = (String)EXTENSION_TO_CONTENT_TYPE.get((Object)string2);
        return Stream.of(string, string3, "text/xml").filter(Objects::nonNull).findFirst().orElseThrow(IllegalStateException::new);
    }

    public AuthorDocumentModel build() throws SAXException, IOException {
        String string;
        k k2;
        if (this.background) {
            k2 = new BackgroundSessionTracker();
            string = null;
        } else {
            k2 = k.getInstance();
            string = v.e().j();
            if (string == null) {
                logger.debug("No user associated with the current thread");
                throw new UserNotLicensedException();
            }
        }
        b b2 = this.createBuilder();
        if (this.sessionAttributes != null) {
            b2.kb(this.sessionAttributes);
        }
        BaseAuthorDocumentModel baseAuthorDocumentModel = b2.b(k2).z(string).cb(this.systemId).ob(this.getContentType()).ab(this.reader, this.bomBytes);
        if (!this.background) {
            t t2 = k2.sessionCreated(baseAuthorDocumentModel, string);
            InternalDocumentBuilderBase.checkUserLicense(baseAuthorDocumentModel, t2);
            baseAuthorDocumentModel.lockOnOpen();
        }
        return baseAuthorDocumentModel;
    }

    public abstract b createBuilder();

    private static void checkUserLicense(AuthorDocumentModel authorDocumentModel, t t2) {
        try {
            t2.checkLicensed();
        }
        catch (UserNotLicensedException userNotLicensedException) {
            authorDocumentModel.dispose();
            throw userNotLicensedException;
        }
        String string = t2.c();
        if (string != null) {
            ab ab2 = (ab)authorDocumentModel.getMessageProvider();
            ab2.b(new WebappMessage(2, "License expired", string, true));
        }
    }

    public class BackgroundSessionTracker
    extends k {
        @Override
        public synchronized void sessionActivated(ab ab2) {
            throw new IllegalStateException();
        }

        @Override
        public synchronized t sessionCreated(AuthorDocumentModel authorDocumentModel, String string) {
            return null;
        }

        @Override
        public void sessionDestroyed(AuthorDocumentModel authorDocumentModel, String string) {
        }
    }
}

