/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api.component.sync;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;

@API(type=APIType.INTERNAL, src=SourceType.PRIVATE)
public class Resource2Synchronize {
    private URLConnection conn;
    private URL url2Synchronize;
    private long timestamp;
    private int contentLength;

    public Resource2Synchronize(URL uRL) {
        this.url2Synchronize = uRL;
    }

    public URL getURL() {
        return this.url2Synchronize;
    }

    public InputStream getInputStream() throws IOException {
        this.buildConnection();
        return this.conn.getInputStream();
    }

    public long getTimestamp() throws IOException {
        if (this.timestamp <= 0L) {
            this.buildConnection();
            this.timestamp = this.conn.getLastModified();
        }
        return this.timestamp;
    }

    public int getContentLength() throws IOException {
        if (this.contentLength <= 0) {
            this.buildConnection();
            this.contentLength = this.conn.getContentLength();
        }
        return this.contentLength;
    }

    private void buildConnection() throws IOException {
        if (this.conn == null) {
            this.conn = this.url2Synchronize.openConnection();
        }
    }

    public void disconect() {
        if (this.conn != null && this.conn instanceof HttpURLConnection) {
            ((HttpURLConnection)this.conn).disconnect();
        }
    }

    public static Resource2Synchronize[] getResources(URL[] uRLArray) {
        Resource2Synchronize[] resource2SynchronizeArray = new Resource2Synchronize[uRLArray == null ? 0 : uRLArray.length];
        if (uRLArray != null && uRLArray.length > 0) {
            for (int i2 = 0; i2 < resource2SynchronizeArray.length; ++i2) {
                resource2SynchronizeArray[i2] = new Resource2Synchronize(uRLArray[i2]);
            }
        }
        return resource2SynchronizeArray;
    }
}

