/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorOperationStoppedByUserException;
import ro.sync.ecss.extensions.api.ContentInterval;
import ro.sync.ecss.extensions.api.Extension;
import ro.sync.ecss.extensions.api.ExternalObjectInsertionSources;
import ro.sync.ecss.extensions.api.ReferenceType;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.operations.CommonsOperationsUtil;
import ro.sync.util.xslt.URLGetPathFunctionCallDefinition;
import ro.sync.util.xslt.URLNewFunctionCallDefinition;
import ro.sync.util.xslt.URLUtilCopyURLFunctionCallDefinition;
import ro.sync.util.xslt.URLUtilUncorrectFunctionCallDefinition;
import ro.sync.util.xslt.UUIDHashCodeFunctionCallDefinition;
import ro.sync.util.xslt.UUIDRandomUUIDFunctionCallDefinition;
import ro.sync.xml.parser.SecureXMLReader;

@API(type=APIType.EXTENDABLE, src=SourceType.PUBLIC)
public abstract class AuthorExternalObjectInsertionHandler
implements ExternalObjectInsertionSources,
Extension {
    private static final String PASTE_CHECK_CONTENT_PRESERVED_PROPERTY = "checkEntireContentIsFullyPreserved";
    private static final char CONTEXT_PATH_SEPARATOR = ',';
    private static final Logger logger = LoggerFactory.getLogger((String)AuthorExternalObjectInsertionHandler.class.getName());
    private static final String ONLY_TEXT_CONTENT_STYLESHEET_FILE = "resources/onlyTextContent.xsl";
    private static final String DEFAULT_STYLESHEET_CONTENT = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"2.0\"\n    xmlns:xhtml=\"http://www.w3.org/1999/xhtml\" exclude-result-prefixes=\"#all\"\n    xpath-default-namespace=\"http://www.w3.org/1999/xhtml\">\n    <xsl:output omit-xml-declaration=\"yes\"/>\n    <xsl:template match=\"style\"/>\n    <xsl:template match=\"script\"/>\n    <xsl:template match=\"head\"/>\n</xsl:stylesheet>";
    private static final String REMOVE_TFOOT_STYLESHEET_FILE = "resources/removeTfoot.xsl";
    private static Map<String, Object> extraTestParameters;

    public void insertURLs(AuthorAccess authorAccess, List<URL> list, int n2) throws AuthorOperationException {
    }

    public void insertURLs(AuthorAccess authorAccess, List<URL> list, List<ReferenceType> list2, int n2) throws AuthorOperationException {
        this.insertURLs(authorAccess, list, n2);
    }

    public boolean acceptURLs(AuthorAccess authorAccess, List<URL> list, int n2) {
        return this.acceptSource(authorAccess, n2) || AuthorExternalObjectInsertionHandler.containOnlyImages(authorAccess, list) || AuthorExternalObjectInsertionHandler.containOnlyBinaryResources(authorAccess, list);
    }

    public boolean acceptSource(AuthorAccess authorAccess, int n2) {
        boolean bl = n2 == 5 || n2 == 8 || n2 == 7;
        return bl || n2 == 1 || n2 == 0 || n2 == 4 || n2 == 6 || n2 == 3;
    }

    protected static boolean containOnlyImages(AuthorAccess authorAccess, List<URL> list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            URL uRL = list.get(i2);
            if (authorAccess.getUtilAccess().isSupportedImageURL(uRL)) continue;
            return false;
        }
        return true;
    }

    protected static boolean containOnlyBinaryResources(AuthorAccess authorAccess, List<URL> list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            URL uRL = list.get(i2);
            if (authorAccess.getUtilAccess().isUnhandledBinaryResourceURL(uRL)) continue;
            return false;
        }
        return true;
    }

    public void insertXHTMLFragment(AuthorAccess authorAccess, Reader reader) throws AuthorOperationException {
        StreamSource streamSource = this.createImporterStylesheetSource(authorAccess);
        if (streamSource != null) {
            try {
                String string;
                String string2;
                if (logger.isDebugEnabled()) {
                    reader = new LoggerReader(reader);
                }
                if ((string2 = AuthorExternalObjectInsertionHandler.applyAssociatedXSL(authorAccess, string = AuthorExternalObjectInsertionHandler.readInitialXHTMLContent(reader), streamSource, true)).length() > 0) {
                    Map<String, String> map = AuthorExternalObjectInsertionHandler.readExternalPastePreferences(authorAccess);
                    boolean bl = AuthorExternalObjectInsertionHandler.checkInsideTable(authorAccess);
                    if (!bl && ("true".equals(map.get(PASTE_CHECK_CONTENT_PRESERVED_PROPERTY)) || this.checkImportedXHTMLContentIsPreservedEntirely())) {
                        String string3;
                        String string4 = string2;
                        String string5 = string;
                        String string6 = "<(?!\\<)(.*?)tfoot[^<]\\s*+";
                        Pattern pattern = Pattern.compile(string6);
                        Matcher matcher = pattern.matcher(string);
                        boolean bl2 = matcher.find();
                        if (bl2) {
                            string5 = AuthorExternalObjectInsertionHandler.simpleTransform(authorAccess, string5, this.getClassStylesheetResource(AuthorExternalObjectInsertionHandler.class, REMOVE_TFOOT_STYLESHEET_FILE));
                            string4 = AuthorExternalObjectInsertionHandler.applyAssociatedXSL(authorAccess, string5, this.createImporterStylesheetSource(authorAccess), false);
                        }
                        Object object = "<root>" + string4 + "</root>";
                        if (this.getFilterContentOfOutputStylesheet() != null) {
                            object = AuthorExternalObjectInsertionHandler.simpleTransform(authorAccess, (String)object, this.getFilterContentOfOutputStylesheet());
                        }
                        if (AuthorExternalObjectInsertionHandler.testDataIsPreserved((String)(object = AuthorExternalObjectInsertionHandler.simpleTransform(authorAccess, (String)object, this.getOnlyTextContentStylesheet(authorAccess))), string3 = AuthorExternalObjectInsertionHandler.simpleTransform(authorAccess, string5, this.getOnlyTextContentStylesheet(authorAccess)))) {
                            this.insertImportedContent(authorAccess, string2);
                        } else {
                            logger.warn("Initial XHTML to paste: |" + string + "|");
                            String string7 = AuthorExternalObjectInsertionHandler.simpleTransform(authorAccess, string, DEFAULT_STYLESHEET_CONTENT);
                            this.insertImportedContent(authorAccess, string7);
                        }
                    } else {
                        logger.debug("Do not check if content is preserved.");
                        this.insertImportedContent(authorAccess, string2);
                    }
                }
            }
            catch (AuthorOperationStoppedByUserException authorOperationStoppedByUserException) {
            }
            catch (AuthorOperationException authorOperationException) {
                throw authorOperationException;
            }
            catch (Exception exception) {
                logger.debug((Object)exception, (Throwable)exception);
                authorAccess.getWorkspaceAccess().showErrorMessage(exception.getMessage(), exception);
            }
        }
    }

    protected void insertImportedContent(AuthorAccess authorAccess, String string) throws AuthorOperationException {
        authorAccess.getDocumentController().insertXMLFragmentSchemaAware(string, authorAccess.getEditorAccess().getCaretOffset(), 4, true);
    }

    protected StreamSource getOnlyTextContentStylesheet(AuthorAccess authorAccess) {
        return this.getClassStylesheetResource(AuthorExternalObjectInsertionHandler.class, ONLY_TEXT_CONTENT_STYLESHEET_FILE);
    }

    protected StreamSource getClassStylesheetResource(Class clazz, String string) {
        StreamSource streamSource;
        URL uRL = clazz.getResource(string);
        if (uRL != null) {
            streamSource = new StreamSource(uRL.toExternalForm());
        } else {
            logger.error("The '" + string + "' resource cannot be found!");
            streamSource = new StreamSource(new StringReader(DEFAULT_STYLESHEET_CONTENT));
        }
        return streamSource;
    }

    protected StreamSource getFilterContentOfOutputStylesheet() {
        return null;
    }

    public static String simpleTransform(AuthorAccess authorAccess, String string, String string2) throws TransformerException, IOException {
        return AuthorExternalObjectInsertionHandler.simpleTransform(authorAccess, string, new StreamSource(new StringReader(string2)));
    }

    public static String simpleTransform(AuthorAccess authorAccess, String string, StreamSource streamSource) throws TransformerException, IOException {
        Transformer transformer = authorAccess.getXMLUtilAccess().createXSLTTransformer(streamSource, new URL[0], 2, false);
        StringWriter stringWriter = new StringWriter();
        URL uRL = authorAccess.getEditorAccess().getEditorLocation();
        transformer.transform(new StreamSource(new StringReader(string), uRL != null ? uRL.toExternalForm() : null), new StreamResult(stringWriter));
        stringWriter.close();
        return stringWriter.toString();
    }

    private static String applyAssociatedXSL(AuthorAccess authorAccess, String string, StreamSource streamSource, boolean bl) throws TransformerException, MalformedURLException {
        ExtensionFunctionDefinition[] extensionFunctionDefinitionArray = new ExtensionFunctionDefinition[]{new URLUtilUncorrectFunctionCallDefinition(), new URLUtilCopyURLFunctionCallDefinition(), new UUIDRandomUUIDFunctionCallDefinition(), new UUIDHashCodeFunctionCallDefinition(), new URLNewFunctionCallDefinition(), new URLGetPathFunctionCallDefinition()};
        Transformer transformer = authorAccess.getXMLUtilAccess().createSaxon9HEXSLTTransformerWithExtensions(streamSource, extensionFunctionDefinitionArray);
        AuthorExternalObjectInsertionHandler.setParametersToTransform(transformer, authorAccess, bl);
        StringWriter stringWriter = new StringWriter();
        URL uRL = authorAccess.getEditorAccess().getEditorLocation();
        transformer.transform(new StreamSource(new StringReader(string), uRL != null ? uRL.toExternalForm() : null), new StreamResult(stringWriter));
        return stringWriter.toString();
    }

    protected static void setParametersToTransform(Transformer transformer, AuthorAccess authorAccess, boolean bl) {
        String[] stringArray = AuthorExternalObjectInsertionHandler.getContextPathNamesAndUris(authorAccess);
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = null;
        try {
            string3 = AuthorExternalObjectInsertionHandler.getParentURL(authorAccess);
        }
        catch (MalformedURLException malformedURLException) {
            logger.error((Object)malformedURLException, (Throwable)malformedURLException);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("folderOfPasteTargetXml: " + URLUtil.filterPasswords((String)string3));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("context.path.names:" + string);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("context.path.uris:" + string2);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("context.path.separator:,");
        }
        if (AuthorExternalObjectInsertionHandler.checkInsideTable(authorAccess)) {
            transformer.setParameter("inTableContext", "true");
        }
        transformer.setParameter("folderOfPasteTargetXml", string3);
        transformer.setParameter("context.path.names", string);
        transformer.setParameter("context.path.uris", string2);
        transformer.setParameter("context.path.separator", Character.valueOf(','));
        transformer.setParameter("copy.word.image.resources", bl ? Boolean.TRUE : Boolean.FALSE);
        ContentInterval contentInterval = authorAccess.getEditorAccess().getAuthorSelectionModel().getSelectionInterval();
        AuthorElement authorElement = authorAccess.getDocumentController().getAuthorDocumentNode().getRootElement();
        if (contentInterval.getStartOffset() == authorElement.getStartOffset() + 1 && contentInterval.getEndOffset() == authorElement.getEndOffset()) {
            transformer.setParameter("replace.entire.root.contents", Boolean.TRUE);
        }
        if (extraTestParameters != null) {
            for (String string4 : extraTestParameters.keySet()) {
                Object object = extraTestParameters.get(string4);
                transformer.setParameter(string4, object);
            }
        }
    }

    private static boolean checkInsideTable(AuthorAccess authorAccess) {
        boolean bl = false;
        try {
            for (AuthorNode authorNode = authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset()); authorNode != null; authorNode = authorNode.getParent()) {
                if (!authorAccess.getEditorAccess().getStyles(authorNode).isTable()) continue;
                bl = true;
                break;
            }
        }
        catch (Exception exception) {
            logger.error((Throwable)exception);
        }
        return bl;
    }

    static void setExtraXSLTParam(String string, Object object) {
        if (extraTestParameters == null) {
            extraTestParameters = new HashMap<String, Object>();
        }
        if (object == null) {
            extraTestParameters.remove(string);
        } else {
            extraTestParameters.put(string, object);
        }
    }

    static String getParentURL(AuthorAccess authorAccess) throws MalformedURLException {
        URL uRL = authorAccess.getEditorAccess().getEditorLocation();
        String string = uRL.toString();
        int n2 = string.lastIndexOf(47);
        String string2 = null;
        string2 = n2 == -1 ? new File(System.getProperty("user.home")).toURI().toURL().toString() : string.substring(0, n2);
        URL uRL2 = new URL(string2);
        return authorAccess.getUtilAccess().correctURL(uRL2.toString());
    }

    protected static String[] getContextPathNamesAndUris(AuthorAccess authorAccess) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        try {
            AuthorEditorAccess authorEditorAccess = authorAccess.getEditorAccess();
            int n2 = authorEditorAccess.getCaretOffset();
            ArrayList<AuthorNode> arrayList = new ArrayList<AuthorNode>(5);
            for (AuthorNode authorNode = authorAccess.getDocumentController().getNodeAtOffset(n2); authorNode != null; authorNode = authorNode.getParent()) {
                if (authorNode.getParent() == null) continue;
                arrayList.add(0, authorNode);
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                AuthorNode authorNode = (AuthorNode)iterator.next();
                String string = authorNode.getName();
                if (authorNode.getType() == 0) {
                    string = ((AuthorElement)authorNode).getLocalName();
                }
                stringBuilder.append(string);
                stringBuilder2.append(authorNode.getNamespace());
                if (!iterator.hasNext()) continue;
                stringBuilder.append(',');
                stringBuilder2.append(',');
            }
        }
        catch (BadLocationException badLocationException) {
            logger.warn((Object)badLocationException, (Throwable)badLocationException);
        }
        return new String[]{stringBuilder.toString(), stringBuilder2.toString()};
    }

    private static String readInitialXHTMLContent(Reader reader) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = new char[1024];
        int n2 = -1;
        while ((n2 = reader.read(cArray)) != -1) {
            stringBuilder.append(cArray, 0, n2);
        }
        reader.close();
        return stringBuilder.toString();
    }

    protected StreamSource createImporterStylesheetSource(AuthorAccess authorAccess) {
        String string = this.getImporterStylesheetFileName(authorAccess);
        if (logger.isDebugEnabled()) {
            logger.debug("main stylesheet name: " + string);
        }
        return this.getStylesheetResource(authorAccess, string);
    }

    private StreamSource getStylesheetResource(AuthorAccess authorAccess, String string) {
        if (string != null) {
            URL uRL = this.getClass().getClassLoader().getResource(string);
            if (logger.isDebugEnabled()) {
                logger.debug("main stylesheet URL resource: " + uRL);
            }
            if (uRL == null) {
                uRL = CommonsOperationsUtil.locateResourceInClasspath(authorAccess, string);
                if (uRL == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Could not find resource \"" + string + "\" in class loader class path, but found it in a new class loader. Running from classes?");
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug("resource found " + uRL);
                }
            }
            if (uRL == null) {
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (uRL != null) {
                return new StreamSource(uRL.toString());
            }
            String string2 = "Could not find resource \"" + string + "\" in class path.";
            if (logger.isDebugEnabled()) {
                logger.debug(string2);
            }
            logger.error(string2, (Throwable)new Exception());
        }
        return new StreamSource(new StringReader(DEFAULT_STYLESHEET_CONTENT));
    }

    protected String getImporterStylesheetFileName(AuthorAccess authorAccess) {
        return null;
    }

    protected static URL getBaseURLAtCaretPosition(AuthorAccess authorAccess) {
        URL uRL = authorAccess.getEditorAccess().getEditorLocation();
        try {
            AuthorNode authorNode = authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset());
            if (authorNode != null) {
                uRL = authorNode.getXMLBaseURL();
            }
        }
        catch (BadLocationException badLocationException) {
            logger.error((Object)badLocationException, (Throwable)badLocationException);
        }
        return uRL;
    }

    protected boolean checkImportedXHTMLContentIsPreservedEntirely() {
        return false;
    }

    static boolean testDataIsPreserved(String string, String string2) {
        boolean bl = true;
        if (!string.equals(string2)) {
            int n2 = 0;
            int n3 = 0;
            int n4 = string.length();
            int n5 = string2.length();
            while (n2 < n4 || n3 < n5) {
                char c2 = '\u0000';
                boolean bl2 = false;
                while (n2 < n4) {
                    c2 = string.charAt(n2);
                    ++n2;
                    if (Character.isWhitespace(c2) || c2 == '\u00a0') continue;
                    bl2 = true;
                    break;
                }
                char c3 = '\u0000';
                boolean bl3 = false;
                while (n3 < n5) {
                    c3 = string2.charAt(n3);
                    ++n3;
                    if (Character.isWhitespace(c3) || c3 == '\u00a0') continue;
                    bl3 = true;
                    break;
                }
                if (bl2 && bl3) {
                    if (c2 == c3) continue;
                    bl = false;
                    break;
                }
                if (!bl2 && !bl3) break;
                bl = false;
                break;
            }
            if (!bl) {
                logger.warn("-----Problem preserving the XHTML data on paste, reverting to default.------");
                logger.warn("contentProcessedByStylesheets:\n" + string);
                logger.warn("APPLIED XSLS DIFF NOT MATCHING:  " + n2 + "   code: " + string.charAt(n2 - 1) + "  char: " + string.charAt(n2 - 1) + "\n[" + string.substring(n2) + "]");
                logger.warn("ONLY WORDS DIFF NOT MATCHING:" + n3 + "   code: " + string2.charAt(n3 - 1) + "  char: " + string2.charAt(n3 - 1) + "\n[" + string2.substring(n3) + "]");
                logger.warn("Initial Processed pe XSLT content :\n" + string);
                logger.warn("All Words content:\n" + string2);
            }
        }
        return bl;
    }

    @Override
    public String getDescription() {
        return "Author External Object Insertion Handler";
    }

    private static Map<String, String> readExternalPastePreferences(AuthorAccess authorAccess) {
        URL uRL;
        final HashMap<String, String> hashMap = new HashMap<String, String>();
        if (authorAccess != null && (uRL = CommonsOperationsUtil.locateResourceInClasspath(authorAccess, "externalPasteOptions.xml")) != null) {
            XMLReader xMLReader = authorAccess.getXMLUtilAccess().newNonValidatingXMLReader();
            xMLReader.setContentHandler(new ContentHandler(){
                private StringBuilder chars = new StringBuilder();

                @Override
                public void startPrefixMapping(String string, String string2) throws SAXException {
                }

                @Override
                public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                    this.chars.setLength(0);
                }

                @Override
                public void startDocument() throws SAXException {
                }

                @Override
                public void skippedEntity(String string) throws SAXException {
                }

                @Override
                public void setDocumentLocator(Locator locator) {
                }

                @Override
                public void processingInstruction(String string, String string2) throws SAXException {
                }

                @Override
                public void ignorableWhitespace(char[] cArray, int n2, int n3) throws SAXException {
                }

                @Override
                public void endPrefixMapping(String string) throws SAXException {
                }

                @Override
                public void endElement(String string, String string2, String string3) throws SAXException {
                    hashMap.put(string2, this.chars.toString());
                    this.chars.setLength(0);
                }

                @Override
                public void endDocument() throws SAXException {
                }

                @Override
                public void characters(char[] cArray, int n2, int n3) throws SAXException {
                    this.chars.append(cArray, n2, n3);
                }
            });
            try {
                SecureXMLReader.parse(xMLReader, uRL.toString());
            }
            catch (IOException | SAXException exception) {
                logger.debug((Object)exception, (Throwable)exception);
            }
        }
        return hashMap;
    }

    private static class LoggerReader
    extends Reader {
        private Reader reader;
        private StringBuilder loggedContent = new StringBuilder();

        LoggerReader(Reader reader) {
            this.reader = reader;
        }

        @Override
        public int read(char[] cArray, int n2, int n3) throws IOException {
            int n4 = this.reader.read(cArray, n2, n3);
            if (n4 > 0) {
                this.loggedContent.append(cArray, n2, n4);
            }
            return n4;
        }

        @Override
        public void close() throws IOException {
            logger.debug(this.loggedContent.toString());
            this.reader.close();
        }
    }
}

