/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.component.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.undo.UndoManager;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.document.hc;
import ro.sync.document.q;
import ro.sync.ecss.component.editor.db;
import ro.sync.ecss.component.editor.gb;
import ro.sync.ecss.component.editor.lb;
import ro.sync.ecss.extensions.api.CursorType;
import ro.sync.ecss.extensions.api.editor.AbstractInplaceEditor;
import ro.sync.ecss.extensions.api.editor.AuthorInplaceContext;
import ro.sync.ecss.extensions.api.editor.EditingEvent;
import ro.sync.ecss.extensions.api.editor.InplaceRenderer;
import ro.sync.ecss.extensions.api.editor.RendererLayoutInfo;
import ro.sync.ecss.extensions.commons.editor.InplaceEditorUtil;
import ro.sync.exml.view.graphics.Dimension;
import ro.sync.exml.view.graphics.Font;
import ro.sync.exml.view.graphics.Point;
import ro.sync.exml.view.graphics.Rectangle;
import ro.sync.exml.workspace.api.standalone.ui.Button;
import ro.sync.i18n.r;
import ro.sync.ui.calendar.d;
import ro.sync.ui.calendar.f;
import ro.sync.ui.jb;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DatePickerEditor
extends AbstractInplaceEditor
implements InplaceRenderer,
gb {
    private static final Logger wiy = LoggerFactory.getLogger((String)DatePickerEditor.class.getName());
    protected static final ro.sync.i18n.d messages = r.m();
    private String riy = "custom";
    private String uiy;
    private d piy;
    private f viy;
    private java.awt.Font oiy;
    private String tiy;
    private DocumentListener yiy = new DocumentListener(){

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            DatePickerEditor.this.fireEditingOccured();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            DatePickerEditor.this.fireEditingOccured();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            DatePickerEditor.this.fireEditingOccured();
        }
    };
    private KeyAdapter xiy;
    private Color siy;
    private boolean qiy = true;

    public DatePickerEditor() {
        final KeyStroke keyStroke = hc.f();
        this.viy = new f(null){

            @Override
            protected boolean processKeyBinding(KeyStroke keyStroke2, KeyEvent keyEvent, int n2, boolean bl) {
                boolean bl2 = true;
                if (keyStroke.equals(keyStroke2)) {
                    q q2 = hc.e(this.getDocument());
                    bl2 = ((UndoManager)q2).canUndo();
                }
                return bl2 ? super.processKeyBinding(keyStroke2, keyEvent, n2, bl) : false;
            }
        };
        this.piy = new d(null, null, null, this.viy, null);
        ArrayList<Component> arrayList = new ArrayList<Component>(1);
        arrayList.add(this.viy);
        this.piy.setFocusTraversalPolicy(new jb(this.piy, arrayList, this.viy, false));
        this.piy.setFocusTraversalPolicyProvider(true);
        this.xiy = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    keyEvent.consume();
                    DatePickerEditor.this.cancelEditing();
                } else if (keyEvent.getKeyCode() == 10) {
                    keyEvent.consume();
                    DatePickerEditor.this.eup(false, true);
                }
            }
        };
        this.oiy = this.piy.getFont();
        this.siy = this.viy.j();
    }

    @Override
    public String getDescription() {
        return "A date picker.";
    }

    @Override
    public Object getEditorComponent(AuthorInplaceContext authorInplaceContext, Rectangle rectangle, Point point) {
        this.kup(authorInplaceContext, true);
        return this.piy;
    }

    @Override
    public Rectangle getScrollRectangle() {
        return null;
    }

    @Override
    public void requestFocus() {
        this.viy.requestFocus();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getValue() {
        String string = "";
        Date date = this.piy.b();
        if (date != null) {
            if ("xs:date".equals(this.riy)) {
                return new SimpleDateFormat("yyyy-MM-dd").format(date);
            }
            if ("xs:dateTime".equals(this.riy)) {
                return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(date);
            }
            java.util.Date date2 = new java.util.Date(date.getTime());
            try {
                return new SimpleDateFormat(this.uiy).format(date2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!wiy.isDebugEnabled()) return string;
                wiy.debug((Object)illegalArgumentException, (Throwable)illegalArgumentException);
            }
            return string;
        } else {
            if (this.qiy) return string;
            return this.viy.getText();
        }
    }

    private void eup(boolean bl, boolean bl2) {
        this.piy.g();
        this.piy.removeKeyListener(this.xiy);
        this.viy.getDocument().removeDocumentListener(this.yiy);
        if (bl2) {
            this.fireNextEditLocationRequested();
        } else {
            this.fireEditingStopped(new EditingEvent((String)this.getValue(), bl));
        }
    }

    @Override
    public void stopEditing() {
        this.eup(true, false);
    }

    @Override
    public void commitValue() {
        this.fireCommitValue(new EditingEvent((String)this.getValue()));
    }

    @Override
    public void cancelEditing() {
        this.piy.g();
        this.piy.removeKeyListener(this.xiy);
        this.viy.getDocument().removeDocumentListener(this.yiy);
        this.fireEditingCanceled();
    }

    @Override
    public Object getRendererComponent(AuthorInplaceContext authorInplaceContext) {
        this.kup(authorInplaceContext, false);
        return this.piy;
    }

    @Override
    public CursorType getCursorType(AuthorInplaceContext authorInplaceContext, int n2, int n3) {
        return CursorType.CURSOR_NORMAL;
    }

    @Override
    public String getTooltipText(AuthorInplaceContext authorInplaceContext, int n2, int n3) {
        this.kup(authorInplaceContext, false);
        if (this.tiy != null) {
            return this.tiy;
        }
        Component component = this.gup(this.piy, n2, n3);
        if (component instanceof Button) {
            return messages.getString("Click_to_edit");
        }
        return this.viy.getText();
    }

    @Override
    public RendererLayoutInfo getRenderingInfo(AuthorInplaceContext authorInplaceContext) {
        this.kup(authorInplaceContext, false);
        Dimension dimension = InplaceEditorUtil.getPreferredSize(this.piy, authorInplaceContext);
        return new RendererLayoutInfo(db.b(this.viy, dimension.width, dimension.height), dimension);
    }

    private void kup(AuthorInplaceContext authorInplaceContext, boolean bl) {
        this.tiy = null;
        Font font = (Font)authorInplaceContext.getArguments().get("font");
        if (font != null) {
            this.piy.setFont(new java.awt.Font(font.getName(), font.getStyle(), font.getSize()));
        } else {
            this.piy.setFont(this.oiy);
        }
        ro.sync.exml.view.graphics.Color color = (ro.sync.exml.view.graphics.Color)authorInplaceContext.getArguments().get("color");
        if (color != null) {
            this.viy.g(new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()));
        } else {
            this.viy.g(this.siy);
        }
        this.piy.setOpaque(false);
        String string = (String)authorInplaceContext.getArguments().get("validateInput");
        boolean bl2 = this.qiy = string == null ? true : Boolean.valueOf(string);
        if (this.qiy) {
            this.viy.b(true);
        } else {
            this.viy.b(false);
        }
        this.riy = lb.b(authorInplaceContext);
        this.uiy = (String)authorInplaceContext.getArguments().get("format");
        String string2 = ((SimpleDateFormat)DateFormat.getDateInstance(2, this.viy.getLocale())).toPattern();
        if (this.uiy == null) {
            this.uiy = string2;
        }
        this.iup(authorInplaceContext);
        if (bl) {
            this.viy.getDocument().addDocumentListener(this.yiy);
            this.viy.addKeyListener(this.xiy);
            this.viy.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    DatePickerEditor.this.piy.g();
                }
            });
        }
        this.viy.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!DatePickerEditor.this.piy.h()) {
                    DatePickerEditor.this.fireCommitValue(new EditingEvent((String)DatePickerEditor.this.getValue()));
                }
            }
        });
        Dimension dimension = InplaceEditorUtil.getPreferredSize(this.piy, authorInplaceContext);
        this.piy.setBounds(0, 0, dimension.width, dimension.height);
        this.viy.doLayout();
        if (!bl) {
            int n2;
            int n3;
            Component component;
            JButton jButton = this.piy.d();
            ButtonModel buttonModel = jButton.getModel();
            buttonModel.setRollover(false);
            buttonModel.setSelected(false);
            Point point = authorInplaceContext.getRelativeMouseLocation();
            if (point != null && (component = this.gup(this.piy, n3 = point.x, n2 = point.y)) instanceof Button) {
                buttonModel.setRollover(true);
                buttonModel.setSelected(true);
            }
        }
    }

    private Component gup(Component component, int n2, int n3) {
        Component component2 = component.getComponentAt(n2, n3);
        while (component2 != null && component2 != component) {
            component = component2;
            component2 = component.getComponentAt(n2 -= component2.getX(), n3 -= component2.getY());
        }
        return component2;
    }

    private void iup(AuthorInplaceContext authorInplaceContext) {
        String string = ((SimpleDateFormat)DateFormat.getDateInstance(2, this.viy.getLocale())).toPattern();
        Object object = authorInplaceContext.getArguments().get("format");
        String string2 = (String)authorInplaceContext.getArguments().get("initial_value");
        Long l2 = null;
        if ("custom".equals(this.riy)) {
            block17: {
                if (string2 != null) {
                    try {
                        java.util.Date date = new SimpleDateFormat(this.uiy).parse(string2);
                        l2 = date.getTime();
                    }
                    catch (Exception exception) {
                        this.tiy = exception.getMessage() + ". Expected \"" + this.uiy + "\" format.";
                        if (!wiy.isDebugEnabled()) break block17;
                        wiy.debug((Object)exception, (Throwable)exception);
                    }
                }
            }
            this.viy.setDateFormatString(this.uiy);
        } else if ("xs:date".equals(this.riy)) {
            if (string2 != null) {
                try {
                    Calendar calendar = DatatypeConverter.parseDate((String)string2);
                    l2 = calendar.getTimeInMillis();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.tiy = "Invalid date: " + illegalArgumentException.getMessage() + ". Expected the xs:date format.";
                }
            }
            this.viy.setDateFormatString(object != null ? (String)object : string);
        } else if ("xs:dateTime".equals(this.riy)) {
            Object object2;
            if (string2 != null) {
                try {
                    object2 = DatatypeConverter.parseDateTime((String)string2);
                    l2 = ((Calendar)object2).getTimeInMillis();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.tiy = "Invalid date-time: " + illegalArgumentException.getMessage() + ". Expected the xs:dateTime format.";
                }
            }
            object2 = ((SimpleDateFormat)DateFormat.getDateTimeInstance(2, 3)).toPattern();
            this.viy.setDateFormatString((String)(object != null ? (String)object : object2));
        }
        if (l2 != null) {
            this.piy.i(new Date(l2));
        } else {
            this.piy.i(null);
        }
        if (this.tiy != null && string2 != null) {
            this.viy.setText(string2);
        }
    }

    @Override
    public CursorType getCursorType(int n2, int n3) {
        return null;
    }

    @Override
    public void dump(AuthorInplaceContext authorInplaceContext, StringBuilder stringBuilder) {
        this.kup(authorInplaceContext, false);
        stringBuilder.append("value:'").append(this.viy.getText()).append("'");
        stringBuilder.append("color:'").append(this.viy.getForeground()).append("'");
    }

    @Override
    public void refresh(AuthorInplaceContext authorInplaceContext) {
        this.iup(authorInplaceContext);
    }

    @Override
    public boolean insertContent(String string) {
        boolean bl = false;
        try {
            this.viy.getDocument().insertString(this.viy.getCaretPosition(), string, null);
            bl = true;
        }
        catch (BadLocationException badLocationException) {
            wiy.error((Object)badLocationException, (Throwable)badLocationException);
        }
        return bl;
    }
}

