/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.diff.merge.trackchange.script;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.io.IOUtil;
import ro.sync.basic.io.NonCloseableReader;
import ro.sync.basic.util.PlatformDetector;
import ro.sync.basic.util.URLUtil;
import ro.sync.diff.api.AuthorDiffChangeTrackingMergerFactory;
import ro.sync.diff.api.DiffException;
import ro.sync.diff.api.DiffOptions;
import ro.sync.diff.script.b;
import ro.sync.diff.ui.files.fb;
import ro.sync.exml.editor.og;
import ro.sync.xml.encoding.EncodingDetector;

@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
public class MergeFilesWithChangeTrackingHighlights {
    protected static final String[] d = new String[]{"-base", "pathOfBaseFile", "Mandatory argument that specifies the path of the base file (it can also be provided as a URL).\n"};
    protected static final String[] b = new String[]{"-ftmw", "pathOfFileToMergeWith", "Mandatory argument that specifies the path of the file to merge with (it can also be provided as a URL).\n"};
    protected static final String[] g = new String[]{"-outf", "pathOfOutFile", "Optional argument that specifies the path of the file where the merge operation results are saved to (it can also be provided as a URL). If present, it must appear immediately after the first two mandatory arguments. If absent, the merge results are saved to the base file, by overwriting it. You cannot choose the same file specified as the file to merge with as the output file, the merge process is aborted in such case. Also, if the output is a remote resource, its entire parent directory structure must already exist, otherwise an I/O exception is thrown and the merge results cannot be saved.\n"};
    protected static final String[] h = new String[]{"-nb", "noBackupOfBaseFile", "Set to \"true\" if do not want a backup copy of the base file on the hard disk. There are 2 situations when a backup of the base file is performed automatically and the backup operation must succeed to proceed with the merge (otherwise, the merge process is aborted): if the output file is not specified (i.e. \"pathOfOutFile\" argument is not present), or the specified output file is the base file itself. The backup copy will have the same parent directory as the base directory and its name will be the name of the base file suffixed by \".OXY.BAK\". Default value = \"false\", which means that, for any of the 2 previously mentioned situations, a backup copy of the base file will be kept on the hard disk. Note that the backup copy can be deleted only if the base file and, implicitly, its backup copy are local resources, not remote.\n"};
    protected static final String f = "\nAdditional notes:\n For Boolean arguments, it is not necessary to provide the \"true\" value. Their presence in the argument list is equivalent to setting their value to \"true\" (and their absence from the argument list is equivalent to setting their value to \"false\"). However, constructs of the form \"bool_option true|false\" are accepted and interpreted accordingly.\n";
    protected static final String e = "-help | --help | -h | --h";
    protected static final String c = ".OXY.BAK";

    private static void e() {
        System.out.println("Script for merging 2 XML files with change tracking highlights, using the Oxygen Diff Files 2-Way Comparator and Oxygen XML File Merger\n");
        char c2 = ' ';
        String string = " = ";
        StringBuilder stringBuilder = new StringBuilder(c2);
        stringBuilder.append(d[1]).append(c2).append(b[1]).append(c2).append('[');
        stringBuilder.append('[').append(g[1]).append("] ");
        List<String[]> list = MergeFilesWithChangeTrackingHighlights.d();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String[] stringArray = list.get(i2);
            stringBuilder.append(i2 > 0 ? Character.valueOf(c2) : "").append('[').append(stringArray[0]).append(c2).append(stringArray[1]).append(']');
        }
        stringBuilder.append(']').append(c2).append('[').append(e).append(']');
        System.out.println((PlatformDetector.isWin() ? "mergeFilesTrackChanges.bat " : "sh mergeFilesTrackChanges.sh ") + stringBuilder.toString());
        stringBuilder = new StringBuilder("\nWhere:\n");
        stringBuilder.append(c2).append(d[1]).append(string).append(d[2]);
        stringBuilder.append(c2).append(b[1]).append(string).append(b[2]);
        stringBuilder.append(c2).append(g[1]).append(string).append(g[2]);
        for (String[] stringArray : list) {
            stringBuilder.append(c2).append(stringArray[0]).append(c2).append(stringArray[1]).append(string).append(stringArray[2]);
        }
        stringBuilder.append(c2).append(e).append(string).append("shows this help text.");
        stringBuilder.append('\n').append(f);
        System.out.println(stringBuilder.toString());
    }

    private static List<String[]> d() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        arrayList.add(h);
        return arrayList;
    }

    private static Map<String, String> f(String[] stringArray) {
        HashMap<String, String> hashMap = null;
        if (stringArray.length > 1) {
            hashMap = new HashMap<String, String>();
            hashMap.put(d[0], stringArray[0]);
            hashMap.put(b[0], stringArray[1]);
            if (stringArray.length > 2) {
                hashMap.putAll(ro.sync.diff.script.b.j(stringArray, g[0], MergeFilesWithChangeTrackingHighlights.d()));
            }
        }
        return hashMap;
    }

    private static void h(Map<String, String> map) {
        if (map == null) {
            System.err.println("ERROR: Wrong argument list. At least the file paths must be provided.\n");
            System.exit(1);
        } else if (map.size() > 2) {
            MergeFilesWithChangeTrackingHighlights.c(map);
        }
    }

    private static void c(Map<String, String> map) {
        ro.sync.diff.script.b.f(map, h[0], "No backup of base file");
    }

    private static URL b(String string) throws _b {
        URL uRL = URLUtil.convertToURL((String)string);
        if (uRL == null) {
            throw new _b("ERROR: File not found: " + string);
        }
        String string2 = uRL.getProtocol();
        if ("file".equals(string2)) {
            File file = URLUtil.getCanonicalFileFromFileUrl((URL)uRL);
            String string3 = null;
            try {
                string3 = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                string3 = string;
            }
            if (!file.exists()) {
                throw new _b("ERROR: File not found: " + string3);
            }
            if (file.isDirectory()) {
                throw new _b("ERROR: Directory path specified instead of file path" + string3);
            }
        }
        return uRL;
    }

    protected static boolean g(String[] stringArray) {
        Object object;
        boolean bl = false;
        URL uRL = null;
        Map<String, String> map = MergeFilesWithChangeTrackingHighlights.f(stringArray);
        MergeFilesWithChangeTrackingHighlights.h(map);
        try {
            Object object2;
            URL uRL2;
            object = map.get(d[0]);
            URL uRL3 = MergeFilesWithChangeTrackingHighlights.b((String)object);
            String string = map.get(b[0]);
            URL uRL4 = MergeFilesWithChangeTrackingHighlights.b(string);
            String string2 = map.get(g[0]);
            URL uRL5 = uRL2 = string2 != null ? URLUtil.convertToURL((String)string2) : null;
            if (PlatformDetector.isWin() ? string.equalsIgnoreCase(string2) : string.equals(string2)) {
                throw new _b("ERROR: Not allowed to specify the file to merge with as the output file");
            }
            if (string2 == null || (PlatformDetector.isWin() ? ((String)object).equalsIgnoreCase(string2) : ((String)object).equals(string2))) {
                uRL = URLUtil.convertToURL((String)((String)object + c));
                uRL2 = uRL3;
                try {
                    URLUtil.copyURL((URL)uRL3, (URL)uRL);
                }
                catch (IOException iOException) {
                    throw new _b("ERROR: Failed to backup the base file: " + iOException.getMessage());
                }
            }
            Reader reader = null;
            try {
                reader = AuthorDiffChangeTrackingMergerFactory.createChangeTrackingMergePerformer().getMergeResultsReader(uRL3, null, uRL4, null, new DiffOptions());
            }
            catch (DiffException diffException) {
                throw new _b("ERROR: Failed to perform the merge operation: " + diffException.getMessage());
            }
            if (string2 != null && uRL == null && (object2 = URLUtil.getFileFromFileUrl((URL)uRL2, (boolean)true, (boolean)false, (boolean)false)) != null) {
                boolean bl2 = true;
                File file = ((File)object2).getParentFile();
                if (!file.exists()) {
                    bl2 = file.mkdirs();
                }
                if (!bl2) {
                    throw new _b("ERROR: Could not create the parent directory structure for the output file: " + ((File)object2).getAbsolutePath());
                }
            }
            try {
                object2 = new BufferedWriter(new OutputStreamWriter(URLUtil.openOutputStream((URL)uRL2), fb.f((NonCloseableReader)reader, new ArrayList<Byte>(), EncodingDetector.getInstance().getJavaEncodingFromContentType(og.p(uRL2.toExternalForm())))));
                try {
                    ((Writer)object2).write(IOUtil.read((Reader)reader).toString());
                }
                finally {
                    ((BufferedWriter)object2).close();
                }
            }
            catch (IOException iOException) {
                throw new _b("ERROR: Could not create the output file: " + iOException.getMessage());
            }
        }
        catch (_b _b2) {
            bl = true;
            System.err.println(_b2.getMessage());
        }
        if (!bl && uRL != null && Boolean.TRUE.equals(Boolean.valueOf(map.get(h[0]))) && (object = URLUtil.getFileFromFileUrl(uRL, (boolean)true, (boolean)false, (boolean)false)) != null) {
            try {
                Files.delete(((File)object).toPath());
            }
            catch (IOException iOException) {
                bl = true;
                System.err.println("ERROR: Could not delete the backup copy of the base file: " + iOException.getMessage());
            }
        }
        return !bl;
    }

    public static void main(String[] stringArray) {
        ro.sync.diff.script.b.c("Merge files with change tracking highlights");
        if (stringArray.length == 1 && ro.sync.util.fb.b(stringArray[0])) {
            MergeFilesWithChangeTrackingHighlights.e();
            System.exit(0);
        }
        System.exit(MergeFilesWithChangeTrackingHighlights.g(stringArray) ? 0 : 1);
    }

    protected static class _b
    extends Exception {
        protected static final String h = "ERROR: ";
        protected static final String b = "ERROR: File not found: ";
        protected static final String c = "ERROR: Directory path specified instead of file path";
        protected static final String g = "ERROR: Not allowed to specify the file to merge with as the output file";
        protected static final String d = "ERROR: Failed to backup the base file: ";
        protected static final String f = "ERROR: Could not create the parent directory structure for the output file: ";
        protected static final String e = "ERROR: Could not create the output file: ";
        protected static final String i = "ERROR: Failed to perform the merge operation: ";
        protected static final String j = "ERROR: Could not delete the backup copy of the base file: ";

        protected _b(String string) {
            super(string);
        }
    }
}

