/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.db.core;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.util.Equaler;
import ro.sync.basic.util.PlatformDetector;
import ro.sync.basic.util.URLUtil;
import ro.sync.g.c;
import ro.sync.i18n.d;
import ro.sync.i18n.r;
import ro.sync.options.InvalidPersistentObjException;
import ro.sync.options.PersistentObject;
import ro.sync.util.Resource;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class DBSourceDriverInfo
implements PersistentObject {
    private static final Logger logger = LoggerFactory.getLogger((String)DBSourceDriverInfo.class.getName());
    private String driverName = null;
    public static final String GENERIC_JDBC = "Generic JDBC";
    public static final int JDBC_TYPE = 0;
    public static final int NXD_TYPE = 1;
    public static final int JDBC_NXD_TYPE = 2;
    public static final int WEBDAV_TYPE = 3;
    public static final int DOCUMENTUM_CMS_TYPE = 4;
    public static final int SHAREPOINT_TYPE = 5;
    public static final int SHAREPOINT_ONLINE_TYPE = 6;
    private String driverType = "JDBC";
    private String driverClassName;
    private URL[] driverLibraries;
    public static final String JDBC_ODBC_BRIDGE = "JDBC-ODBC Bridge";
    private static final String WEBDAV = "WebDAV FTP";
    public static final DBSourceDriverInfo WEBDAV_FTP_DATASOURCE = new DBSourceDriverInfo("WebDAV FTP", "WebDAV FTP", null, null);
    public static final DBSourceDriverInfo SHAREPOINT_DATASOURCE = new DBSourceDriverInfo("SharePoint", "SharePoint", null, null);
    public static final DBSourceDriverInfo SHAREPOINT_ONLINE_DATASOURCE = new DBSourceDriverInfo("SharePoint Online", "SharePoint Online", null, null);
    public static final DBSourceDriverInfo XQJ_DATASOURCE = new DBSourceDriverInfo("XQuery API for Java(XQJ)", "XQuery API for Java(XQJ)", null, null);
    private boolean isPreconfiguredDataSource = false;

    public DBSourceDriverInfo() {
    }

    public DBSourceDriverInfo(String string, String string2, String string3, URL[] uRLArray) {
        this.driverType = string;
        this.driverName = string2;
        this.driverClassName = string3;
        this.driverLibraries = uRLArray;
    }

    public String getDriverType() {
        if (this.isPreconfiguredDataSource && "WebDAV".equals(this.driverType)) {
            this.driverType = WEBDAV;
        }
        return this.driverType;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String string) {
        this.driverName = string;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String string) {
        this.driverClassName = string;
    }

    public URL[] getDriverLibraries() {
        return this.driverLibraries;
    }

    public void setDriverLibraries(URL[] uRLArray) {
        this.driverLibraries = uRLArray;
    }

    public String toString() {
        return this.getDriverName();
    }

    public static DBSourceDriverInfo[] getDefaultJDBCDrivers() {
        Object object;
        Serializable serializable;
        Object object2;
        Vector<Object> vector = new Vector<Object>();
        URL[] uRLArray = new URL[1];
        if (PlatformDetector.isWin()) {
            try {
                object2 = "sun.jdbc.odbc.JdbcOdbcDriver";
                Class.forName((String)object2);
                try {
                    serializable = Resource.getResource("/java/lang/Class.class");
                    object = serializable.getFile();
                    object = ((String)object).substring(0, ((String)object).length() - "!/java/lang/Class.class".length());
                    uRLArray[0] = URLUtil.correct((URL)new URL((String)object));
                    DBSourceDriverInfo dBSourceDriverInfo = new DBSourceDriverInfo("JDBC", JDBC_ODBC_BRIDGE, (String)object2, uRLArray);
                    dBSourceDriverInfo.isPreconfiguredDataSource = true;
                    vector.add(dBSourceDriverInfo);
                }
                catch (MalformedURLException malformedURLException) {}
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        uRLArray = new URL[1];
        object2 = WEBDAV_FTP_DATASOURCE;
        ((DBSourceDriverInfo)object2).isPreconfiguredDataSource = true;
        vector.add(object2);
        serializable = SHAREPOINT_DATASOURCE;
        ((DBSourceDriverInfo)serializable).isPreconfiguredDataSource = true;
        vector.add(serializable);
        object = SHAREPOINT_ONLINE_DATASOURCE;
        ((DBSourceDriverInfo)object).isPreconfiguredDataSource = true;
        vector.add(object);
        return vector.toArray(new DBSourceDriverInfo[0]);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof DBSourceDriverInfo) {
            DBSourceDriverInfo dBSourceDriverInfo = (DBSourceDriverInfo)object;
            bl = Equaler.verifyEquals((Object)this.driverName, (Object)dBSourceDriverInfo.getDriverName());
        }
        return bl;
    }

    public int hashCode() {
        int n2 = 1;
        if (this.driverName != null) {
            n2 = this.driverName.hashCode();
        }
        return n2;
    }

    @Override
    public void checkValid() throws InvalidPersistentObjException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.driverName == null) {
            stringBuffer.append("driver name");
        }
        if ("JDBC".equals(this.driverType)) {
            if (this.driverClassName == null) {
                stringBuffer.append(", driver class name");
            }
            if (this.driverLibraries == null || this.driverLibraries.length == 0) {
                stringBuffer.append(", driver libraries");
            }
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.insert(0, "Invalid JDBC driver because: ");
            stringBuffer.append(" are missing.");
            throw new InvalidPersistentObjException(stringBuffer.toString());
        }
    }

    public void setDriverType(String string) {
        this.driverType = string;
    }

    public void isAcceptedByCurrentEdition() throws _b {
        DBSourceDriverInfo.isAcceptedByCurrentEdition(this.getDriverType());
    }

    public static void isAcceptedByCurrentEdition(String string) throws _b {
        d d2 = r.m();
        boolean bl = false;
        try {
            bl = "true".equals(System.getenv("com.oxygenxml.dita.ot.process"));
        }
        catch (SecurityException securityException) {
            logger.error("Not enough rights to read the env ", (Throwable)securityException);
        }
        if (c.n().i() == null && !bl) {
            throw new _b(d2.getString("Not_licensed"));
        }
        if (!(c.n().b() || "JDBC".equals(string) || "Postgres".equals(string) || "eXist".equals(string) || "XQuery API for Java(XQJ)".equals(string) || WEBDAV.equals(string))) {
            throw new _b(string + ":\n" + d2.getString("Database_driver_available_only_in_enterprise") + ".");
        }
    }

    public boolean isPreconfiguredDataSource() {
        return this.isPreconfiguredDataSource;
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    @Override
    public Object clone() {
        DBSourceDriverInfo dBSourceDriverInfo = null;
        try {
            dBSourceDriverInfo = (DBSourceDriverInfo)super.clone();
            if (this.driverLibraries != null) {
                dBSourceDriverInfo.driverLibraries = (URL[])this.driverLibraries.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error((Object)cloneNotSupportedException, (Throwable)cloneNotSupportedException);
        }
        return dBSourceDriverInfo;
    }

    public DBSourceDriverInfo copy() {
        DBSourceDriverInfo dBSourceDriverInfo = (DBSourceDriverInfo)this.clone();
        dBSourceDriverInfo.isPreconfiguredDataSource = false;
        return dBSourceDriverInfo;
    }

    public static int getDriverKind(String string) {
        if (GENERIC_JDBC.equals(string)) {
            return 0;
        }
        if ("DB2".equals(string) || "SQLServer".equals(string) || "Postgres".equals(string) || "Oracle".equals(string) || "XQuery API for Java(XQJ)".equals(string)) {
            return 2;
        }
        if (WEBDAV.equals(string)) {
            return 3;
        }
        if ("SharePoint".equals(string)) {
            return 5;
        }
        if ("SharePoint Online".equals(string)) {
            return 6;
        }
        return 1;
    }

    public static boolean hasDriverClass(int n2) {
        return n2 == 2 || n2 == 0;
    }

    public static class _b
    extends Exception {
        public _b(String string) {
            super(string);
        }
    }
}

