/*
 * Decompiled with CFR 0.152.
 */
package org.ditang.relaxng.defaults;

import com.thaiopensource.resolver.BasicResolver;
import com.thaiopensource.resolver.Identifier;
import com.thaiopensource.resolver.Input;
import com.thaiopensource.resolver.Resolver;
import com.thaiopensource.resolver.ResolverException;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLResourceIdentifierImpl;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParseException;
import org.ditang.relaxng.defaults.LoggerUtil;
import org.ditang.relaxng.defaults.RNCDefaultValues;
import org.ditang.relaxng.defaults.RNGDefaultValues;
import org.ditang.relaxng.defaults.RelaxNGDefaultValues;
import org.ditang.relaxng.defaults.Util;
import org.slf4j.Logger;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;
import ro.sync.xml.parser.i;

public class RelaxNGDefaultsComponent
implements XMLDocumentHandler,
XMLComponent,
XMLDocumentSource {
    public static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    private static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    private static final String ERROR_HANDLER = "http://apache.org/xml/properties/internal/error-handler";
    private static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    private static final String[] RECOGNIZED_FEATURES = new String[0];
    private static final Boolean[] FEATURE_DEFAULTS = new Boolean[0];
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/symbol-table", "http://apache.org/xml/properties/internal/error-reporter", "http://apache.org/xml/properties/internal/error-handler", "http://apache.org/xml/properties/internal/entity-resolver"};
    private static final Object[] PROPERTY_DEFAULTS = new Object[]{null, null, null, null};
    private XMLDocumentHandler documentHandler;
    private XMLDocumentSource documentSource;
    private boolean detecting = false;
    private String schema = null;
    private String type = null;
    private String baseSystemId = null;
    private RelaxNGDefaultValues defaults;
    private NamespaceContext context;
    private SymbolTable fSymbolTable;
    private XMLEntityResolver fResolver;
    private Resolver resolver;
    private XMLGrammarPool grammarPool;
    private boolean validate = false;
    private Validator validator;
    private static final String RNG_XML_TYPE = "xml";
    private static final String RNG_COMPACT_TYPE = "compact";
    private XMLLocator locator;
    private XMLErrorHandler errorHandler;
    private final Stack<Set<String>> prefixMappingStack = new Stack();
    private static final String NS_MAPPING_DEFAULT = "xmlns";
    private static final String NS_MAPPING_PREFIX = "xmlns:";
    private static Logger logger;

    public RelaxNGDefaultsComponent(Resolver resolver, XMLGrammarPool xMLGrammarPool) {
        this.resolver = resolver;
        this.grammarPool = xMLGrammarPool;
        if (this.resolver == null) {
            this.resolver = new Resolver(){

                public void resolve(Identifier identifier, Input input) throws IOException, ResolverException {
                    if (RelaxNGDefaultsComponent.this.fResolver != null) {
                        String string = identifier.getUriReference();
                        try {
                            string = new URL(new URL(identifier.getBase()), identifier.getUriReference()).toString();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        XMLResourceIdentifierImpl xMLResourceIdentifierImpl = new XMLResourceIdentifierImpl(null, identifier.getUriReference(), identifier.getBase(), string);
                        XMLInputSource xMLInputSource = RelaxNGDefaultsComponent.this.fResolver.resolveEntity((XMLResourceIdentifier)xMLResourceIdentifierImpl);
                        if (xMLInputSource != null) {
                            input.setUri(xMLInputSource.getSystemId());
                            input.setByteStream(xMLInputSource.getByteStream());
                            input.setCharacterStream(xMLInputSource.getCharacterStream());
                            input.setEncoding(xMLInputSource.getEncoding());
                        }
                    }
                }

                public void open(Input input) throws IOException, ResolverException {
                    BasicResolver.getInstance().open(input);
                }
            };
        }
    }

    public void reset(XMLComponentManager xMLComponentManager) throws XMLConfigurationException {
        this.baseSystemId = null;
        this.detecting = false;
        this.schema = null;
        this.type = null;
        this.context = null;
        this.defaults = null;
        this.validator = null;
        this.prefixMappingStack.clear();
        this.locator = null;
        this.fSymbolTable = (SymbolTable)xMLComponentManager.getProperty(SYMBOL_TABLE);
        this.fResolver = (XMLEntityResolver)xMLComponentManager.getProperty(ENTITY_RESOLVER);
    }

    public void startDocument(XMLLocator xMLLocator, String string, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
        this.locator = xMLLocator;
        this.context = namespaceContext;
        this.baseSystemId = xMLLocator.getBaseSystemId();
        this.detecting = true;
        this.schema = null;
        this.type = null;
        if (this.documentHandler != null) {
            this.documentHandler.startDocument(xMLLocator, string, namespaceContext, augmentations);
        }
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        boolean bl = this.detecting;
        this.onStartElement(qName, xMLAttributes);
        if (this.documentHandler != null) {
            this.documentHandler.startElement(qName, xMLAttributes, augmentations);
        }
        if (this.validator != null) {
            try {
                if (this.detecting != bl) {
                    this.triggerStartDocumentToValidator();
                }
                this.startElementToValidator(qName, xMLAttributes);
            }
            catch (SAXException sAXException) {
                throw new XNIException((Exception)sAXException);
            }
        }
    }

    private void startElementToValidator(QName qName, XMLAttributes xMLAttributes) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        HashSet<String> hashSet = null;
        int n2 = xMLAttributes.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = xMLAttributes.getQName(i2);
            if (string.startsWith(NS_MAPPING_PREFIX) || string.equals(NS_MAPPING_DEFAULT)) {
                String string2;
                if (hashSet == null) {
                    hashSet = new HashSet<String>();
                }
                if ((string2 = xMLAttributes.getValue(i2)) == null) {
                    string2 = "";
                }
                String string3 = "";
                if (string.startsWith(NS_MAPPING_PREFIX)) {
                    string3 = string.substring(NS_MAPPING_PREFIX.length());
                }
                this.validator.getContentHandler().startPrefixMapping(string3, string2);
                hashSet.add(string3);
                continue;
            }
            attributesImpl.addAttribute(xMLAttributes.getURI(i2) != null ? xMLAttributes.getURI(i2) : "", xMLAttributes.getLocalName(i2), xMLAttributes.getQName(i2), xMLAttributes.getType(i2), xMLAttributes.getValue(i2));
        }
        this.prefixMappingStack.push(hashSet);
        this.validator.getContentHandler().startElement(qName.uri != null ? qName.uri : "", qName.localpart, qName.rawname, attributesImpl);
    }

    private void triggerStartDocumentToValidator() throws SAXException {
        if (this.locator != null) {
            this.validator.getContentHandler().setDocumentLocator(new Locator(){

                @Override
                public String getSystemId() {
                    return RelaxNGDefaultsComponent.this.locator.getExpandedSystemId();
                }

                @Override
                public String getPublicId() {
                    return RelaxNGDefaultsComponent.this.locator.getPublicId();
                }

                @Override
                public int getLineNumber() {
                    return RelaxNGDefaultsComponent.this.locator.getLineNumber();
                }

                @Override
                public int getColumnNumber() {
                    return RelaxNGDefaultsComponent.this.locator.getColumnNumber();
                }
            });
        }
        this.validator.getContentHandler().startDocument();
    }

    private void onStartElement(QName qName, XMLAttributes xMLAttributes) {
        if (this.detecting) {
            this.detecting = false;
            if ("http://relaxng.org/ns/structure/1.0".equals(qName.uri)) {
                this.defaults = null;
            } else {
                this.loadDefaults();
            }
        }
        if (this.defaults != null) {
            this.checkAndAddDefaults(qName, xMLAttributes);
        }
    }

    private void loadDefaults() {
        block15: {
            ErrorHandler errorHandler = new ErrorHandler(){

                @Override
                public void warning(SAXParseException sAXParseException) throws SAXException {
                    if (RelaxNGDefaultsComponent.this.validate) {
                        if (RelaxNGDefaultsComponent.this.errorHandler != null) {
                            RelaxNGDefaultsComponent.this.errorHandler.warning("", "", new XMLParseException(RelaxNGDefaultsComponent.this.locator, sAXParseException.getMessage(), (Exception)sAXParseException));
                        } else {
                            throw sAXParseException;
                        }
                    }
                    if (RelaxNGDefaultsComponent.getLogger().isDebugEnabled()) {
                        RelaxNGDefaultsComponent.getLogger().debug(String.valueOf(sAXParseException), (Throwable)sAXParseException);
                    }
                }

                @Override
                public void error(SAXParseException sAXParseException) throws SAXException {
                    if (RelaxNGDefaultsComponent.this.validate) {
                        if (RelaxNGDefaultsComponent.this.errorHandler != null) {
                            RelaxNGDefaultsComponent.this.errorHandler.error("", "", new XMLParseException(RelaxNGDefaultsComponent.this.locator, sAXParseException.getMessage(), (Exception)sAXParseException));
                        } else {
                            throw sAXParseException;
                        }
                    }
                    if (RelaxNGDefaultsComponent.getLogger().isDebugEnabled()) {
                        RelaxNGDefaultsComponent.getLogger().debug(String.valueOf(sAXParseException), (Throwable)sAXParseException);
                    }
                }

                @Override
                public void fatalError(SAXParseException sAXParseException) throws SAXException {
                    if (RelaxNGDefaultsComponent.this.validate) {
                        if (RelaxNGDefaultsComponent.this.errorHandler != null) {
                            RelaxNGDefaultsComponent.this.errorHandler.fatalError("", "", new XMLParseException(RelaxNGDefaultsComponent.this.locator, sAXParseException.getMessage(), (Exception)sAXParseException));
                        } else {
                            throw sAXParseException;
                        }
                    }
                    if (RelaxNGDefaultsComponent.getLogger().isDebugEnabled()) {
                        RelaxNGDefaultsComponent.getLogger().debug(String.valueOf(sAXParseException), (Throwable)sAXParseException);
                    }
                }
            };
            if (this.schema != null && (RNG_XML_TYPE.equals(this.type) || RNG_COMPACT_TYPE.equals(this.type))) {
                Object object;
                Input input;
                block14: {
                    Identifier identifier = new Identifier(this.schema, this.baseSystemId);
                    input = new Input();
                    try {
                        this.resolver.resolve(identifier, input);
                    }
                    catch (ResolverException | IOException throwable) {
                        if (!RelaxNGDefaultsComponent.getLogger().isDebugEnabled()) break block14;
                        RelaxNGDefaultsComponent.getLogger().debug(String.valueOf(throwable), throwable);
                    }
                }
                InputSource inputSource = null;
                if (input.isResolved()) {
                    inputSource = new InputSource(input.getUri());
                    inputSource.setByteStream(input.getByteStream());
                    inputSource.setCharacterStream(input.getCharacterStream());
                    inputSource.setEncoding(input.getEncoding());
                } else {
                    object = this.schema;
                    try {
                        object = new URL(new URL(this.baseSystemId), this.schema).toString();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    inputSource = new InputSource((String)object);
                }
                try {
                    RelaxNGDefaultValues relaxNGDefaultValues;
                    object = null;
                    if (this.grammarPool instanceof i) {
                        object = (i)this.grammarPool;
                    }
                    RelaxNGDefaultValues relaxNGDefaultValues2 = relaxNGDefaultValues = object != null ? object.b(inputSource.getSystemId()) : null;
                    if (relaxNGDefaultValues != null && (relaxNGDefaultValues.isKeepSchema() || !this.validate)) {
                        this.defaults = relaxNGDefaultValues;
                    } else {
                        this.defaults = RNG_XML_TYPE.equals(this.type) ? new RNGDefaultValues(this.resolver, errorHandler, this.validate) : new RNCDefaultValues(this.resolver, errorHandler, this.validate);
                        this.defaults.update(inputSource);
                        if (object != null && !this.defaults.hasUpdateErrors()) {
                            object.c(inputSource.getSystemId(), this.defaults);
                        }
                    }
                    if (this.validate && this.defaults != null) {
                        PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder();
                        propertyMapBuilder.put(ValidateProperty.RESOLVER, (Object)this.resolver);
                        propertyMapBuilder.put(ValidateProperty.ERROR_HANDLER, (Object)errorHandler);
                        this.validator = this.defaults.createValidator(propertyMapBuilder.toPropertyMap());
                    }
                }
                catch (Exception exception) {
                    if (!RelaxNGDefaultsComponent.getLogger().isDebugEnabled()) break block15;
                    RelaxNGDefaultsComponent.getLogger().debug(String.valueOf(exception), (Throwable)exception);
                }
            }
        }
    }

    private void checkAndAddDefaults(QName qName, XMLAttributes xMLAttributes) {
        List<RelaxNGDefaultValues.Attribute> list = this.defaults.getDefaultAttributes(qName.localpart, qName.uri);
        if (list != null) {
            for (RelaxNGDefaultValues.Attribute attribute : list) {
                boolean bl = false;
                boolean bl2 = bl = xMLAttributes.getIndex(attribute.namespace, attribute.localName) >= 0;
                if (!bl && "".equals(attribute.namespace)) {
                    boolean bl3 = bl = xMLAttributes.getIndex(null, attribute.localName) >= 0;
                }
                if (bl) continue;
                Object object = null;
                Object object2 = attribute.localName;
                if (attribute.namespace != null && attribute.namespace.length() > 0) {
                    String string;
                    int n2;
                    object = this.context.getPrefix(attribute.namespace);
                    if (object == null) {
                        for (n2 = 0; n2 < xMLAttributes.getLength(); ++n2) {
                            string = xMLAttributes.getQName(n2);
                            if (!string.startsWith(NS_MAPPING_PREFIX) || !attribute.namespace.equals(xMLAttributes.getValue(n2))) continue;
                            object = string.substring(6);
                        }
                    }
                    if (object != null && ((String)object).length() > 0) {
                        object2 = (String)object + ":" + attribute.localName;
                        if (xMLAttributes.getIndex((String)object2) >= 0) continue;
                        QName qName2 = new QName(this.fSymbolTable.addSymbol((String)object), this.fSymbolTable.addSymbol(attribute.localName), this.fSymbolTable.addSymbol((String)object2), this.fSymbolTable.addSymbol(attribute.namespace));
                        xMLAttributes.addAttribute(qName2, "CDATA", attribute.value);
                        int n3 = xMLAttributes.getIndex(qName2.uri, qName2.localpart);
                        xMLAttributes.setSpecified(n3, false);
                        continue;
                    }
                    n2 = 1;
                    object = "http://dita.oasis-open.org/architecture/2005/".equals(attribute.namespace) ? "ditaarch" : "ns" + n2;
                    while (this.context.getURI((String)object) != null || xMLAttributes.getValue(NS_MAPPING_PREFIX + (String)object) != null) {
                        object = "ns" + ++n2;
                    }
                    object2 = (String)object + ":" + attribute.localName;
                    string = new QName(this.fSymbolTable.addSymbol(NS_MAPPING_DEFAULT), this.fSymbolTable.addSymbol((String)object), this.fSymbolTable.addSymbol(NS_MAPPING_PREFIX + (String)object), this.fSymbolTable.addSymbol("http://www.w3.org/2000/xmlns/"));
                    xMLAttributes.addAttribute((QName)string, "CDATA", attribute.namespace);
                    this.context.declarePrefix((String)object, attribute.namespace);
                    QName qName3 = new QName(this.fSymbolTable.addSymbol((String)object), this.fSymbolTable.addSymbol(attribute.localName), this.fSymbolTable.addSymbol((String)object2), this.fSymbolTable.addSymbol(attribute.namespace));
                    xMLAttributes.addAttribute(qName3, "CDATA", attribute.value);
                    int n4 = xMLAttributes.getIndex(qName3.uri, qName3.localpart);
                    xMLAttributes.setSpecified(n4, false);
                    continue;
                }
                String string = this.fSymbolTable.addSymbol(attribute.localName);
                QName qName4 = new QName(null, string, string, null);
                xMLAttributes.addAttribute(qName4, "CDATA", attribute.value);
                int n5 = xMLAttributes.getIndex(string);
                xMLAttributes.setSpecified(n5, false);
            }
        }
    }

    public void xmlDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.xmlDecl(string, string2, string3, augmentations);
        }
    }

    public void doctypeDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.doctypeDecl(string, string2, string3, augmentations);
        }
    }

    public void comment(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.comment(xMLString, augmentations);
        }
    }

    public void processingInstruction(String string, XMLString xMLString, Augmentations augmentations) throws XNIException {
        String string2;
        boolean bl = false;
        if (this.detecting && this.schema == null && "oxygen".equals(string)) {
            string2 = xMLString.toString();
            this.schema = this.getFromPIDataPseudoAttribute(string2, "RNGSchema", true);
            this.type = this.getFromPIDataPseudoAttribute(string2, "type", true);
            bl = true;
        }
        if (this.detecting && this.schema == null && "xml-model".equals(string)) {
            string2 = xMLString.toString();
            this.schema = this.getFromPIDataPseudoAttribute(string2, "href", true);
            this.type = this.getFromPIDataPseudoAttribute(string2, "type", true);
            String string3 = this.getFromPIDataPseudoAttribute(string2, "schematypens", true);
            bl = true;
            if (this.schema != null) {
                if (this.schema.toLowerCase().endsWith(".rng")) {
                    if (this.nullOrValue(string3, "http://relaxng.org/ns/structure/1.0") && this.nullOrValue(this.type, "application/xml")) {
                        this.type = RNG_XML_TYPE;
                    } else {
                        this.schema = null;
                    }
                } else if (this.schema.toLowerCase().endsWith(".rnc")) {
                    if (this.nullOrValue(string3, "http://relaxng.org/ns/structure/1.0") && this.nullOrValue(this.type, "application/relax-ng-compact-syntax")) {
                        this.type = RNG_COMPACT_TYPE;
                    } else {
                        this.schema = null;
                    }
                } else if ("http://relaxng.org/ns/structure/1.0".equals(string3) && this.nullOrValue(this.type, "application/xml")) {
                    this.type = RNG_XML_TYPE;
                } else if ("application/relax-ng-compact-syntax".equals(this.type) && this.nullOrValue(string3, "http://relaxng.org/ns/structure/1.0")) {
                    this.type = RNG_COMPACT_TYPE;
                } else {
                    this.schema = null;
                }
            }
        }
        if (!(this.documentHandler == null || bl && Util.isInsideDITAOTProcess())) {
            this.documentHandler.processingInstruction(string, xMLString, augmentations);
        }
    }

    private boolean nullOrValue(String string, String string2) {
        if (string == null) {
            return true;
        }
        return string.equals(string2);
    }

    private String getFromPIDataPseudoAttribute(String string, String string2, boolean bl) {
        int n2 = 0;
        while (n2 <= string.length() - 4) {
            int n3;
            int n4 = -1;
            for (n3 = n2; n3 < string.length(); ++n3) {
                if (string.charAt(n3) != '\"' && string.charAt(n3) != '\'') continue;
                n4 = n3;
                break;
            }
            if (n4 < 0) {
                return null;
            }
            n3 = string.indexOf(string.charAt(n4), n4 + 1);
            if (n3 < 0) {
                return null;
            }
            int n5 = string.indexOf(string2, n2);
            if (n5 < 0) {
                return null;
            }
            if (n5 < n4) {
                boolean bl2 = true;
                for (int i2 = n5 + string2.length(); i2 < n4; ++i2) {
                    char c2 = string.charAt(i2);
                    if (Character.isWhitespace(c2) || c2 == '=') continue;
                    bl2 = false;
                    break;
                }
                if (bl2) {
                    String string3 = string.substring(n4 + 1, n3);
                    return bl ? this.unescape(string3) : string3;
                }
            }
            n2 = n3 + 1;
        }
        return null;
    }

    private String unescape(String string) {
        if (string.indexOf(38) < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '&') {
                if (i2 + 2 < string.length() && string.charAt(i2 + 1) == '#') {
                    int n2;
                    int n3;
                    int n4;
                    if (string.charAt(i2 + 2) == 'x') {
                        n4 = 0;
                        for (n3 = i2 + 3; n3 < string.length() && string.charAt(n3) != ';'; ++n3) {
                            n2 = "0123456789abcdef".indexOf(string.charAt(n3));
                            if (n2 < 0) {
                                n2 = "0123456789ABCDEF".indexOf(string.charAt(n3));
                            }
                            if (n2 < 0) {
                                return null;
                            }
                            n4 = n4 * 16 + n2;
                        }
                        n2 = n4;
                        stringBuilder.append((char)n2);
                        i2 = n3;
                        continue;
                    }
                    n4 = 0;
                    for (n3 = i2 + 2; n3 < string.length() && string.charAt(n3) != ';'; ++n3) {
                        n2 = "0123456789".indexOf(string.charAt(n3));
                        if (n2 < 0) {
                            return null;
                        }
                        n4 = n4 * 10 + n2;
                    }
                    n2 = (char)n4;
                    stringBuilder.append((char)n2);
                    i2 = n3;
                    continue;
                }
                if (string.substring(i2 + 1).startsWith("lt;")) {
                    stringBuilder.append('<');
                    i2 += 3;
                    continue;
                }
                if (string.substring(i2 + 1).startsWith("gt;")) {
                    stringBuilder.append('>');
                    i2 += 3;
                    continue;
                }
                if (string.substring(i2 + 1).startsWith("amp;")) {
                    stringBuilder.append('&');
                    i2 += 4;
                    continue;
                }
                if (string.substring(i2 + 1).startsWith("quot;")) {
                    stringBuilder.append('\"');
                    i2 += 5;
                    continue;
                }
                if (string.substring(i2 + 1).startsWith("apos;")) {
                    stringBuilder.append('\'');
                    i2 += 5;
                    continue;
                }
                return null;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.onStartElement(qName, xMLAttributes);
        if (this.documentHandler != null) {
            this.documentHandler.emptyElement(qName, xMLAttributes, augmentations);
        }
        if (this.validator != null) {
            try {
                this.startElementToValidator(qName, xMLAttributes);
                this.endElementToValidator(qName);
            }
            catch (SAXException sAXException) {
                throw new XNIException((Exception)sAXException);
            }
        }
    }

    private void endElementToValidator(QName qName) throws SAXException {
        Set<String> set;
        this.validator.getContentHandler().endElement(qName.uri != null ? qName.uri : "", qName.localpart, qName.rawname);
        if (!this.prefixMappingStack.isEmpty() && (set = this.prefixMappingStack.pop()) != null) {
            for (String string : set) {
                this.validator.getContentHandler().endPrefixMapping(string);
            }
        }
    }

    public void startGeneralEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.startGeneralEntity(string, xMLResourceIdentifier, string2, augmentations);
        }
    }

    public void textDecl(String string, String string2, Augmentations augmentations) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.textDecl(string, string2, augmentations);
        }
    }

    public void endGeneralEntity(String string, Augmentations augmentations) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.endGeneralEntity(string, augmentations);
        }
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.characters(xMLString, augmentations);
        }
        if (this.validator != null) {
            try {
                this.validator.getContentHandler().characters(xMLString.ch, xMLString.offset, xMLString.length);
            }
            catch (SAXException sAXException) {
                throw new XNIException((Exception)sAXException);
            }
        }
    }

    public void ignorableWhitespace(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.ignorableWhitespace(xMLString, augmentations);
        }
        if (this.validator != null) {
            try {
                this.validator.getContentHandler().ignorableWhitespace(xMLString.ch, xMLString.offset, xMLString.length);
            }
            catch (SAXException sAXException) {
                throw new XNIException((Exception)sAXException);
            }
        }
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.endElement(qName, augmentations);
        }
        if (this.validator != null) {
            try {
                this.endElementToValidator(qName);
            }
            catch (SAXException sAXException) {
                throw new XNIException((Exception)sAXException);
            }
        }
    }

    public void startCDATA(Augmentations augmentations) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.startCDATA(augmentations);
        }
    }

    public void endCDATA(Augmentations augmentations) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.endCDATA(augmentations);
        }
    }

    public void endDocument(Augmentations augmentations) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.endDocument(augmentations);
        }
        if (this.validator != null) {
            try {
                this.validator.getContentHandler().endDocument();
            }
            catch (SAXException sAXException) {
                throw new XNIException((Exception)sAXException);
            }
        }
    }

    public void setDocumentSource(XMLDocumentSource xMLDocumentSource) {
        this.documentSource = xMLDocumentSource;
    }

    public XMLDocumentSource getDocumentSource() {
        return this.documentSource;
    }

    public String[] getRecognizedFeatures() {
        return (String[])RECOGNIZED_FEATURES.clone();
    }

    public void setFeature(String string, boolean bl) throws XMLConfigurationException {
    }

    public String[] getRecognizedProperties() {
        return (String[])RECOGNIZED_PROPERTIES.clone();
    }

    public void setProperty(String string, Object object) throws XMLConfigurationException {
        if (string.startsWith("http://apache.org/xml/properties/")) {
            int n2 = string.length() - "http://apache.org/xml/properties/".length();
            if (n2 == "internal/symbol-table".length() && string.endsWith("internal/symbol-table")) {
                this.fSymbolTable = (SymbolTable)object;
            } else if (n2 == "internal/entity-resolver".length() && string.endsWith("internal/entity-resolver")) {
                this.fResolver = (XMLEntityResolver)object;
            } else if (n2 == "internal/error-handler".length() && string.endsWith("internal/error-handler")) {
                this.errorHandler = (XMLErrorHandler)object;
            }
        }
    }

    public Boolean getFeatureDefault(String string) {
        for (int i2 = 0; i2 < RECOGNIZED_FEATURES.length; ++i2) {
            if (!RECOGNIZED_FEATURES[i2].equals(string)) continue;
            return FEATURE_DEFAULTS[i2];
        }
        return null;
    }

    public Object getPropertyDefault(String string) {
        for (int i2 = 0; i2 < RECOGNIZED_PROPERTIES.length; ++i2) {
            if (!RECOGNIZED_PROPERTIES[i2].equals(string)) continue;
            return PROPERTY_DEFAULTS[i2];
        }
        return null;
    }

    public void setDocumentHandler(XMLDocumentHandler xMLDocumentHandler) {
        this.documentHandler = xMLDocumentHandler;
    }

    public XMLDocumentHandler getDocumentHandler() {
        return this.documentHandler;
    }

    private static Logger getLogger() {
        if (logger == null) {
            logger = LoggerUtil.createLogger(RelaxNGDefaultsComponent.class.getName());
        }
        return logger;
    }

    public void setValidate(boolean bl) {
        this.validate = bl;
    }
}

