/*
 * Decompiled with CFR 0.152.
 */
package org.ditang.relaxng.defaults;

import com.thaiopensource.relaxng.pattern.DefaultValuesExtractor;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.resolver.Resolver;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.ditang.relaxng.defaults.OxygenRelaxNGSchemaReader;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import ro.sync.security.Sandbox;

public abstract class RelaxNGDefaultValues {
    private ErrorHandler eh;
    private final Resolver resolver;
    private final boolean keepSchema;
    private DefaultValuesCollector defaultValuesCollector = null;
    private boolean hasUpdateErrors;
    private OxygenRelaxNGSchemaReader.SchemaWrapper schema;

    protected RelaxNGDefaultValues(Resolver resolver, ErrorHandler errorHandler) {
        this(resolver, errorHandler, false);
    }

    protected RelaxNGDefaultValues(Resolver resolver, ErrorHandler errorHandler, boolean bl) {
        this.resolver = resolver;
        this.eh = errorHandler;
        this.keepSchema = bl;
    }

    protected abstract SchemaReader getSchemaReader();

    public void update(final InputSource inputSource) throws SAXException {
        this.defaultValuesCollector = null;
        PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder();
        propertyMapBuilder.put(ValidateProperty.RESOLVER, (Object)this.resolver);
        propertyMapBuilder.put(ValidateProperty.ERROR_HANDLER, (Object)this.eh);
        final PropertyMap propertyMap = propertyMapBuilder.toPropertyMap();
        try {
            OxygenRelaxNGSchemaReader.SchemaWrapper schemaWrapper = (OxygenRelaxNGSchemaReader.SchemaWrapper)Sandbox.runWithAllPerms((PrivilegedExceptionAction)new PrivilegedExceptionAction<OxygenRelaxNGSchemaReader.SchemaWrapper>(){

                @Override
                public OxygenRelaxNGSchemaReader.SchemaWrapper run() throws Exception {
                    return (OxygenRelaxNGSchemaReader.SchemaWrapper)RelaxNGDefaultValues.this.getSchemaReader().createSchema(inputSource, propertyMap);
                }
            });
            if (this.keepSchema) {
                this.schema = schemaWrapper;
            }
            Pattern pattern = schemaWrapper.getStart();
            this.defaultValuesCollector = new DefaultValuesCollector(pattern);
            this.hasUpdateErrors = false;
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.hasUpdateErrors = true;
            Exception exception = privilegedActionException.getException();
            if (exception != null) {
                this.eh.warning(new SAXParseException("Error loading defaults: " + exception.getMessage(), null, exception));
            }
        }
        catch (Exception exception) {
            this.hasUpdateErrors = true;
            this.eh.warning(new SAXParseException("Error loading defaults: " + exception.getMessage(), null, exception));
        }
        catch (StackOverflowError stackOverflowError) {
            this.hasUpdateErrors = true;
            this.eh.warning(new SAXParseException("Error loading defaults: " + stackOverflowError.getMessage(), null, null));
        }
    }

    public boolean hasUpdateErrors() {
        return this.hasUpdateErrors;
    }

    public List<Attribute> getDefaultAttributes(String string, String string2) {
        if (this.defaultValuesCollector != null) {
            return this.defaultValuesCollector.getDefaultAttributes(string, string2);
        }
        return null;
    }

    public Validator createValidator(PropertyMap propertyMap) {
        return this.schema.createValidator(propertyMap);
    }

    public boolean isKeepSchema() {
        return this.keepSchema;
    }

    class DefaultValuesCollector
    implements DefaultValuesExtractor.DefaultValuesListener {
        private HashMap<String, List<Attribute>> defaults = new HashMap();

        public DefaultValuesCollector(Pattern pattern) {
            new DefaultValuesExtractor((DefaultValuesExtractor.DefaultValuesListener)this).parsePattern(pattern);
        }

        private String getKey(String string, String string2) {
            return string + "#" + (string2 == null ? "" : string2);
        }

        private List<Attribute> getDefaultAttributes(String string, String string2) {
            return this.defaults.get(this.getKey(string, string2));
        }

        public void defaultValue(String string, String string2, String string3, String string4, String string5) {
            String string6 = this.getKey(string, string2);
            List<Attribute> list = this.defaults.get(string6);
            if (list == null) {
                list = new ArrayList<Attribute>();
                this.defaults.put(string6, list);
            }
            list.add(new Attribute(string3, string4, string5));
        }
    }

    class Attribute {
        String localName;
        String namespace;
        String value;

        public Attribute(String string, String string2, String string3) {
            this.localName = string;
            this.namespace = string2;
            this.value = string3;
        }
    }
}

