/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.json.instance.generator.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.Schema;
import ro.sync.json.instance.generator.JsonGeneratorOptions;
import ro.sync.json.instance.generator.engine.JsonGeneratorEngine;
import ro.sync.json.instance.generator.engine.StringGenerator;

public class ObjectGenerator {
    private JsonGeneratorEngine generator;

    public ObjectGenerator(JsonGeneratorEngine generatorEngine) {
        this.generator = generatorEngine;
    }

    String generateFromObjectSchema(ObjectSchema objectSchema, boolean isSchemaDependency) {
        StringBuilder objectBuilder = new StringBuilder();
        JsonGeneratorOptions options = this.generator.getOptions();
        if (!isSchemaDependency) {
            objectBuilder.append("{");
            if (options.isAssociateSchema() && !this.generator.isSchemaAssociated()) {
                objectBuilder.append(this.generator.getSchemaDeclaration()).append(',');
            }
        }
        ArrayList<String> propDependencies = new ArrayList<String>();
        for (Map.Entry dependency : objectSchema.getPropertyDependencies().entrySet()) {
            propDependencies.addAll((Collection)dependency.getValue());
        }
        if (objectSchema.getPropertyNameSchema() != null) {
            Object defaultValue = objectSchema.getUnprocessedProperties().get("default");
            this.generateFromPropertyNameSchema(objectBuilder, objectSchema.getPropertyNameSchema(), defaultValue);
        } else {
            this.generateFromPropertySchemas(objectBuilder, objectSchema, propDependencies);
        }
        if (!objectSchema.getPatternProperties().isEmpty() && options.isGenerateOptionalProps()) {
            for (Map.Entry patternProperty : objectSchema.getPatternProperties().entrySet()) {
                String propertyName = new StringGenerator(this.generator).getPatternMatchingString((Pattern)patternProperty.getKey(), 1, 20);
                this.generateFromPropertySchema(objectBuilder, propertyName, (Schema)patternProperty.getValue());
            }
        }
        for (Map.Entry schemaDep : objectSchema.getSchemaDependencies().entrySet()) {
            this.generateFromSchemaDependency(objectBuilder, (Schema)schemaDep.getValue());
        }
        if ((objectSchema.permitsAdditionalProperties() == null || objectSchema.permitsAdditionalProperties().booleanValue()) && options.isGenerateAdditionalProps() && objectSchema.getSchemaOfAdditionalProperties() != null) {
            this.generateFromSchemaOfAdditionalProps(objectBuilder, objectSchema.getSchemaOfAdditionalProperties());
        }
        if ((objectSchema.permitsUnevaluatedProperties() == null || objectSchema.permitsUnevaluatedProperties().booleanValue()) && options.isGenerateAdditionalProps() && objectSchema.getSchemaOfUnevaluatedProperties() != null) {
            this.generateFromSchemaOfAdditionalProps(objectBuilder, objectSchema.getSchemaOfUnevaluatedProperties());
        }
        if (objectBuilder.charAt(objectBuilder.length() - 1) == ',') {
            objectBuilder.setLength(objectBuilder.length() - 1);
        }
        if (!isSchemaDependency) {
            objectBuilder.append("}");
        }
        return objectBuilder.toString();
    }

    private void generateFromPropertyNameSchema(StringBuilder objectBuilder, Schema propertyNameSchema, Object defaultValue) {
        objectBuilder.append(this.generator.generateInstance(propertyNameSchema));
        objectBuilder.append(":").append(defaultValue != null ? defaultValue : "\"value\"").append(',');
    }

    private void generateFromPropertySchemas(StringBuilder objectBuilder, ObjectSchema objectSchema, List<String> propDependencies) {
        block4: {
            Map propertySchemas = objectSchema.getPropertySchemas();
            if (propertySchemas == null) break block4;
            if (this.generator.getOptions().isGenerateOptionalProps()) {
                for (Map.Entry entry : propertySchemas.entrySet()) {
                    this.generateFromPropertySchema(objectBuilder, (String)entry.getKey(), (Schema)entry.getValue());
                }
            } else {
                for (Map.Entry entry : propertySchemas.entrySet()) {
                    if (!objectSchema.getRequiredProperties().contains(entry.getKey()) && !propDependencies.contains(entry.getKey())) continue;
                    this.generateFromPropertySchema(objectBuilder, (String)entry.getKey(), (Schema)entry.getValue());
                }
            }
        }
    }

    private void generateFromPropertySchema(StringBuilder objectBuilder, String propertyName, Schema schema) {
        this.generator.setLastProperty(propertyName);
        String propertyInstance = this.generator.generateInstance(schema);
        objectBuilder.append("\"").append(propertyName).append("\"").append(":").append(propertyInstance).append(",");
    }

    private void generateFromSchemaDependency(StringBuilder objectBuilder, Schema schema) {
        if (schema instanceof ObjectSchema) {
            objectBuilder.append(this.generateFromObjectSchema((ObjectSchema)schema, true)).append(",");
        }
    }

    private void generateFromSchemaOfAdditionalProps(StringBuilder objectBuilder, Schema schemaOfAdditionalProps) {
        objectBuilder.append("\"additional_property\"").append(":");
        objectBuilder.append(this.generator.generateInstance(schemaOfAdditionalProps));
    }
}

