/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.json.instance.generator.engine;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Deque;
import java.util.LinkedList;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.BooleanSchema;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.ConstSchema;
import org.everit.json.schema.EmptySchema;
import org.everit.json.schema.EnumSchema;
import org.everit.json.schema.NotSchema;
import org.everit.json.schema.NullSchema;
import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.StringSchema;
import ro.sync.basic.util.URLUtil;
import ro.sync.json.instance.generator.JsonGeneratorOptions;
import ro.sync.json.instance.generator.engine.ArrayGenerator;
import ro.sync.json.instance.generator.engine.CombinedGenerator;
import ro.sync.json.instance.generator.engine.NumberGenerator;
import ro.sync.json.instance.generator.engine.ObjectGenerator;
import ro.sync.json.instance.generator.engine.OtherSchemaGenerator;
import ro.sync.json.instance.generator.engine.StringGenerator;

public class JsonGeneratorEngine {
    private String lastProperty;
    private JsonGeneratorOptions options;
    private Deque<Schema> referredSchemas;
    private final String schemaDeclaration;
    private boolean schemaAssociated;

    public JsonGeneratorEngine(JsonGeneratorOptions options) {
        this.options = options;
        this.referredSchemas = new LinkedList<Schema>();
        this.lastProperty = "property_value";
        String systemID = options.getJSONSchemaSystemID();
        try {
            String outputDir = options.getOutputDirectory();
            if (outputDir != null) {
                URL baseURL = URLUtil.correct((File)new File(outputDir));
                systemID = URLUtil.makeRelative((URL)baseURL, (URL)new URL(options.getJSONSchemaSystemID()));
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.schemaDeclaration = "\"$schema\": \"" + systemID + "\"";
    }

    public String generateInstance(Schema schema) {
        String instance = "{}";
        if (schema instanceof ObjectSchema) {
            instance = new ObjectGenerator(this).generateFromObjectSchema((ObjectSchema)schema, false);
        } else if (schema instanceof NumberSchema) {
            instance = new NumberGenerator(this).generateFromNumberSchema((NumberSchema)schema);
        } else if (schema instanceof ReferenceSchema) {
            instance = new OtherSchemaGenerator(this).generateFromReferenceSchema((ReferenceSchema)schema);
        } else if (schema instanceof StringSchema) {
            instance = new StringGenerator(this).generateFromStringSchema((StringSchema)schema);
        } else if (schema instanceof ArraySchema) {
            instance = new ArrayGenerator(this).generateFromArraySchema((ArraySchema)schema);
        } else if (schema instanceof EnumSchema) {
            instance = new OtherSchemaGenerator(this).generateFromEnumSchema((EnumSchema)schema);
        } else if (schema instanceof CombinedSchema) {
            instance = new CombinedGenerator(this).generateFromCombinedSchema((CombinedSchema)schema);
        } else if (schema instanceof NotSchema) {
            instance = new OtherSchemaGenerator(this).generateFromNotSchema((NotSchema)schema);
        } else if (schema instanceof ConstSchema) {
            instance = new OtherSchemaGenerator(this).generateFromConstSchema((ConstSchema)schema);
        } else if (schema instanceof BooleanSchema) {
            instance = new OtherSchemaGenerator(this).generateFromBooleanSchema((BooleanSchema)schema);
        } else if (schema instanceof EmptySchema) {
            instance = new OtherSchemaGenerator(this).generateFromEmptySchema();
        } else if (schema instanceof NullSchema) {
            instance = new OtherSchemaGenerator(this).generateFromNullSchema();
        }
        return instance;
    }

    public String getSchemaDeclaration() {
        this.schemaAssociated = true;
        return this.schemaDeclaration;
    }

    public boolean isSchemaAssociated() {
        return this.schemaAssociated;
    }

    String getLastProperty() {
        return this.lastProperty;
    }

    void setLastProperty(String lastProperty) {
        this.lastProperty = lastProperty;
    }

    JsonGeneratorOptions getOptions() {
        return this.options;
    }

    Deque<Schema> getReferredSchemas() {
        return this.referredSchemas;
    }

    void addReferredSchema(Schema referredSchema) {
        this.referredSchemas.push(referredSchema);
    }

    void popSchema() {
        this.referredSchemas.pop();
    }
}

