/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.json.instance.generator.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.everit.json.schema.BooleanSchema;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.ConstSchema;
import org.everit.json.schema.EmptySchema;
import org.everit.json.schema.EnumSchema;
import org.everit.json.schema.NullSchema;
import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.StringSchema;
import org.json.JSONException;
import org.json.JSONObject;
import ro.sync.json.instance.generator.JsonGeneratorUtil;
import ro.sync.json.instance.generator.engine.JsonGeneratorEngine;
import ro.sync.json.instance.generator.engine.NumberGenerator;
import ro.sync.json.instance.generator.engine.ObjectGenerator;
import ro.sync.json.instance.generator.engine.StringGenerator;

public class CombinedGenerator {
    private JsonGeneratorEngine generator;

    public CombinedGenerator(JsonGeneratorEngine generatorEngine) {
        this.generator = generatorEngine;
    }

    String generateFromCombinedSchema(CombinedSchema combinedSchema) {
        String instance = "";
        List subschemas = combinedSchema.getSubschemas().stream().collect(Collectors.toCollection(ArrayList::new));
        if (combinedSchema.getCriterion() == CombinedSchema.ALL_CRITERION) {
            if (subschemas.size() == 1) {
                instance = this.generator.generateInstance((Schema)subschemas.get(0));
            } else if (this.haveSameType(subschemas)) {
                if (subschemas.get(0) instanceof StringSchema) {
                    instance = new StringGenerator(this.generator).generateFromStringSchemas(subschemas);
                } else if (subschemas.get(0) instanceof NumberSchema) {
                    instance = new NumberGenerator(this.generator).generateFromNumberSchemas(subschemas).toString();
                } else if (subschemas.get(0) instanceof ObjectSchema) {
                    ObjectSchema combinedObjSchema = this.generateCombinedObjectSchema(subschemas);
                    instance = new ObjectGenerator(this.generator).generateFromObjectSchema(combinedObjSchema, false);
                } else {
                    instance = this.generateCombinedInstance(subschemas);
                }
            } else {
                instance = this.processDifferentTypeSubschemas(subschemas);
            }
        } else if (this.generator.getOptions().getChoiceStrategy().equals("Random")) {
            int randomIndex = JsonGeneratorUtil.NUMBER_GENERATOR.nextInt(subschemas.size());
            instance = this.generator.generateInstance((Schema)subschemas.get(randomIndex));
        } else {
            instance = this.generator.generateInstance((Schema)subschemas.iterator().next());
        }
        return !instance.isEmpty() ? instance : "\"\"";
    }

    private boolean isSimpleTypeSchema(Schema schema) {
        if (schema instanceof CombinedSchema) {
            CombinedSchema combinedSchema = (CombinedSchema)schema;
            for (Schema subschema : combinedSchema.getSubschemas()) {
                if (!(subschema instanceof NullSchema)) continue;
                return true;
            }
        }
        return schema instanceof StringSchema || schema instanceof NumberSchema || schema instanceof BooleanSchema || schema instanceof EmptySchema || schema instanceof NullSchema || schema instanceof EnumSchema || schema instanceof ConstSchema;
    }

    private boolean haveSimpleType(List<Schema> subschemas) {
        return subschemas.stream().anyMatch(this::isSimpleTypeSchema);
    }

    private boolean haveSameType(List<Schema> subschemas) {
        Class<?> firstSchemaType = subschemas.get(0).getClass();
        return subschemas.stream().allMatch(subschema -> subschema.getClass().equals(firstSchemaType));
    }

    private String generateCombinedInstance(List<Schema> subschemas) {
        JSONObject combinedInstance = new JSONObject();
        for (Schema subschema : subschemas) {
            String instance = this.generator.generateInstance(subschema);
            try {
                JSONObject subschemaInstance = new JSONObject(instance);
                for (String subschemaKey : subschemaInstance.keySet()) {
                    combinedInstance.put(subschemaKey, subschemaInstance.get(subschemaKey));
                }
            }
            catch (JSONException jSONException) {
            }
        }
        return combinedInstance.toString();
    }

    private ObjectSchema generateCombinedObjectSchema(List<Schema> subschemas) {
        ObjectSchema.Builder builder = new ObjectSchema.Builder();
        for (Schema subschema : subschemas) {
            ObjectSchema objSchema = (ObjectSchema)subschema;
            for (Map.Entry property : objSchema.getPropertySchemas().entrySet()) {
                builder.addPropertySchema((String)property.getKey(), (Schema)property.getValue());
            }
            builder.propertyNameSchema(objSchema.getPropertyNameSchema());
            builder.schemaOfAdditionalProperties(objSchema.getSchemaOfAdditionalProperties());
            builder.additionalProperties(objSchema.permitsAdditionalProperties());
            for (String requiredProp : objSchema.getRequiredProperties()) {
                builder.addRequiredProperty(requiredProp);
            }
        }
        return new ObjectSchema(builder);
    }

    private String processDifferentTypeSubschemas(List<Schema> subschemas) {
        String instance = "";
        if (this.haveSimpleType(subschemas)) {
            subschemas.removeIf(subschema -> subschema instanceof StringSchema);
            if (subschemas.size() == 1) {
                instance = this.generator.generateInstance(subschemas.get(0));
            } else {
                for (Schema subschema2 : subschemas) {
                    if (!(subschema2 instanceof EnumSchema) && this.isSimpleTypeSchema(subschema2)) continue;
                    instance = this.generator.generateInstance(subschema2);
                    break;
                }
            }
        } else {
            instance = this.generateCombinedInstance(subschemas);
        }
        return instance;
    }
}

