/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.classindex.processor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementScanner6;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.atteo.classindex.IndexAnnotated;
import org.atteo.classindex.IndexSubclasses;

public class ClassIndexProcessor
extends AbstractProcessor {
    private Map<TypeElement, Set<String>> subclassMap = new HashMap<TypeElement, Set<String>>();
    private Map<TypeElement, Set<String>> annotatedMap = new HashMap<TypeElement, Set<String>>();
    private Map<PackageElement, Set<String>> packageMap = new HashMap<PackageElement, Set<String>>();
    private boolean annotationDriven = true;
    private Set<String> indexedAnnotations = new HashSet<String>();
    private Set<String> indexedSuperclasses = new HashSet<String>();
    private Set<String> indexedPackages = new HashSet<String>();
    private Set<TypeElement> javadocAlreadyStored = new HashSet<TypeElement>();
    private Types types;
    private Filer filer;
    private Elements elementUtils;
    private Messager messager;

    public ClassIndexProcessor() {
    }

    protected ClassIndexProcessor(Class<?> ... classes) {
        if (classes.length == 0) {
            return;
        }
        this.annotationDriven = false;
        for (Class<?> klass : classes) {
            this.indexedAnnotations.add(klass.getCanonicalName());
        }
    }

    protected final void indexAnnotations(Class<?> ... classes) {
        for (Class<?> klass : classes) {
            this.indexedAnnotations.add(klass.getCanonicalName());
        }
        this.annotationDriven = false;
    }

    protected final void indexSubclasses(Class<?> ... classes) {
        for (Class<?> klass : classes) {
            this.indexedSuperclasses.add(klass.getCanonicalName());
        }
        this.annotationDriven = false;
    }

    protected final void indexPackages(String ... packages) {
        Collections.addAll(this.indexedPackages, packages);
        this.annotationDriven = false;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton("*");
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.types = processingEnv.getTypeUtils();
        this.filer = processingEnv.getFiler();
        this.elementUtils = processingEnv.getElementUtils();
        this.messager = processingEnv.getMessager();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            for (Element element : roundEnv.getRootElements()) {
                if (!(element instanceof TypeElement)) continue;
                final PackageElement packageElement = this.getPackage(element);
                element.accept(new ElementScanner6<Void, Void>(){

                    @Override
                    public Void visitType(TypeElement typeElement, Void o) {
                        try {
                            for (AnnotationMirror annotationMirror : typeElement.getAnnotationMirrors()) {
                                TypeElement annotationElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
                                ClassIndexProcessor.this.storeAnnotation(annotationElement, typeElement);
                            }
                            ClassIndexProcessor.this.indexSupertypes(typeElement, typeElement);
                            if (packageElement != null) {
                                ClassIndexProcessor.this.storeClassFromPackage(packageElement, typeElement);
                            }
                        }
                        catch (IOException e) {
                            ClassIndexProcessor.this.messager.printMessage(Diagnostic.Kind.ERROR, "[ClassIndexProcessor] " + e.getMessage());
                        }
                        return (Void)super.visitType(typeElement, o);
                    }
                }, null);
            }
            if (!roundEnv.processingOver()) {
                return false;
            }
            this.writeIndexFiles("META-INF/services/", this.subclassMap);
            this.writeIndexFiles("META-INF/annotations/", this.annotatedMap);
            for (Map.Entry entry : this.packageMap.entrySet()) {
                this.writeSimpleNameIndexFile((Set)entry.getValue(), ((PackageElement)entry.getKey()).getQualifiedName().toString().replace(".", "/") + "/" + "jaxb.index");
            }
        }
        catch (IOException e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "[ClassIndexProcessor] Can't write index file: " + e.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.messager.printMessage(Diagnostic.Kind.ERROR, "[ClassIndexProcessor] Internal error: " + e.getMessage());
        }
        return false;
    }

    private void writeIndexFiles(String prefix, Map<TypeElement, Set<String>> indexMap) throws IOException {
        for (Map.Entry<TypeElement, Set<String>> entry : indexMap.entrySet()) {
            this.writeSimpleNameIndexFile(entry.getValue(), prefix + entry.getKey().getQualifiedName().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readOldIndexFile(Set<String> entries, String resourceName) throws IOException {
        block22: {
            try (Reader reader = null;){
                FileObject resource = this.filer.getResource(StandardLocation.CLASS_OUTPUT, "", resourceName);
                reader = resource.openReader(true);
                ClassIndexProcessor.readOldIndexFile(entries, reader);
            }
        }
    }

    private static void readOldIndexFile(Set<String> entries, Reader reader) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            String line = bufferedReader.readLine();
            while (line != null) {
                entries.add(line);
                line = bufferedReader.readLine();
            }
        }
    }

    private void writeIndexFile(Set<String> entries, String resourceName) throws IOException {
        FileObject file = this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", resourceName, new Element[0]);
        try (Writer writer = file.openWriter();){
            for (String entry : entries) {
                writer.write(entry);
                writer.write("\n");
            }
        }
    }

    private void writeSimpleNameIndexFile(Set<String> elementList, String resourceName) throws IOException {
        this.readOldIndexFile(elementList, resourceName);
        this.writeIndexFile(elementList, resourceName);
    }

    private void writeFile(String content, String resourceName) throws IOException {
        FileObject file = this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", resourceName, new Element[0]);
        try (Writer writer = file.openWriter();){
            writer.write(content);
        }
    }

    private void indexSupertypes(TypeElement rootElement, TypeElement element) throws IOException {
        for (TypeMirror typeMirror : this.types.directSupertypes(element.asType())) {
            if (typeMirror.getKind() != TypeKind.DECLARED) continue;
            DeclaredType superType = (DeclaredType)typeMirror;
            TypeElement superTypeElement = (TypeElement)superType.asElement();
            this.storeSubclass(superTypeElement, rootElement);
            for (AnnotationMirror annotationMirror : superTypeElement.getAnnotationMirrors()) {
                TypeElement annotationElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
                if (!this.hasAnnotation(annotationElement, Inherited.class)) continue;
                this.storeAnnotation(annotationElement, rootElement);
            }
            this.indexSupertypes(rootElement, superTypeElement);
        }
    }

    private boolean hasAnnotation(TypeElement element, Class<? extends Annotation> inheritedClass) {
        block3: {
            try {
                for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                    if (!annotationMirror.getAnnotationType().toString().equals(inheritedClass.getName())) continue;
                    return true;
                }
            }
            catch (RuntimeException e) {
                if (e.getClass().getName().equals("com.sun.tools.javac.code.Symbol$CompletionFailure")) break block3;
                this.messager.printMessage(Diagnostic.Kind.ERROR, "[ClassIndexProcessor] Can't check annotation: " + e.getMessage());
            }
        }
        return false;
    }

    private void storeAnnotation(TypeElement annotationElement, TypeElement rootElement) throws IOException {
        IndexAnnotated indexAnnotated;
        if (this.indexedAnnotations.contains(annotationElement.getQualifiedName().toString())) {
            this.putElement(this.annotatedMap, annotationElement, rootElement);
        } else if (this.annotationDriven && (indexAnnotated = annotationElement.getAnnotation(IndexAnnotated.class)) != null) {
            this.putElement(this.annotatedMap, annotationElement, rootElement);
            if (indexAnnotated.storeJavadoc()) {
                this.storeJavadoc(rootElement);
            }
        }
    }

    private void storeSubclass(TypeElement superTypeElement, TypeElement rootElement) throws IOException {
        IndexSubclasses indexSubclasses;
        if (this.indexedSuperclasses.contains(superTypeElement.getQualifiedName().toString())) {
            this.putElement(this.subclassMap, superTypeElement, rootElement);
        } else if (this.annotationDriven && (indexSubclasses = superTypeElement.getAnnotation(IndexSubclasses.class)) != null) {
            this.putElement(this.subclassMap, superTypeElement, rootElement);
            if (indexSubclasses.storeJavadoc()) {
                this.storeJavadoc(rootElement);
            }
        }
        if (this.indexedSuperclasses.contains(superTypeElement.getQualifiedName().toString()) || this.annotationDriven && superTypeElement.getAnnotation(IndexSubclasses.class) != null) {
            this.putElement(this.subclassMap, superTypeElement, rootElement);
        }
    }

    private void storeClassFromPackage(PackageElement packageElement, TypeElement rootElement) throws IOException {
        String simpleName;
        IndexSubclasses indexSubclasses;
        if (this.indexedPackages.contains(packageElement.getQualifiedName().toString())) {
            this.putElement(this.packageMap, packageElement, rootElement);
        } else if (this.annotationDriven && (indexSubclasses = packageElement.getAnnotation(IndexSubclasses.class)) != null && (simpleName = this.getShortName(rootElement)) != null) {
            this.putElement(this.packageMap, packageElement, simpleName);
            if (indexSubclasses.storeJavadoc()) {
                this.storeJavadoc(rootElement);
            }
        }
    }

    private <K> void putElement(Map<K, Set<String>> map, K keyElement, TypeElement valueElement) {
        String fullName = this.getFullName(valueElement);
        if (fullName != null) {
            this.putElement(map, keyElement, fullName);
        }
    }

    private <K> void putElement(Map<K, Set<String>> map, K keyElement, String valueElement) {
        Set<String> set = map.get(keyElement);
        if (set == null) {
            set = new TreeSet<String>();
            map.put(keyElement, set);
        }
        set.add(valueElement);
    }

    private String getFullName(TypeElement typeElement) {
        switch (typeElement.getNestingKind()) {
            case TOP_LEVEL: {
                return typeElement.getQualifiedName().toString();
            }
            case MEMBER: {
                String enclosingName;
                Element enclosingElement = typeElement.getEnclosingElement();
                if (enclosingElement instanceof TypeElement && (enclosingName = this.getFullName((TypeElement)enclosingElement)) != null) {
                    return enclosingName + '$' + typeElement.getSimpleName().toString();
                }
                return null;
            }
        }
        return null;
    }

    private String getShortName(TypeElement typeElement) {
        switch (typeElement.getNestingKind()) {
            case TOP_LEVEL: {
                return typeElement.getSimpleName().toString();
            }
            case MEMBER: {
                String enclosingName;
                Element enclosingElement = typeElement.getEnclosingElement();
                if (enclosingElement instanceof TypeElement && (enclosingName = this.getShortName((TypeElement)enclosingElement)) != null) {
                    return enclosingName + '$' + typeElement.getSimpleName().toString();
                }
                return null;
            }
        }
        return null;
    }

    private PackageElement getPackage(Element typeElement) {
        for (Element element = typeElement; element != null; element = element.getEnclosingElement()) {
            if (!(element instanceof PackageElement)) continue;
            return (PackageElement)element;
        }
        return null;
    }

    private void storeJavadoc(TypeElement element) throws IOException {
        if (this.javadocAlreadyStored.contains(element)) {
            return;
        }
        this.javadocAlreadyStored.add(element);
        String docComment = this.elementUtils.getDocComment(element);
        if (docComment == null) {
            return;
        }
        this.writeFile(docComment, "META-INF/javadocs/" + element.getQualifiedName().toString());
    }
}

