/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.zendesk.ant;

import com.oxygenxml.platform.integration.ErrorHandler;
import com.oxygenxml.platform.integration.ProgressEvent;
import com.oxygenxml.platform.integration.ProgressTracker;
import com.oxygenxml.zendesk.ZendeskRepositoryManager;
import com.oxygenxml.zendesk.ant.ZendeskHelpCenterParamCheckTask;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class ZendeskHelpCenterUpdateTask
extends ZendeskHelpCenterParamCheckTask {
    private File baseDir;

    @Override
    public void execute() throws BuildException {
        this.checkLicense();
        ZendeskRepositoryManager manager = new ZendeskRepositoryManager();
        this.log("Upload " + this.baseDir.getAbsolutePath() + " to " + this.settings.getParameterValue("zendeskHost"));
        ZendeskHelpCenterUpdateTask.extractSettingsFromEnv(this.settings);
        final Exception[] stopException = new Exception[1];
        ErrorHandler errorHandler = new ErrorHandler(){

            @Override
            public void warn(Exception ex) {
                ZendeskHelpCenterUpdateTask.this.getProject().log((Task)ZendeskHelpCenterUpdateTask.this, ex.getMessage(), (Throwable)ex, 1);
                ex.printStackTrace();
            }

            @Override
            public void fatal(Exception ex) {
                ZendeskHelpCenterUpdateTask.this.getProject().log((Task)ZendeskHelpCenterUpdateTask.this, ex.getMessage(), (Throwable)ex, 0);
                stopException[0] = ex;
            }

            @Override
            public void error(Exception ex) {
                ZendeskHelpCenterUpdateTask.this.getProject().log((Task)ZendeskHelpCenterUpdateTask.this, ex.getMessage(), (Throwable)ex, 0);
                ex.printStackTrace();
            }
        };
        ProgressTracker progressTracker = new ProgressTracker(){

            @Override
            public void operationStarted() {
                ZendeskHelpCenterUpdateTask.this.log("Zendesk upload started");
            }

            @Override
            public void operationEnded() {
                ZendeskHelpCenterUpdateTask.this.log("Zendesk upload ended");
            }

            @Override
            public void eventHappened(ProgressEvent event) {
                ZendeskHelpCenterUpdateTask.this.log(event.getMessage());
            }
        };
        manager.updateRepository(this.baseDir, this.settings, errorHandler, progressTracker);
        if (stopException[0] != null) {
            throw new BuildException(stopException[0].getMessage(), (Throwable)stopException[0]);
        }
    }

    public void setDir(File dir) {
        this.baseDir = dir;
    }
}

