/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.zendesk.ant;

import com.oxygenxml.platform.integration.SettingsImpl;
import com.oxygenxml.zendesk.OxygenZendeskException;
import com.oxygenxml.zendesk.ant.AntLicenseValidationHandler;
import com.oxygenxml.zendesk.settings.SettingsProcessor;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import ro.sync.licensemanager.base.LicenseCheckerWithOxygenParent;
import ro.sync.licensemanager.webhelp.LicenseRequirements;
import ro.sync.licensemanager.webhelp.WebHelpLicenseChecker;

public class ZendeskHelpCenterParamCheckTask
extends Task {
    private static final String ENV_ZENDESK_LOGIN_TOKEN = "zendesk.login.token";
    protected SettingsImpl settings = new SettingsImpl();
    private String pluginDirPath;
    private static final String PUBLISHING_LICENSE_FILENAME = "licensekey.txt";
    static final String PRODUCT_NAME = "Zendesk Help Center Connector";

    public void execute() throws BuildException {
        this.checkLicense();
        ZendeskHelpCenterParamCheckTask.extractSettingsFromEnv(this.settings);
        SettingsProcessor settingsProcessor = new SettingsProcessor(this.settings);
        try {
            settingsProcessor.getProcessedInitializationSettings();
        }
        catch (OxygenZendeskException ex) {
            throw new BuildException(ex.getMessage(), (Throwable)ex);
        }
    }

    protected static void extractSettingsFromEnv(SettingsImpl settings) {
        String envToken;
        if (settings.getParameterValue("token") == null && (envToken = System.getenv(ENV_ZENDESK_LOGIN_TOKEN)) != null) {
            settings.put("token", envToken);
        }
    }

    public void setZendeskHost(String host) {
        this.settings.put("zendeskHost", host);
    }

    public void setUsername(String username) {
        this.settings.put("username", username);
    }

    public void setToken(String token) {
        this.settings.put("token", token);
    }

    public void setSectionName(String sectionName) {
        this.settings.put("sectionName", sectionName);
    }

    public void setCategoryName(String categoryName) {
        this.settings.put("categoryName", categoryName);
    }

    public void setCreateDrafts(String createDrafts) {
        this.settings.put("createDrafts", createDrafts);
    }

    public void setVisibleTo(String userSegment) {
        this.settings.put("visibleTo", userSegment);
    }

    public void setCreateToc(String createToc) {
        this.settings.put("createToc", createToc);
    }

    public void setTocTitlePrefix(String tocTitlePrefix) {
        this.settings.put("tocTitlePrefix", tocTitlePrefix);
    }

    public void setTocTitleSuffix(String tocTitleSuffix) {
        this.settings.put("tocTitleSuffix", tocTitleSuffix);
    }

    public void setPermissionGroupName(String permissionGroupName) {
        this.settings.put("permissionGroupName", permissionGroupName);
    }

    public void setPluginDir(String pluginDirPath) {
        this.pluginDirPath = pluginDirPath;
    }

    public SettingsImpl getSettings() {
        return this.settings;
    }

    protected void checkLicense() {
        AntLicenseValidationHandler validationHandler = new AntLicenseValidationHandler(this.getProject());
        if (this.pluginDirPath == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("The \"pluginDir\" was not specified. You need to set the path of the base directory of the plugin that invoked this task.\n");
            sb.append("This directory is used to search for the Oxygen Publishing Engine license key file.");
            String errorMessage = sb.toString();
            this.log(errorMessage);
            throw new BuildException(errorMessage);
        }
        String invalidLicenseMsg = this.getInvalidLicenseMessage();
        WebHelpLicenseChecker whLicenseChecker = new WebHelpLicenseChecker((LicenseCheckerWithOxygenParent.LicenseValidationHandler)validationHandler, this.pluginDirPath, PUBLISHING_LICENSE_FILENAME, invalidLicenseMsg, PRODUCT_NAME, new LicenseRequirements(new String[]{"Publishing-Engine"}, new String[]{"Enterprise", "Enterprise-Floating", "Enterprise-Corporate", "Enterprise-Managed-Named-User", "Enterprise-Site"}));
        whLicenseChecker.checkLicense();
    }

    private String getInvalidLicenseMessage() {
        String ditaOtDirPath = this.getDitaOtDirPath();
        return MessageFormat.format("Cannot find a valid \"{0}\" license file in:\n- the DITA-OT directory: \"{1}\"\n- the plugin base directory: \"{2}\"\n\nPlease place your Oxygen Publishing Engine Enterprise license key in a file called \"{3}\" and copy it to one of the above locations.\n\nIf you do not have a license key or you need more details, please contact sales@oxygenxml.com.\n", PUBLISHING_LICENSE_FILENAME, ditaOtDirPath, this.pluginDirPath, PUBLISHING_LICENSE_FILENAME);
    }

    private String getDitaOtDirPath() {
        String ditaOtDirPath = null;
        if (this.pluginDirPath != null) {
            try {
                File ditaOtDir;
                File pluginDir = new File(this.pluginDirPath).getCanonicalFile();
                File ditaOtPluginsDir = pluginDir.getParentFile();
                if (ditaOtPluginsDir != null && (ditaOtDir = ditaOtPluginsDir.getParentFile()) != null) {
                    ditaOtDirPath = ditaOtDir.getAbsolutePath();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (ditaOtDirPath == null) {
            ditaOtDirPath = "[DITA-OT-DIRECTORY]";
        }
        return ditaOtDirPath;
    }
}

