/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.zendesk;

import com.oxygenxml.platform.integration.ErrorHandler;
import com.oxygenxml.platform.integration.ProgressEvent;
import com.oxygenxml.platform.integration.ProgressTracker;
import com.oxygenxml.platform.integration.SettingsImpl;
import com.oxygenxml.zendesk.OxygenZendeskException;
import com.oxygenxml.zendesk.ZendeskRepositoryManager;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OxygenZendeskMain {
    private static final Logger logger = LoggerFactory.getLogger(OxygenZendeskMain.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            long before = System.currentTimeMillis();
            OxygenZendeskMain.initProxies();
            OxygenZendeskMain.createTestContent();
            long after = System.currentTimeMillis();
            System.out.println("Execution time: " + (after - before));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            System.exit(1);
        }
    }

    private static void createTestContent() throws OxygenZendeskException {
        SettingsImpl settings = new SettingsImpl();
        settings.put("zendeskHost", "https://d3v-sync9832.zendesk.com");
        settings.put("username", "support_author@sync.ro");
        settings.put("token", "Q980Lk2T8UamSMyQ99pnuFz5E1ZBx2EuF9ltWDec");
        settings.put("sectionName", "First section");
        settings.put("categoryName", "First category");
        settings.put("permissionGroupName", "Admins");
        ZendeskRepositoryManager zendeskRepoMngr = new ZendeskRepositoryManager();
        zendeskRepoMngr.updateRepository(new File("src/test/resources/html/samples_3_flowers"), settings, new ErrorHandler(){

            @Override
            public void warn(Exception ex) {
                ex.printStackTrace();
            }

            @Override
            public void fatal(Exception ex) {
                ex.printStackTrace();
            }

            @Override
            public void error(Exception ex) {
                ex.printStackTrace();
            }
        }, new ProgressTracker(){

            @Override
            public void operationStarted() {
                System.out.println("Operation started");
            }

            @Override
            public void eventHappened(ProgressEvent event) {
                System.out.println(event.getMessage());
            }

            @Override
            public void operationEnded() {
                System.out.println("Operation ended");
            }
        });
    }

    private static void initProxies() {
        System.setProperty("http.proxyHost", "proxy.sync.ro");
        System.setProperty("http.proxyPort", "3128");
        System.setProperty("https.proxyHost", "proxy.sync.ro");
        System.setProperty("https.proxyPort", "3128");
    }
}

