/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.extra;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.UnicodeSet;
import nu.validator.htmlparser.common.CharacterHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class NormalizationChecker
implements CharacterHandler {
    private ErrorHandler errorHandler;
    private Locator locator;
    private static final UnicodeSet COMPOSING_CHARACTERS = new UnicodeSet("[[:nfc_qc=maybe:][:^ccc=0:]]").freeze();
    private char[] buf = new char[128];
    private char[] bufHolder = null;
    private int pos;
    private boolean atStartOfRun;
    private boolean alreadyComplainedAboutThisRun;

    public void err(String message) throws SAXException {
        if (this.errorHandler != null) {
            SAXParseException spe = new SAXParseException(message, this.locator);
            this.errorHandler.error(spe);
        }
    }

    private static boolean isComposingCharOrSurrogate(char c) {
        if (UCharacter.isHighSurrogate((int)c) || UCharacter.isLowSurrogate((int)c)) {
            return true;
        }
        return NormalizationChecker.isComposingChar(c);
    }

    private static boolean isComposingChar(int c) {
        return COMPOSING_CHARACTERS.contains(c);
    }

    public NormalizationChecker(Locator locator) {
        this.start();
    }

    public void start() {
        this.atStartOfRun = true;
        this.alreadyComplainedAboutThisRun = false;
        this.pos = 0;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        int i;
        if (this.alreadyComplainedAboutThisRun) {
            return;
        }
        if (this.atStartOfRun) {
            char c = ch[start];
            if (this.pos == 1) {
                if (NormalizationChecker.isComposingChar(UCharacter.getCodePoint((int)this.buf[0], (int)c))) {
                    this.err("Text run starts with a composing character.");
                }
                this.atStartOfRun = false;
            } else {
                if (length == 1 && UCharacter.isHighSurrogate((int)c)) {
                    this.buf[0] = c;
                    this.pos = 1;
                    return;
                }
                if (UCharacter.isHighSurrogate((int)c)) {
                    if (NormalizationChecker.isComposingChar(UCharacter.getCodePoint((int)c, (int)ch[start + 1]))) {
                        this.err("Text run starts with a composing character.");
                    }
                } else if (NormalizationChecker.isComposingCharOrSurrogate(c)) {
                    this.err("Text run starts with a composing character.");
                }
                this.atStartOfRun = false;
            }
        }
        int stop = start + length;
        if (this.pos > 0) {
            for (i = start; i < stop && NormalizationChecker.isComposingCharOrSurrogate(ch[i]); ++i) {
            }
            this.appendToBuf(ch, start, i);
            if (i == stop) {
                return;
            }
            if (!Normalizer.isNormalized((char[])this.buf, (int)0, (int)this.pos, (Normalizer.Mode)Normalizer.NFC, (int)0)) {
                this.errAboutTextRun();
            }
            this.pos = 0;
        }
        if (i < stop) {
            start = i;
            for (i = stop - 1; i > start && NormalizationChecker.isComposingCharOrSurrogate(ch[i]); --i) {
            }
            if (i > start && !Normalizer.isNormalized((char[])ch, (int)start, (int)i, (Normalizer.Mode)Normalizer.NFC, (int)0)) {
                this.errAboutTextRun();
            }
            this.appendToBuf(ch, i, stop);
        }
    }

    private void errAboutTextRun() throws SAXException {
        this.err("Source text is not in Unicode Normalization Form C.");
        this.alreadyComplainedAboutThisRun = true;
    }

    private void appendToBuf(char[] ch, int start, int end) {
        if (start == end) {
            return;
        }
        int neededBufLen = this.pos + (end - start);
        if (neededBufLen > this.buf.length) {
            char[] newBuf = new char[neededBufLen];
            System.arraycopy(this.buf, 0, newBuf, 0, this.pos);
            if (this.bufHolder == null) {
                this.bufHolder = this.buf;
            }
            this.buf = newBuf;
        }
        System.arraycopy(ch, start, this.buf, this.pos, end - start);
        this.pos += end - start;
    }

    public void end() throws SAXException {
        if (!this.alreadyComplainedAboutThisRun && !Normalizer.isNormalized((char[])this.buf, (int)0, (int)this.pos, (Normalizer.Mode)Normalizer.NFC, (int)0)) {
            this.errAboutTextRun();
        }
        if (this.bufHolder != null) {
            this.buf = this.bufHolder;
            this.bufHolder = null;
        }
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }
}

