/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita.topic.table.simpletable.properties;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.commons.table.properties.TablePropertiesHelperBase;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class SimpleTableHelper
extends TablePropertiesHelperBase {
    private static final String STENTRY = "<stentry/>";
    private static final String STHEAD = "<sthead/>";
    private static final String STROW = "<strow/>";
    private static final String ATTRIBUTE_CLASS = "class";

    @Override
    public boolean isTable(AuthorElement node) {
        AttrValue classAttr = node.getAttribute(ATTRIBUTE_CLASS);
        return classAttr != null && classAttr.getValue().contains(" topic/simpletable ");
    }

    @Override
    public boolean isTableRow(AuthorElement node) {
        return this.isHeaderRow(node) || this.isBodyRow(node);
    }

    public boolean isHeaderRow(AuthorElement node) {
        AttrValue classAttr = node.getAttribute(ATTRIBUTE_CLASS);
        return classAttr != null && classAttr.getValue().contains(" topic/sthead ");
    }

    public boolean isBodyRow(AuthorElement node) {
        AttrValue classAttr = node.getAttribute(ATTRIBUTE_CLASS);
        return classAttr != null && classAttr.getValue().contains(" topic/strow ");
    }

    @Override
    public boolean isTableHead(AuthorElement node) {
        return this.isHeaderRow(node);
    }

    @Override
    public boolean isTableBody(AuthorElement node) {
        return this.isBodyRow(node);
    }

    @Override
    public boolean isTableCell(AuthorElement node) {
        AttrValue classAttr = node.getAttribute(ATTRIBUTE_CLASS);
        return classAttr != null && classAttr.getValue().contains(" topic/stentry ");
    }

    @Override
    public String getElementTag(int elementType) {
        String elementName = "";
        switch (elementType) {
            case 1: {
                elementName = STROW;
                break;
            }
            case 2: {
                elementName = STHEAD;
                break;
            }
            case 6: {
                elementName = STENTRY;
                break;
            }
        }
        return elementName;
    }
}

